/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.layer;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.plugins.piclayer.layer.kml.KMLGroundOverlay;

public class PicLayerFromKML
extends PicLayerAbstract {
    private KMLGroundOverlay calibration;
    private File picture;
    private String pictureName;

    public PicLayerFromKML(File main, KMLGroundOverlay calibration) {
        this.picture = new File(main.getParent() + File.separatorChar + calibration.getFileName());
        this.calibration = calibration;
        this.pictureName = calibration.getName();
        this.setName(this.picture.getName());
    }

    protected Image createImage() throws IOException {
        BufferedImage image = ImageIO.read(this.picture);
        return image;
    }

    protected void lookForCalibration() throws IOException {
        if (this.calibration != null) {
            this.loadCalibration(this.calibration);
        }
    }

    public String getPicLayerName() {
        return this.pictureName;
    }

    public void loadCalibration(KMLGroundOverlay cal) {
        int w = this.image.getWidth(null);
        int h = this.image.getHeight(null);
        LatLon coord1 = new LatLon(cal.getNorth(), cal.getEast());
        LatLon coord2 = new LatLon(cal.getSouth(), cal.getWest());
        EastNorth en1 = this.projection.latlon2eastNorth(coord1);
        EastNorth en2 = this.projection.latlon2eastNorth(coord2);
        EastNorth imagePosition = new EastNorth((en1.getX() + en2.getX()) / 2.0, (en1.getY() + en2.getY()) / 2.0);
        this.transformer.setImagePosition(imagePosition);
        this.initialImageScale = 100.0 * this.getMetersPerEasting(imagePosition);
        AffineTransform transform = AffineTransform.getScaleInstance((en1.getX() - en2.getX()) / (double)w, (en1.getY() - en2.getY()) / (double)h);
        transform.rotate(cal.getRotate() / 180.0 * Math.PI);
        this.transformer.resetCalibration();
        this.transformer.getTransform().concatenate(transform);
    }
}

