/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.LaneGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;

abstract class State {
    State() {
    }

    State delete() {
        return this;
    }

    State carryOver(GuiContainer newContainer) {
        return this;
    }

    static class OutgoingActive
    extends State {
        private final LaneGui lane;

        public OutgoingActive(LaneGui lane) {
            this.lane = lane;
        }

        public LaneGui getLane() {
            return this.lane;
        }

        @Override
        State delete() {
            if (!this.lane.getModel().isExtra()) {
                return this;
            }
            this.lane.getModel().remove();
            return new Invalid(this);
        }

        @Override
        State carryOver(GuiContainer newContainer) {
            if (newContainer.equals(this.lane.getContainer())) {
                return this;
            }
            Lane model = this.lane.getModel();
            Junction newJunction = newContainer.getModel().getJunction(model.getOutgoingJunction().getNode());
            for (Road.End e : newJunction.getRoadEnds()) {
                if (!e.isToEnd() || !e.getWay().equals((Object)model.getOutgoingRoadEnd().getWay())) continue;
                for (Lane l : e.getLanes()) {
                    if (l.getKind() != model.getKind() || l.getIndex() != model.getIndex()) continue;
                    return new OutgoingActive(newContainer.getGui(l));
                }
            }
            return new Default();
        }
    }

    static class IncomingActive
    extends State {
        private final Road.End roadEnd;

        public IncomingActive(Road.End roadEnd) {
            this.roadEnd = roadEnd;
        }

        public Road.End getRoadEnd() {
            return this.roadEnd;
        }

        @Override
        State carryOver(GuiContainer newContainer) {
            if (newContainer.getModel().equals(this.roadEnd.getRoad().getContainer())) {
                return this;
            }
            Junction newJunction = newContainer.getModel().getJunction(this.roadEnd.getJunction().getNode());
            for (Road.End e : newJunction.getRoadEnds()) {
                if (!e.isToEnd() || !e.getWay().equals((Object)this.roadEnd.getWay())) continue;
                return new IncomingActive(e);
            }
            return new Default();
        }
    }

    static class Default
    extends State {
    }

    static class Dirty
    extends State {
        private final State wrapped;

        public Dirty(State wrapped) {
            this.wrapped = wrapped;
        }

        public State unwrap() {
            return this.wrapped;
        }

        @Override
        State carryOver(GuiContainer newContainer) {
            return new Dirty(this.wrapped.carryOver(newContainer));
        }
    }

    static class Invalid
    extends State {
        private final State wrapped;

        public Invalid(State wrapped) {
            this.wrapped = wrapped;
        }

        public State unwrap() {
            return this.wrapped;
        }
    }

    static class Connecting
    extends State {
        private final Lane lane;
        private final List<RoadGui.ViaConnector> vias;

        public Connecting(Lane lane) {
            this(lane, Collections.emptyList());
        }

        public Connecting(Lane lane, List<RoadGui.ViaConnector> vias) {
            this.lane = lane;
            this.vias = vias;
        }

        public Connecting next(RoadGui.ViaConnector via) {
            if (this.vias.isEmpty()) {
                return new Connecting(this.lane, Collections.unmodifiableList(Arrays.asList(via)));
            }
            ArrayList<RoadGui.ViaConnector> tmp = new ArrayList<RoadGui.ViaConnector>(this.vias.size() + 1);
            boolean even = (this.vias.size() & 1) == 0;
            RoadGui.ViaConnector last = this.vias.get(this.vias.size() - 1);
            if (last.equals(via) || !even && last.getRoadEnd().getJunction().equals(via.getRoadEnd().getJunction())) {
                return this.pop().next(via);
            }
            if (this.vias.size() >= 2) {
                if (this.lane.getOutgoingJunction().equals(via.getRoadEnd().getJunction())) {
                    return new Connecting(this.lane);
                }
                if (via.equals(this.getBacktrackViaConnector())) {
                    return new Connecting(this.lane, this.vias.subList(0, this.vias.size() - 1));
                }
            }
            for (RoadGui.ViaConnector v : this.vias) {
                tmp.add(v);
                if (even && v.equals(last) || !v.getRoadEnd().getJunction().equals(via.getRoadEnd().getJunction())) continue;
                return new Connecting(this.lane, Collections.unmodifiableList(tmp));
            }
            tmp.add(via);
            return new Connecting(this.lane, Collections.unmodifiableList(tmp));
        }

        public Junction getJunction() {
            return this.vias.isEmpty() ? this.lane.getOutgoingJunction() : this.vias.get(this.vias.size() - 1).getRoadEnd().getJunction();
        }

        public RoadGui.ViaConnector getBacktrackViaConnector() {
            return this.vias.size() < 2 ? null : this.vias.get(this.vias.size() - 2);
        }

        public List<RoadGui.ViaConnector> getViaConnectors() {
            return this.vias;
        }

        public Lane getLane() {
            return this.lane;
        }

        public Connecting pop() {
            return new Connecting(this.lane, this.vias.subList(0, this.vias.size() - 1));
        }
    }

    static class AllTurns
    extends State {
        private final State wrapped;

        public AllTurns(State wrapped) {
            this.wrapped = wrapped;
        }

        public State unwrap() {
            return this.wrapped;
        }

        @Override
        State carryOver(GuiContainer newContainer) {
            return new AllTurns(this.wrapped.carryOver(newContainer));
        }
    }
}

