/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.InteractiveElement;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.State;
import org.openstreetmap.josm.plugins.turnlanes.model.UnexpectedDataException;
import org.openstreetmap.josm.tools.I18n;

class JunctionPane
extends JComponent {
    private static final long serialVersionUID = 6917061040674799271L;
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private final MouseInputProcessor mip = new MouseInputProcessor();
    private GuiContainer container;
    private final JLabel error = new JLabel("");
    private int width = 0;
    private int height = 0;
    private double rotation = 0.0;
    private double scale = 10.0;
    private double translationX = 0.0;
    private double translationY = 0.0;
    private boolean dirty = true;
    private BufferedImage passive;
    private BufferedImage interactive;
    private final NavigableMap<Integer, List<InteractiveElement>> interactives = new TreeMap<Integer, List<InteractiveElement>>();
    private State state;
    private InteractiveElement dragging;

    public JunctionPane(GuiContainer container) {
        this.setJunction(container);
        this.setLayout(new GridBagLayout());
        this.error.setOpaque(false);
        this.add((Component)this.error, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.setFocusable(true);
        this.getInputMap().put(KeyStroke.getKeyStroke(116, 0), "refresh");
        this.getActionMap().put("refresh", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.setState(new State.Invalid(JunctionPane.this.state));
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(521, 0), "zoomIn");
        this.getInputMap().put(KeyStroke.getKeyStroke(107, 0), "zoomIn");
        this.getActionMap().put("zoomIn", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.scale(Math.pow(0.8, -1.0));
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(45, 0), "zoomOut");
        this.getInputMap().put(KeyStroke.getKeyStroke(109, 0), "zoomOut");
        this.getActionMap().put("zoomOut", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.scale(Math.pow(0.8, 1.0));
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "center");
        this.getActionMap().put("center", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.center();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(65, 128), "toggleAllTurns");
        this.getActionMap().put("toggleAllTurns", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.toggleAllTurns();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(76, 128), "rotateLeft");
        this.getActionMap().put("rotateLeft", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.rotation -= Math.PI / 180;
                JunctionPane.this.setState(new State.Dirty(JunctionPane.this.state));
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(82, 128), "rotateRight");
        this.getActionMap().put("rotateRight", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.rotation += Math.PI / 180;
                JunctionPane.this.setState(new State.Dirty(JunctionPane.this.state));
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JunctionPane.this.setState(JunctionPane.this.state.delete());
            }
        });
    }

    public void setJunction(GuiContainer container) {
        this.removeMouseListener(this.mip);
        this.removeMouseMotionListener(this.mip);
        this.removeMouseWheelListener(this.mip);
        this.interactives.clear();
        this.dragging = null;
        this.container = container;
        this.center();
        this.setState(new State.Invalid(new State.Default()));
        this.addMouseListener(this.mip);
        this.addMouseMotionListener(this.mip);
        this.addMouseWheelListener(this.mip);
    }

    private void center() {
        Rectangle2D bounds = this.container.getBounds();
        this.rotation = 0.0;
        this.scale = Math.min((double)(this.getHeight() / 2) / bounds.getHeight(), (double)(this.getWidth() / 2) / bounds.getWidth());
        this.translationX = -bounds.getCenterX();
        this.translationY = -bounds.getCenterY();
        this.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
    }

    private void toggleAllTurns() {
        if (this.state instanceof State.AllTurns) {
            this.setState(((State.AllTurns)this.state).unwrap());
        } else {
            this.setState(new State.AllTurns(this.state));
        }
    }

    private void setState(State state) {
        this.error.setText("");
        if (state instanceof State.AllTurns) {
            this.dirty = true;
            this.state = state;
        } else if (state instanceof State.Invalid) {
            this.dirty = true;
            this.setState(((State.Invalid)state).unwrap());
            try {
                GuiContainer old = this.container;
                this.container = this.container.recalculate();
                if (old.isEmpty() != this.container.isEmpty()) {
                    this.center();
                }
            }
            catch (UnexpectedDataException e) {
                this.displayError(e);
            }
            catch (RuntimeException e) {
                this.displayError(e);
            }
        } else if (state instanceof State.Dirty) {
            this.dirty = true;
            this.setState(((State.Dirty)state).unwrap());
        } else {
            this.state = state.carryOver(this.container);
        }
        this.repaint();
    }

    private void displayError(UnexpectedDataException e) {
        if (e.getKind() == UnexpectedDataException.Kind.MISSING_TAG && UnexpectedDataException.Kind.MISSING_TAG.format("lanes").equals(e.getMessage())) {
            this.error.setText(I18n.tr((String)"<html>The number of lanes is not specified for one or more roads; please add missing lanes tags.</html>", (Object[])new Object[0]));
        } else {
            this.displayError((RuntimeException)e);
        }
    }

    private void displayError(RuntimeException e) {
        this.error.setText(I18n.tr((String)"<html>An error occurred while constructing the model. Please run the validator to make sure the data is consistent.<br><br>Error: {0}</html>", (Object[])new Object[]{e.getMessage()}));
    }

    void scale(int x, int y, double scale) {
        this.scale *= scale;
        double w = this.getWidth();
        double h = this.getHeight();
        this.translationX -= w * (scale - 1.0) / (2.0 * this.scale);
        this.translationY -= h * (scale - 1.0) / (2.0 * this.scale);
        this.dirty = true;
        this.repaint();
    }

    void scale(double scale) {
        this.scale(this.getWidth() / 2, this.getHeight() / 2, scale);
    }

    void translate(double x, double y) {
        this.translationX += x / this.scale;
        this.translationY += y / this.scale;
        this.dirty = true;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getWidth() != this.width || this.getHeight() != this.height) {
            this.translate((double)(this.getWidth() - this.width) / 2.0, (double)(this.getHeight() - this.height) / 2.0);
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.passive = new BufferedImage(this.width, this.height, 5);
            this.interactive = new BufferedImage(this.width, this.height, 2);
        }
        if (this.dirty) {
            this.paintPassive((Graphics2D)this.passive.getGraphics());
            this.dirty = false;
        }
        this.paintInteractive((Graphics2D)this.interactive.getGraphics());
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(this.passive, 0, 0, this.getWidth(), this.getHeight(), null);
        g2d.drawImage(this.interactive, 0, 0, this.getWidth(), this.getHeight(), null);
        this.paintChildren(g);
    }

    private void paintInteractive(Graphics2D g2d) {
        g2d.setBackground(TRANSPARENT);
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.scale(this.scale, this.scale);
        g2d.translate(this.translationX, this.translationY);
        g2d.rotate(this.rotation);
        g2d.setComposite(AlphaComposite.getInstance(2, 0.7f));
        for (Map.Entry e : this.interactives.entrySet()) {
            for (InteractiveElement ie : (List)e.getValue()) {
                ie.paintBackground(g2d, this.state);
            }
            for (InteractiveElement ie : (List)e.getValue()) {
                ie.paint(g2d, this.state);
            }
        }
    }

    private List<InteractiveElement> interactives() {
        ArrayList<InteractiveElement> result = new ArrayList<InteractiveElement>();
        for (List ies : this.interactives.descendingMap().values()) {
            result.addAll(ies);
        }
        return result;
    }

    private void paintPassive(Graphics2D g2d) {
        this.interactives.clear();
        g2d.setBackground(new Color(100, 160, 240));
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2d.scale(this.scale, this.scale);
        g2d.translate(this.translationX, this.translationY);
        g2d.rotate(this.rotation);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.GRAY);
        for (RoadGui r : this.container.getRoads()) {
            this.addAllInteractives(r.paint(g2d));
        }
        for (JunctionGui j : this.container.getJunctions()) {
            this.addAllInteractives(j.paint(g2d));
            JunctionPane.dot(g2d, new Point2D.Double(j.x, j.y), this.container.getLaneWidth() / 5.0);
        }
    }

    private void addAllInteractives(List<InteractiveElement> ies) {
        for (InteractiveElement ie : ies) {
            ArrayList<InteractiveElement> list;
            ArrayList<InteractiveElement> existing = (ArrayList<InteractiveElement>)this.interactives.get(ie.getZIndex());
            if (existing == null) {
                list = new ArrayList<InteractiveElement>();
                this.interactives.put(ie.getZIndex(), list);
            } else {
                list = existing;
            }
            list.add(ie);
        }
    }

    static void dot(Graphics2D g2d, Point2D p, double r, Color c) {
        Color old = g2d.getColor();
        g2d.setColor(c);
        g2d.fill(new Ellipse2D.Double(p.getX() - r, p.getY() - r, 2.0 * r, 2.0 * r));
        g2d.setColor(old);
    }

    static void dot(Graphics2D g2d, Point2D p, double r) {
        JunctionPane.dot(g2d, p, r, Color.RED);
    }

    void refresh() {
        this.setState(new State.Invalid(this.state));
    }

    private final class MouseInputProcessor
    extends MouseAdapter {
        private int originX;
        private int originY;
        private int button;

        private MouseInputProcessor() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JunctionPane.this.requestFocus();
            this.button = e.getButton();
            if (this.button == 1) {
                Point2D mouse = this.translateMouseCoords(e);
                for (InteractiveElement ie : JunctionPane.this.interactives()) {
                    if (!ie.contains(mouse, JunctionPane.this.state)) continue;
                    JunctionPane.this.setState(ie.activate(JunctionPane.this.state));
                    JunctionPane.this.repaint();
                    break;
                }
            }
            this.originX = e.getX();
            this.originY = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JunctionPane.this.dragging != null) {
                Point2D mouse = this.translateMouseCoords(e);
                JunctionPane.this.setState(JunctionPane.this.dragging.drop(mouse.getX(), mouse.getY(), this.dropTarget(mouse), JunctionPane.this.state));
            }
            JunctionPane.this.dragging = null;
            JunctionPane.this.repaint();
        }

        private InteractiveElement dropTarget(Point2D mouse) {
            for (InteractiveElement ie : JunctionPane.this.interactives()) {
                if (!ie.contains(mouse, JunctionPane.this.state)) continue;
                return ie;
            }
            return null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.button == 1) {
                Point2D mouse = this.translateMouseCoords(e);
                for (InteractiveElement ie : JunctionPane.this.interactives()) {
                    if (!ie.contains(mouse, JunctionPane.this.state)) continue;
                    JunctionPane.this.setState(ie.click(JunctionPane.this.state));
                    break;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.button == 1) {
                Point2D mouse = this.translateMouseCoords(e);
                if (JunctionPane.this.dragging == null) {
                    Point2D origin = this.translateCoords(this.originX, this.originY);
                    for (InteractiveElement ie : JunctionPane.this.interactives()) {
                        if (!ie.contains(origin, JunctionPane.this.state)) continue;
                        if (!ie.beginDrag(origin.getX(), origin.getY())) break;
                        JunctionPane.this.dragging = ie;
                        break;
                    }
                }
                if (JunctionPane.this.dragging != null) {
                    JunctionPane.this.setState(JunctionPane.this.dragging.drag(mouse.getX(), mouse.getY(), this.dropTarget(mouse), JunctionPane.this.state));
                }
            } else if (this.button == 3) {
                JunctionPane.this.translate(e.getX() - this.originX, e.getY() - this.originY);
                this.originX = e.getX();
                this.originY = e.getY();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JunctionPane.this.scale(e.getX(), e.getY(), Math.pow(0.8, e.getWheelRotation()));
        }

        private Point2D translateMouseCoords(MouseEvent e) {
            return this.translateCoords(e.getX(), e.getY());
        }

        private Point2D translateCoords(int x, int y) {
            double c = Math.cos(-JunctionPane.this.rotation);
            double s = Math.sin(-JunctionPane.this.rotation);
            double x2 = -JunctionPane.this.translationX + (double)x / JunctionPane.this.scale;
            double y2 = -JunctionPane.this.translationY + (double)y / JunctionPane.this.scale;
            return new Point2D.Double(x2 * c - y2 * s, x2 * s + y2 * c);
        }
    }
}

