/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.undelete;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.undelete.UndeleteDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UndeleteAction
extends JosmAction {
    public UndeleteAction() {
        super(I18n.tr((String)"Undelete object...", (Object[])new Object[0]), "undelete", I18n.tr((String)"Undelete object by id", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:undelete", (String)I18n.tr((String)"File: {0}", (Object[])new Object[]{I18n.tr((String)"Undelete object...", (Object[])new Object[0])}), (int)85, (int)5007), true);
    }

    public void actionPerformed(ActionEvent e) {
        UndeleteDialog dialog = new UndeleteDialog(Main.parent);
        if (dialog.showDialog().getValue() != 1) {
            return;
        }
        Main.pref.put("undelete.newlayer", dialog.isNewLayerSelected());
        Main.pref.put("undelete.osmid", dialog.getOsmIdsString());
        this.undelete(dialog.isNewLayerSelected(), dialog.getOsmIds(), 0L);
    }

    public void undelete(boolean newLayer, final List<PrimitiveId> ids, final long parent) {
        OsmDataLayer tmpLayer = Main.main.getEditLayer();
        if (tmpLayer == null || newLayer) {
            tmpLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer((Layer)tmpLayer);
        }
        final DataSet datas = tmpLayer.data;
        final OsmDataLayer layer = tmpLayer;
        HistoryLoadTask task = new HistoryLoadTask();
        for (PrimitiveId id : ids) {
            task.add(id);
        }
        Main.worker.execute((Runnable)task);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (PrimitiveId pid : ids) {
                    HistoryOsmPrimitive hPrimitive2;
                    Relation primitive;
                    Long id = pid.getUniqueId();
                    OsmPrimitiveType type = pid.getType();
                    History h = HistoryDataSet.getInstance().getHistory(id.longValue(), type);
                    HistoryOsmPrimitive hPrimitive1 = h.getLatest();
                    boolean visible = hPrimitive1.isVisible();
                    if (visible) {
                        DownloadPrimitivesTask download = new DownloadPrimitivesTask(layer, Collections.singletonList(pid), true);
                        System.out.println(I18n.tr((String)"Will get {0}", (Object[])new Object[]{pid}));
                        download.run();
                        System.out.println(I18n.tr((String)"Looking for {0}", (Object[])new Object[]{pid}));
                        primitive = datas.getPrimitiveById(id.longValue(), type);
                        System.out.println(I18n.tr((String)"Found {0}", (Object[])new Object[]{String.valueOf(primitive.getId())}));
                        if (parent <= 0L || !type.equals((Object)OsmPrimitiveType.NODE)) continue;
                        nodes.add((Node)primitive);
                        continue;
                    }
                    if (type.equals((Object)OsmPrimitiveType.NODE)) {
                        hPrimitive2 = h.getByVersion((long)(h.getNumVersions() - 1));
                        Node node = new Node(id.longValue(), (int)hPrimitive1.getVersion());
                        HistoryNode hNode = (HistoryNode)hPrimitive2;
                        node.setCoor(hNode.getCoords());
                        primitive = node;
                        if (parent > 0L) {
                            nodes.add(node);
                        }
                    } else if (type.equals((Object)OsmPrimitiveType.WAY)) {
                        hPrimitive1 = h.getLatest();
                        hPrimitive2 = h.getByVersion((long)(h.getNumVersions() - 1));
                        Way way = new Way(id.longValue(), (int)hPrimitive1.getVersion());
                        HistoryWay hWay = (HistoryWay)hPrimitive2;
                        ArrayList<PrimitiveId> nodeIds = new ArrayList<PrimitiveId>();
                        for (Long i : hWay.getNodes()) {
                            nodeIds.add((PrimitiveId)new SimplePrimitiveId(i.longValue(), OsmPrimitiveType.NODE));
                        }
                        UndeleteAction.this.undelete(false, nodeIds, id);
                        primitive = way;
                    } else {
                        primitive = new Relation();
                        hPrimitive1 = h.getLatest();
                        hPrimitive2 = h.getByVersion((long)(h.getNumVersions() - 1));
                        Relation rel = new Relation(id.longValue(), (int)hPrimitive1.getVersion());
                        HistoryRelation hRel = (HistoryRelation)hPrimitive2;
                        ArrayList<RelationMember> members = new ArrayList<RelationMember>(hRel.getNumMembers());
                        for (RelationMemberData m : hRel.getMembers()) {
                            OsmPrimitive p = datas.getPrimitiveById(m.getMemberId(), m.getMemberType());
                            if (p == null) {
                                switch (m.getMemberType()) {
                                    case NODE: {
                                        p = new Node(m.getMemberId());
                                        break;
                                    }
                                    case CLOSEDWAY: 
                                    case WAY: {
                                        p = new Way(m.getMemberId());
                                        break;
                                    }
                                    case MULTIPOLYGON: 
                                    case RELATION: {
                                        p = new Relation(m.getMemberId());
                                    }
                                }
                                datas.addPrimitive(p);
                            }
                            members.add(new RelationMember(m.getRole(), p));
                        }
                        rel.setMembers(members);
                        primitive = rel;
                    }
                    primitive.setUser(hPrimitive1.getUser());
                    primitive.setKeys(hPrimitive2.getTags());
                    primitive.put("history", "retrieved using undelete JOSM plugin");
                    primitive.setModified(true);
                    datas.addPrimitive((OsmPrimitive)primitive);
                }
                if (parent > 0L && !ids.isEmpty() && ((PrimitiveId)ids.iterator().next()).getType().equals((Object)OsmPrimitiveType.NODE)) {
                    Way parentWay = (Way)datas.getPrimitiveById(parent, OsmPrimitiveType.WAY);
                    parentWay.setNodes(nodes);
                }
            }
        };
        Main.worker.submit(r);
    }
}

