/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor.action;

import at.dallermassl.josm.plugin.surveyor.GpsActionEvent;
import at.dallermassl.josm.plugin.surveyor.SurveyorAction;
import at.dallermassl.josm.plugin.surveyor.SurveyorLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dinopolis.util.collection.Tuple;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNodeAction
implements SurveyorAction {
    private Collection<Tuple<String, String>> keyValues;

    @Override
    public void setParameters(List<String> parameters) {
        this.keyValues = new ArrayList<Tuple<String, String>>();
        for (String keyValuePair : parameters) {
            int pos = keyValuePair.indexOf(61);
            if (pos > 0) {
                String key = keyValuePair.substring(0, pos);
                String value = keyValuePair.substring(pos + 1);
                this.keyValues.add(new Tuple<String, String>(key, value));
                continue;
            }
            System.err.println("SetNodeAction: ignoring invalid key value pair: " + keyValuePair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(GpsActionEvent event) {
        LatLon coordinates = event.getCoordinates();
        Node node = new Node(coordinates);
        for (Tuple<String, String> entry : this.keyValues) {
            node.put((String)entry.getKey(), (String)entry.getValue());
        }
        Class<SurveyorLock> clazz = SurveyorLock.class;
        synchronized (SurveyorLock.class) {
            DataSet ds = Main.main.getCurrentDataSet();
            if (ds != null) {
                ds.addPrimitive((OsmPrimitive)node);
                ds.setSelected(new PrimitiveId[]{node});
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Main.map.repaint();
            return;
        }
    }
}

