/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.version;

import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private final String version;
    private final int major;
    private final int minor;
    private final int revision;
    private final String extra;

    public Version(String version) {
        this.version = version;
        String[] parts = Pattern.compile("[.-]|\\s").split(version);
        this.major = Integer.parseInt(parts[0]);
        this.minor = Integer.parseInt(parts[1]);
        this.revision = Integer.parseInt(parts[2]);
        this.extra = parts.length > 3 ? parts[3] : null;
    }

    public String version() {
        return this.version;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int revision() {
        return this.revision;
    }

    public String extra() {
        return this.extra;
    }

    public boolean atLeast(Version required) {
        return this.compareTo(required) >= 0;
    }

    @Override
    public int compareTo(Version o) {
        if (this.major == o.major) {
            if (this.minor == o.minor) {
                if (this.revision == o.revision) {
                    return 0;
                }
                return this.revision - o.revision;
            }
            return this.minor - o.minor;
        }
        return this.major - o.major;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.version);
        return sb.toString();
    }
}

