/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoKeyEntry;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.PixelScale;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;

public final class GeoTiffException
extends IOException {
    private static final long serialVersionUID = 1008533682021487024L;
    private GeoTiffIIOMetadataDecoder metadata = null;

    public GeoTiffException(GeoTiffIIOMetadataDecoder metadata, String msg, Throwable t) {
        super(msg);
        this.metadata = metadata;
        if (t != null) {
            this.initCause(t);
        }
    }

    public AffineTransform getModelTransformation() {
        if (this.metadata != null) {
            return this.metadata.getModelTransformation();
        }
        return null;
    }

    public GeoKeyEntry[] getGeoKeys() {
        return this.metadata != null ? (GeoKeyEntry[])this.metadata.getGeoKeys().toArray() : null;
    }

    @Override
    public String getMessage() {
        StringWriter text = new StringWriter(1024);
        PrintWriter message = new PrintWriter(text);
        message.println("GEOTIFF Module Error Report");
        message.println(super.getMessage());
        message.print("ModelPixelScaleTag: ");
        if (this.metadata != null) {
            PixelScale modelPixelScales = this.metadata.getModelPixelScales();
            if (modelPixelScales != null) {
                message.println("[" + modelPixelScales.getScaleX() + "," + modelPixelScales.getScaleY() + "," + modelPixelScales.getScaleZ() + "]");
            } else {
                message.println("NOT AVAILABLE");
            }
        } else {
            message.println("NOT AVAILABLE");
        }
        message.print("ModelTiePointTag: ");
        if (this.metadata != null) {
            TiePoint[] modelTiePoints = this.metadata.getModelTiePoints();
            if (modelTiePoints != null) {
                int numTiePoints = modelTiePoints.length;
                message.println("(" + numTiePoints + " tie points)");
                for (int i = 0; i < numTiePoints; ++i) {
                    message.print("TP #" + i + ": ");
                    message.print("[" + modelTiePoints[i].getValueAt(0));
                    message.print("," + modelTiePoints[i].getValueAt(1));
                    message.print("," + modelTiePoints[i].getValueAt(2));
                    message.print("] -> [" + modelTiePoints[i].getValueAt(3));
                    message.print("," + modelTiePoints[i].getValueAt(4));
                    message.println("," + modelTiePoints[i].getValueAt(5) + "]");
                }
            } else {
                message.println("NOT AVAILABLE");
            }
        } else {
            message.println("NOT AVAILABLE");
        }
        message.print("ModelTransformationTag: ");
        AffineTransform modelTransformation = this.getModelTransformation();
        if (modelTransformation != null) {
            message.println("[");
            message.print(" [" + modelTransformation.getScaleX());
            message.print("," + modelTransformation.getShearX());
            message.print("," + modelTransformation.getScaleY());
            message.print("," + modelTransformation.getShearY());
            message.print("," + modelTransformation.getTranslateX());
            message.print("," + modelTransformation.getTranslateY() + "]");
            message.println("]");
        } else {
            message.println("NOT AVAILABLE");
        }
        int i = 1;
        for (GeoKeyEntry geokey : this.metadata.getGeoKeys()) {
            message.print("GeoKey #" + i + ": ");
            message.println("Key = " + geokey.getKeyID() + ", Value = " + this.metadata.getGeoKey(geokey.getKeyID()));
            ++i;
        }
        Throwable t = this.getCause();
        if (t != null) {
            t.printStackTrace(message);
        }
        message.close();
        return text.toString();
    }
}

