/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;

public class TextTagParser {
    int start = 0;
    boolean keyFound = false;
    boolean quotesStarted = false;
    boolean esc = false;
    StringBuilder s = new StringBuilder(200);
    int pos = 0;
    String data;
    int n;
    boolean notFound;

    public TextTagParser(String text) {
        this.data = text;
        this.n = this.data.length();
    }

    Map<String, String> getFreeParsedTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        while (true) {
            this.skipEmpty();
            if (this.pos == this.n) break;
            String k = this.parseString(true);
            if (this.pos == this.n) {
                tags.clear();
                break;
            }
            this.skipSign();
            if (this.pos == this.n) {
                tags.clear();
                break;
            }
            String v = this.parseString(false);
            tags.put(k, v);
        }
        return tags;
    }

    private String parseString(boolean stopOnEquals) {
        while (this.pos < this.n) {
            char c = this.data.charAt(this.pos);
            if (this.esc) {
                this.esc = false;
                this.s.append(c);
            } else if (c == '\\') {
                this.esc = true;
            } else if (c == '\"' && !this.quotesStarted) {
                if (this.s.toString().trim().length() > 0) {
                    this.s.append(c);
                } else {
                    this.s.delete(0, this.s.length());
                    this.quotesStarted = true;
                }
            } else {
                if (c == '\"' && this.quotesStarted) {
                    this.quotesStarted = false;
                    ++this.pos;
                    break;
                }
                if (!this.quotesStarted && (c == '\n' || c == '\t' || c == ' ' || c == '\r' || c == '=' && stopOnEquals)) {
                    ++this.pos;
                    break;
                }
                if (c >= ' ') {
                    this.s.append(c);
                }
            }
            ++this.pos;
        }
        String res = this.s.toString();
        this.s.delete(0, this.s.length());
        return res.trim();
    }

    private void skipSign() {
        boolean signFound = false;
        while (this.pos < this.n) {
            char c = this.data.charAt(this.pos);
            if (c == '\t' || c == '\n' || c == ' ') {
                ++this.pos;
                continue;
            }
            if (c != '=' || signFound) break;
            signFound = true;
            ++this.pos;
        }
    }

    private void skipEmpty() {
        char c;
        while (this.pos < this.n && ((c = this.data.charAt(this.pos)) == '\t' || c == '\n' || c == '\r' || c == ' ')) {
            ++this.pos;
        }
    }

    private static String unescape(String k) {
        if (!k.startsWith("\"") || !k.endsWith("\"")) {
            if (k.contains("=")) {
                return null;
            }
            return k;
        }
        String text = k.substring(1, k.length() - 1);
        return new TextTagParser(text).parseString(false);
    }

    public static Map<String, String> readTagsByRegexp(String text, String splitRegex, String tagRegex, boolean unescapeTextInQuotes) {
        String[] lines = text.split(splitRegex);
        Pattern p = Pattern.compile(tagRegex);
        HashMap<String, String> tags = new HashMap<String, String>();
        String k = null;
        String v = null;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            Matcher m = p.matcher(line);
            if (m.matches()) {
                k = m.group(1).trim();
                v = m.group(2).trim();
                if (unescapeTextInQuotes) {
                    k = TextTagParser.unescape(k);
                    v = TextTagParser.unescape(v);
                    if (k == null || v == null) {
                        return null;
                    }
                }
                tags.put(k, v);
                continue;
            }
            return null;
        }
        if (!tags.isEmpty()) {
            return tags;
        }
        return null;
    }

    public static Map<String, String> getTagsFromText(String buf) {
        Map<String, String> tags = TextTagParser.readTagsFromText(buf);
        return TextTagParser.validateTags(tags) ? tags : null;
    }

    public static Map<String, String> readTagsFromText(String buf) {
        Map<String, String> tags = TextTagParser.readTagsByRegexp(buf, "[\r\n]+]", "(.*?)\t(.*?)", false);
        if (tags != null) {
            return tags;
        }
        tags = TextTagParser.readTagsByRegexp(buf, "[\\n\\t\\r]+", "(.*?)=(.*?)", true);
        if (tags != null) {
            return tags;
        }
        String bufJson = buf.trim();
        if (bufJson.startsWith("{") && bufJson.endsWith("}")) {
            bufJson = bufJson.substring(1, bufJson.length() - 1);
        }
        if ((tags = TextTagParser.readTagsByRegexp(bufJson, "[\\s]*,[\\s]*", "[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*:[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*", true)) != null) {
            return tags;
        }
        TextTagParser parser = new TextTagParser(buf);
        tags = parser.getFreeParsedTags();
        return tags;
    }

    private static boolean validateTags(Map<String, String> tags) {
        int r;
        int s = tags.size();
        if (s > 30) {
            r = TextTagParser.warning(I18n.trn((String)"There was {0} tag found in the buffer, it is suspicious!", (String)"There were {0} tags found in the buffer, it is suspicious!", (long)s, (Object[])new Object[]{s}), "", "toomanytags");
            if (r == 2) {
                return false;
            }
            if (r == 3) {
                return true;
            }
        }
        for (String key : tags.keySet()) {
            String value = tags.get(key);
            if (key.length() > 50) {
                r = TextTagParser.warning(I18n.tr((String)"Key is too long:", (Object[])new Object[0]), key + "=" + value, "keytoolong");
                if (r == 2) {
                    return false;
                }
                if (r == 3) {
                    return true;
                }
            }
            if (!key.matches("[a-zA-Z:_]*")) {
                r = TextTagParser.warning(I18n.tr((String)"Suspiciouns characters in tag:", (Object[])new Object[0]), key, "keydoesnotmatch");
                if (r == 2) {
                    return false;
                }
                if (r == 3) {
                    return true;
                }
            }
            if (value.length() <= 255) continue;
            r = TextTagParser.warning(I18n.tr((String)"Value too long (max 255 characters):", (Object[])new Object[0]), value, "valuetoolong");
            if (r == 2) {
                return false;
            }
            if (r != 3) continue;
            return true;
        }
        return true;
    }

    private static int warning(String text, String data, String code) {
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr((String)"Do you want to paste these tags?", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Ingore warnings", (Object[])new Object[0])});
        ed.setButtonIcons(new String[]{"ok.png", "cancel.png", "pastetags.png"});
        ed.setContent("<html><b>" + text + "</b><br/><br/> <div width=\"300px\">" + XmlWriter.encode((String)data, (boolean)true) + "</html>");
        ed.setDefaultButton(2);
        ed.setCancelButton(new Integer[]{2});
        ed.setIcon(2);
        ed.toggleEnable(code);
        ed.showDialog();
        Integer o = ed.getValue();
        if (o instanceof Integer) {
            return o;
        }
        return 2;
    }
}

