/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.tilecache;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.CachedTile;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import org.jaitools.CollectionFactory;
import org.jaitools.DaemonThreadFactory;
import org.jaitools.tilecache.DiskCacheFailedException;
import org.jaitools.tilecache.DiskCachedTile;
import org.jaitools.tilecache.DiskMemTileCacheVisitor;
import org.jaitools.tilecache.TileAccessTimeComparator;
import org.jaitools.tilecache.TileNotResidentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskMemTileCache
extends Observable
implements TileCache {
    private static final Logger LOGGER = Logger.getLogger("org.jaitools.tilecache");
    public static final long DEFAULT_MEMORY_CAPACITY = 0x4000000L;
    public static final float DEFAULT_MEMORY_THRESHOLD = 0.75f;
    public static final long DEFAULT_AUTO_FLUSH_MEMORY_INTERVAL = 2500L;
    public static final long DEFAULT_TILE_POLLING_INTERVAL = 2000L;
    public static final String KEY_INITIAL_MEMORY_CAPACITY = "memcapacity";
    public static final String KEY_ALWAYS_DISK_CACHE = "diskcache";
    public static final String KEY_AUTO_FLUSH_MEMORY_ENABLED = "enableautoflush";
    public static final String KEY_AUTO_FLUSH_MEMORY_INTERVAL = "autoflushinterval";
    private static final Map<String, ParamDesc> paramDescriptors = new HashMap<String, ParamDesc>();
    private long memCapacity;
    private long curMemory;
    private float memThreshold;
    private boolean writeNewTilesToDisk;
    protected Map<Object, DiskCachedTile> tiles;
    protected Map<Object, Raster> residentTiles;
    private Comparator<CachedTile> comparator;
    protected List<DiskCachedTile> sortedResidentTiles;
    private boolean diagnosticsEnabled;
    private final ReentrantLock tileLock = new ReentrantLock();
    private ScheduledExecutorService flushService;
    private ScheduledFuture flushFuture;
    private long autoFlushInterval = 2500L;
    private AtomicBoolean okToFlush = new AtomicBoolean(false);
    private final ScheduledExecutorService tilePollingService;
    private ScheduledFuture tilePollingFuture;
    private long tilePollingInterval = 2000L;

    public DiskMemTileCache() {
        this(null);
    }

    public DiskMemTileCache(Map<String, Object> params) {
        long lval;
        if (params == null) {
            params = Collections.emptyMap();
        }
        this.diagnosticsEnabled = false;
        this.tiles = new HashMap<Object, DiskCachedTile>();
        this.residentTiles = CollectionFactory.map();
        this.curMemory = 0L;
        this.memThreshold = 0.75f;
        ParamDesc desc = paramDescriptors.get(KEY_INITIAL_MEMORY_CAPACITY);
        this.memCapacity = (Long)desc.defaultValue;
        Object o = params.get(desc.key);
        if (o != null && desc.typeOK(o)) {
            this.memCapacity = ((Number)o).longValue();
        }
        desc = paramDescriptors.get(KEY_ALWAYS_DISK_CACHE);
        this.writeNewTilesToDisk = (Boolean)desc.defaultValue;
        o = params.get(desc.key);
        if (o != null && desc.typeOK(o)) {
            this.writeNewTilesToDisk = (Boolean)o;
        }
        desc = paramDescriptors.get(KEY_AUTO_FLUSH_MEMORY_INTERVAL);
        this.autoFlushInterval = ((Number)desc.defaultValue).longValue();
        o = params.get(desc.key);
        if (o != null && desc.typeOK(o) && (lval = ((Number)o).longValue()) > 0L) {
            this.autoFlushInterval = lval;
        }
        desc = paramDescriptors.get(KEY_AUTO_FLUSH_MEMORY_ENABLED);
        o = params.get(desc.key);
        if (o != null && desc.typeOK(o)) {
            this.setAutoFlushMemoryEnabled((Boolean)o);
        }
        this.comparator = new TileAccessTimeComparator();
        this.sortedResidentTiles = new ArrayList<DiskCachedTile>();
        this.tilePollingService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(1, "cache-polling"));
        this.startTilePolling();
    }

    @Override
    public void add(RenderedImage owner, int tileX, int tileY, Raster data) {
        this.add(owner, tileX, tileY, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(RenderedImage owner, int tileX, int tileY, Raster data, Object tileCacheMetric) {
        this.tileLock.lock();
        try {
            this.okToFlush.set(false);
            Object key = this.getTileId(owner, tileX, tileY);
            if (this.tiles.containsKey(key)) {
                return;
            }
            DiskCachedTile tile = new DiskCachedTile(key, owner, tileX, tileY, data, this.writeNewTilesToDisk, tileCacheMetric);
            this.tiles.put(key, tile);
            if (this.makeResident(tile, data)) {
                tile.setAction(DiskCachedTile.TileAction.ACTION_ADDED_RESIDENT);
            } else {
                tile.setAction(DiskCachedTile.TileAction.ACTION_ADDED);
            }
            if (this.diagnosticsEnabled) {
                this.setChanged();
                this.notifyObservers(tile);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Unable to cache this tile on disk", ex);
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(RenderedImage owner, int tileX, int tileY) {
        this.tileLock.lock();
        try {
            this.okToFlush.set(false);
            Object key = this.getTileId(owner, tileX, tileY);
            DiskCachedTile tile = this.tiles.get(key);
            if (tile == null) {
                return;
            }
            if (this.residentTiles.containsKey(key)) {
                try {
                    this.removeResidentTile(key, false);
                }
                catch (DiskCacheFailedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            tile.deleteDiskCopy();
            tile.setAction(DiskCachedTile.TileAction.ACTION_REMOVED);
            if (this.diagnosticsEnabled) {
                this.setChanged();
                this.notifyObservers(tile);
            }
            this.tiles.remove(key);
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster getTile(RenderedImage owner, int tileX, int tileY) {
        this.tileLock.lock();
        try {
            this.okToFlush.set(false);
            Raster r = null;
            Object key = this.getTileId(owner, tileX, tileY);
            DiskCachedTile tile = this.tiles.get(key);
            if (tile != null) {
                r = this.residentTiles.get(key);
                if (r == null) {
                    r = tile.readData();
                    if (r == null) {
                        Raster raster = null;
                        return raster;
                    }
                    if (this.makeResident(tile, r)) {
                        tile.setAction(DiskCachedTile.TileAction.ACTION_RESIDENT);
                        if (this.diagnosticsEnabled) {
                            this.setChanged();
                            this.notifyObservers(tile);
                        }
                    }
                }
                tile.setAction(DiskCachedTile.TileAction.ACTION_ACCESSED);
                tile.setTileTimeStamp(System.currentTimeMillis());
                if (this.diagnosticsEnabled) {
                    this.setChanged();
                    this.notifyObservers(tile);
                }
            }
            Raster raster = r;
            return raster;
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster[] getTiles(RenderedImage owner) {
        this.tileLock.lock();
        try {
            this.okToFlush.set(false);
            int minX = owner.getMinTileX();
            int minY = owner.getMinTileY();
            int numX = owner.getNumXTiles();
            int numY = owner.getNumYTiles();
            ArrayList<Object> keys = new ArrayList<Object>();
            int y = minY;
            for (int ny = 0; ny < numY; ++ny) {
                int x = minX;
                for (int i = 0; i < numX; ++i) {
                    Object key = this.getTileId(owner, x, y);
                    if (this.tiles.containsKey(key)) {
                        keys.add(key);
                    }
                    ++x;
                }
                ++y;
            }
            Raster[] rasters = new Raster[keys.size()];
            int k = 0;
            for (Object e : keys) {
                DiskCachedTile tile = this.tiles.get(e);
                Raster r = this.residentTiles.get(tile.getTileId());
                if (r == null) {
                    r = tile.readData();
                    this.makeResident(tile, r);
                }
                rasters[k++] = r;
                tile.setTileTimeStamp(System.currentTimeMillis());
                tile.setAction(DiskCachedTile.TileAction.ACTION_ACCESSED);
                if (!this.diagnosticsEnabled) continue;
                this.setChanged();
                this.notifyObservers(tile);
            }
            Raster[] rasterArray = rasters;
            return rasterArray;
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTiles(RenderedImage owner) {
        this.tileLock.lock();
        try {
            int y = owner.getMinTileY();
            for (int ny = 0; ny < owner.getNumYTiles(); ++ny) {
                int x = owner.getMinTileX();
                for (int nx = 0; nx < owner.getNumXTiles(); ++nx) {
                    this.remove(owner, x, y);
                    ++x;
                }
                ++y;
            }
        }
        finally {
            this.tileLock.unlock();
        }
    }

    public void setTilePollingInterval(long interval) {
        if (interval > 0L && interval != this.tilePollingInterval) {
            this.stopTilePolling();
            this.tilePollingInterval = interval;
            this.startTilePolling();
        }
    }

    public long getTilePollingInterval() {
        return this.tilePollingInterval;
    }

    private void startTilePolling() {
        if (!this.isPollingTiles()) {
            this.tilePollingFuture = this.tilePollingService.scheduleAtFixedRate(new Runnable(){

                public void run() {
                    DiskMemTileCache.this.removeNullTiles();
                }
            }, this.tilePollingInterval, this.tilePollingInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void stopTilePolling() {
        if (this.isPollingTiles()) {
            this.tilePollingFuture.cancel(true);
            this.tilePollingFuture = null;
        }
    }

    private boolean isPollingTiles() {
        return this.tilePollingFuture != null && !this.tilePollingFuture.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNullTiles() {
        if (!this.tileLock.tryLock()) {
            return;
        }
        try {
            DiskCachedTile tile;
            Set<Object> nullTileKeys = CollectionFactory.set();
            for (Object key : this.tiles.keySet()) {
                tile = this.tiles.get(key);
                if (tile.getOwner() != null) continue;
                nullTileKeys.add(key);
            }
            for (Object key : nullTileKeys) {
                tile = this.tiles.get(key);
                tile.deleteDiskCopy();
                if (this.residentTiles.containsKey(key)) {
                    this.residentTiles.remove(key);
                    this.sortedResidentTiles.remove(tile);
                    this.curMemory -= tile.getTileSize();
                }
                this.tiles.remove(key);
            }
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTiles(RenderedImage owner, Point[] tileIndices, Raster[] tiles, Object tileCacheMetric) {
        if (tileIndices.length != tiles.length) {
            throw new IllegalArgumentException("tileIndices and tiles args must be the same length");
        }
        this.tileLock.lock();
        try {
            for (int i = 0; i < tiles.length; ++i) {
                this.add(owner, tileIndices[i].x, tileIndices[i].y, tiles[i], tileCacheMetric);
            }
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster[] getTiles(RenderedImage owner, Point[] tileIndices) {
        this.tileLock.lock();
        try {
            Raster[] r = null;
            if (tileIndices.length > 0) {
                r = new Raster[tileIndices.length];
                for (int i = 0; i < tileIndices.length; ++i) {
                    r[i] = this.getTile(owner, tileIndices[i].x, tileIndices[i].y);
                }
            }
            Raster[] rasterArray = r;
            return rasterArray;
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.tileLock.lock();
        try {
            this.flushMemory();
            for (DiskCachedTile tile : this.tiles.values()) {
                tile.deleteDiskCopy();
                tile.setAction(DiskCachedTile.TileAction.ACTION_REMOVED);
                if (!this.diagnosticsEnabled) continue;
                this.setChanged();
                this.notifyObservers(tile);
            }
            this.tiles.clear();
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushMemory() {
        this.tileLock.lock();
        try {
            this.residentTiles.clear();
            this.sortedResidentTiles.clear();
            this.curMemory = 0L;
        }
        finally {
            this.tileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memoryControl() {
        this.tileLock.lock();
        try {
            long maxUsed = (long)(this.memThreshold * (float)this.memCapacity);
            long toFree = this.curMemory - maxUsed;
            if (toFree > 0L) {
                this.defaultMemoryControl(toFree);
            }
        }
        finally {
            this.tileLock.unlock();
        }
    }

    private void defaultMemoryControl(long memRequired) {
        if (memRequired > this.memCapacity) {
            throw new RuntimeException("space required is greater than cache memory capacity");
        }
        Collections.sort(this.sortedResidentTiles, this.comparator);
        while (this.memCapacity - this.curMemory < memRequired && !this.sortedResidentTiles.isEmpty()) {
            Object key = this.sortedResidentTiles.get(this.sortedResidentTiles.size() - 1).getTileId();
            try {
                this.removeResidentTile(key, true);
            }
            catch (DiskCacheFailedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    @Deprecated
    public void setTileCapacity(int arg0) {
    }

    @Override
    public int getTileCapacity() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMemoryCapacity(long newCapacity) {
        this.tileLock.lock();
        try {
            this.okToFlush.set(false);
            if (newCapacity < 0L) {
                throw new IllegalArgumentException("memory capacity must be >= 0");
            }
            long oldCapacity = this.memCapacity;
            this.memCapacity = newCapacity;
            if (newCapacity == 0L) {
                this.flushMemory();
            } else if (newCapacity < oldCapacity && this.curMemory > newCapacity) {
                Collections.sort(this.sortedResidentTiles, this.comparator);
                while (this.curMemory > newCapacity) {
                    Object key = this.sortedResidentTiles.get(this.sortedResidentTiles.size() - 1).getTileId();
                    try {
                        this.removeResidentTile(key, true);
                    }
                    catch (DiskCacheFailedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        finally {
            this.tileLock.unlock();
        }
    }

    @Override
    public long getMemoryCapacity() {
        return this.memCapacity;
    }

    public long getCurrentMemory() {
        return this.curMemory;
    }

    @Override
    public void setMemoryThreshold(float newThreshold) {
        this.memThreshold = newThreshold < 0.0f ? 0.0f : (newThreshold > 1.0f ? 1.0f : newThreshold);
        this.memoryControl();
    }

    @Override
    public float getMemoryThreshold() {
        return this.memThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTileComparator(Comparator comp) {
        this.tileLock.lock();
        try {
            this.comparator = comp == null ? new TileAccessTimeComparator() : comp;
            this.sortedResidentTiles = new ArrayList<DiskCachedTile>();
            for (Object key : this.residentTiles.keySet()) {
                this.sortedResidentTiles.addAll(this.tiles.values());
            }
            Collections.sort(this.sortedResidentTiles, this.comparator);
        }
        finally {
            this.tileLock.unlock();
        }
    }

    @Override
    public Comparator getTileComparator() {
        return this.comparator;
    }

    public int getNumTiles() {
        return this.tiles.size();
    }

    public int getNumResidentTiles() {
        return this.residentTiles.size();
    }

    public boolean containsTile(RenderedImage owner, int tileX, int tileY) {
        Object key = this.getTileId(owner, tileX, tileY);
        return this.tiles.containsKey(key);
    }

    public boolean containsResidentTile(RenderedImage owner, int tileX, int tileY) {
        Object key = this.getTileId(owner, tileX, tileY);
        return this.residentTiles.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileChanged(RenderedImage owner, int tileX, int tileY) throws TileNotResidentException, DiskCacheFailedException {
        block6: {
            this.tileLock.lock();
            try {
                this.okToFlush.set(false);
                Object tileId = this.getTileId(owner, tileX, tileY);
                Raster r = this.residentTiles.get(tileId);
                if (r == null) {
                    throw new TileNotResidentException(owner, tileX, tileY);
                }
                DiskCachedTile tile = this.tiles.get(tileId);
                if (!tile.cachedToDisk()) break block6;
                try {
                    tile.writeData(r);
                }
                catch (IOException ioEx) {
                    throw new DiskCacheFailedException(owner, tileX, tileY);
                }
            }
            finally {
                this.tileLock.unlock();
            }
        }
    }

    public final void setAutoFlushMemoryEnabled(boolean enable) {
        if (enable) {
            if (!this.isAutoFlushMemoryEnabled()) {
                if (this.flushService == null) {
                    this.flushService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(1, "cache-flush"));
                }
                this.flushFuture = this.flushService.scheduleWithFixedDelay(new Runnable(){

                    public void run() {
                        if (DiskMemTileCache.this.okToFlush.getAndSet(true)) {
                            DiskMemTileCache.this.flushMemory();
                        }
                    }
                }, this.autoFlushInterval, this.autoFlushInterval, TimeUnit.MILLISECONDS);
            }
        } else if (this.isAutoFlushMemoryEnabled()) {
            this.flushFuture.cancel(true);
        }
    }

    public boolean isAutoFlushMemoryEnabled() {
        return this.flushFuture != null && !this.flushFuture.isDone();
    }

    public void setAutoFlushMemoryInterval(long interval) {
        if (interval > 0L && interval != this.autoFlushInterval) {
            if (this.isAutoFlushMemoryEnabled()) {
                this.setAutoFlushMemoryEnabled(false);
            }
            this.autoFlushInterval = interval;
            this.setAutoFlushMemoryEnabled(true);
        }
    }

    public long getAutoFlushMemoryInterval() {
        return this.autoFlushInterval;
    }

    public void setDiagnostics(boolean state) {
        this.diagnosticsEnabled = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(DiskMemTileCacheVisitor visitor) {
        this.tileLock.lock();
        try {
            this.okToFlush.set(false);
            for (Object key : this.tiles.keySet()) {
                visitor.visit(this.tiles.get(key), this.residentTiles.containsKey(key));
            }
        }
        finally {
            this.tileLock.unlock();
        }
    }

    private boolean makeResident(DiskCachedTile tile, Raster data) {
        if (tile.getTileSize() > this.memCapacity) {
            return false;
        }
        if (tile.getTileSize() > this.memCapacity - this.curMemory) {
            this.memoryControl();
            if (tile.getTileSize() > this.memCapacity - this.curMemory) {
                this.defaultMemoryControl(tile.getTileSize());
            }
        }
        this.residentTiles.put(tile.getTileId(), data);
        this.curMemory += tile.getTileSize();
        this.sortedResidentTiles.add(tile);
        return true;
    }

    private void removeResidentTile(Object tileId, boolean writeData) throws DiskCacheFailedException {
        DiskCachedTile tile = this.tiles.get(tileId);
        Raster raster = this.residentTiles.remove(tileId);
        this.sortedResidentTiles.remove(tile);
        this.curMemory -= tile.getTileSize();
        if (writeData && tile.isWritable()) {
            try {
                tile.writeData(raster);
            }
            catch (IOException ioEx) {
                throw new DiskCacheFailedException(tile.getOwner(), tile.getTileX(), tile.getTileY());
            }
        }
        tile.setAction(DiskCachedTile.TileAction.ACTION_NON_RESIDENT);
        if (this.diagnosticsEnabled) {
            this.setChanged();
            this.notifyObservers(tile);
        }
    }

    private Object getTileId(RenderedImage owner, int tileX, int tileY) {
        long tileId = (long)tileY * (long)owner.getNumXTiles() + (long)tileX;
        BigInteger imageId = null;
        if (owner instanceof PlanarImage) {
            imageId = (BigInteger)((PlanarImage)owner).getImageID();
        }
        if (imageId != null) {
            byte[] buf = imageId.toByteArray();
            int length = buf.length;
            byte[] buf1 = new byte[buf.length + 8];
            System.arraycopy(buf, 0, buf1, 0, length);
            int i = 7;
            int j = 0;
            while (i >= 0) {
                buf1[length++] = (byte)(tileId >> j);
                --i;
                j += 8;
            }
            return new BigInteger(buf1);
        }
        return (long)owner.hashCode() << 32 | (tileId &= 0xFFFFFFFFL);
    }

    static {
        ParamDesc desc = new ParamDesc(KEY_INITIAL_MEMORY_CAPACITY, Number.class, 0x4000000L);
        paramDescriptors.put(desc.key, desc);
        desc = new ParamDesc(KEY_ALWAYS_DISK_CACHE, Boolean.class, Boolean.FALSE);
        paramDescriptors.put(desc.key, desc);
        desc = new ParamDesc(KEY_AUTO_FLUSH_MEMORY_ENABLED, Boolean.class, Boolean.FALSE);
        paramDescriptors.put(desc.key, desc);
        desc = new ParamDesc(KEY_AUTO_FLUSH_MEMORY_INTERVAL, Number.class, 2500L);
        paramDescriptors.put(desc.key, desc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParamDesc {
        String key;
        Class<?> clazz;
        Object defaultValue;

        ParamDesc(String key, Class<?> clazz, Object defaultValue) {
            this.key = key;
            this.clazz = clazz;
            this.defaultValue = defaultValue;
        }

        boolean typeOK(Object value) {
            if (Number.class.isAssignableFrom(this.clazz)) {
                return Number.class.isAssignableFrom(value.getClass());
            }
            return this.clazz.isAssignableFrom(value.getClass());
        }
    }
}

