/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class DpiRescaleStyleVisitor
extends RescaleStyleVisitor {
    private boolean rescaling = true;

    public DpiRescaleStyleVisitor(double scale) {
        super(scale);
    }

    public DpiRescaleStyleVisitor(Expression scale) {
        super(scale);
    }

    public DpiRescaleStyleVisitor(FilterFactory2 filterFactory, double scale) {
        super(filterFactory, scale);
    }

    public DpiRescaleStyleVisitor(FilterFactory2 filterFactory, Expression scale) {
        super(filterFactory, scale);
    }

    @Override
    protected Expression rescale(Expression expr) {
        if (this.rescaling) {
            return super.rescale(expr);
        }
        return expr;
    }

    @Override
    float[] rescale(float[] values) {
        if (this.rescaling) {
            return super.rescale(values);
        }
        return values;
    }

    @Override
    protected void rescaleOption(Map<String, String> options, String key, double defaultValue) {
        if (this.rescaling) {
            super.rescaleOption(options, key, defaultValue);
        } else if (options.get(key) == null && defaultValue != 0.0) {
            options.put(key, String.valueOf(defaultValue));
        }
    }

    @Override
    protected void rescaleOption(Map<String, String> options, String key, int defaultValue) {
        if (this.rescaling) {
            super.rescaleOption(options, key, defaultValue);
        } else if (options.get(key) == null && defaultValue != 0) {
            options.put(key, String.valueOf(defaultValue));
        }
    }

    private void setRescaling(Symbolizer symbolizer) {
        Unit<Length> uom = symbolizer.getUnitOfMeasure();
        this.setRescaling(uom == null || uom.equals(NonSI.PIXEL));
    }

    private void setRescaling(boolean rescaling) {
        this.rescaling = rescaling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Symbolizer sym) {
        this.setRescaling(sym);
        try {
            super.visit(sym);
        }
        finally {
            this.setRescaling(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(PointSymbolizer sym) {
        this.setRescaling(sym);
        try {
            super.visit(sym);
        }
        finally {
            this.setRescaling(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(LineSymbolizer sym) {
        this.setRescaling(sym);
        try {
            super.visit(sym);
        }
        finally {
            this.setRescaling(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(PolygonSymbolizer sym) {
        this.setRescaling(sym);
        try {
            super.visit(sym);
        }
        finally {
            this.setRescaling(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(TextSymbolizer sym) {
        this.setRescaling(sym);
        try {
            super.visit(sym);
        }
        finally {
            this.setRescaling(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(RasterSymbolizer sym) {
        this.setRescaling(sym);
        try {
            super.visit(sym);
        }
        finally {
            this.setRescaling(true);
        }
    }
}

