/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.util.Arrays;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Graphic;
import org.opengis.util.Cloneable;

public class StrokeImpl
implements Stroke,
Cloneable {
    private FilterFactory filterFactory;
    private Expression color;
    private float[] dashArray;
    private Expression dashOffset;
    private GraphicImpl fillGraphic;
    private GraphicImpl strokeGraphic;
    private Expression lineCap;
    private Expression lineJoin;
    private Expression opacity;
    private Expression width;

    protected StrokeImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected StrokeImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    @Override
    public Expression getColor() {
        return this.color;
    }

    @Override
    public void setColor(Expression color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
    }

    public void setColor(String color) {
        this.setColor(this.filterFactory.literal(color));
    }

    @Override
    public float[] getDashArray() {
        float[] ret = null;
        if (this.dashArray != null) {
            ret = new float[this.dashArray.length];
            System.arraycopy(this.dashArray, 0, ret, 0, this.dashArray.length);
        } else {
            float[] defaultDashArray = Stroke.DEFAULT.getDashArray();
            if (defaultDashArray == null) {
                return null;
            }
            ret = new float[defaultDashArray.length];
            System.arraycopy(defaultDashArray, 0, ret, 0, defaultDashArray.length);
        }
        return ret;
    }

    @Override
    public void setDashArray(float[] dashPattern) {
        this.dashArray = dashPattern;
    }

    @Override
    public Expression getDashOffset() {
        if (this.dashOffset == null) {
            return Stroke.DEFAULT.getDashOffset();
        }
        return this.dashOffset;
    }

    @Override
    public void setDashOffset(Expression dashOffset) {
        if (dashOffset == null) {
            return;
        }
        this.dashOffset = dashOffset;
    }

    @Override
    public GraphicImpl getGraphicFill() {
        return this.fillGraphic;
    }

    @Override
    public void setGraphicFill(Graphic fillGraphic) {
        if (this.fillGraphic == fillGraphic) {
            return;
        }
        this.fillGraphic = GraphicImpl.cast(fillGraphic);
    }

    @Override
    public GraphicImpl getGraphicStroke() {
        return this.strokeGraphic;
    }

    @Override
    public void setGraphicStroke(Graphic strokeGraphic) {
        if (this.strokeGraphic == strokeGraphic) {
            return;
        }
        this.strokeGraphic = GraphicImpl.cast(strokeGraphic);
    }

    @Override
    public Expression getLineCap() {
        if (this.lineCap == null) {
            return Stroke.DEFAULT.getLineCap();
        }
        return this.lineCap;
    }

    @Override
    public void setLineCap(Expression lineCap) {
        if (lineCap == null) {
            return;
        }
        this.lineCap = lineCap;
    }

    @Override
    public Expression getLineJoin() {
        if (this.lineCap == null) {
            return Stroke.DEFAULT.getLineJoin();
        }
        return this.lineJoin;
    }

    @Override
    public void setLineJoin(Expression lineJoin) {
        if (lineJoin == null) {
            return;
        }
        this.lineJoin = lineJoin;
    }

    @Override
    public Expression getOpacity() {
        if (this.lineCap == null) {
            return Stroke.DEFAULT.getOpacity();
        }
        return this.opacity;
    }

    @Override
    public void setOpacity(Expression opacity) {
        if (opacity == null) {
            return;
        }
        this.opacity = opacity;
    }

    @Override
    public Expression getWidth() {
        if (this.width == null) {
            return this.filterFactory.literal(1.0);
        }
        return this.width;
    }

    @Override
    public void setWidth(Expression width) {
        this.width = width;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("org.geotools.styling.StrokeImpl:\n");
        out.append("\tColor " + this.color + "\n");
        out.append("\tWidth " + this.width + "\n");
        out.append("\tOpacity " + this.opacity + "\n");
        out.append("\tLineCap " + this.lineCap + "\n");
        out.append("\tLineJoin " + this.lineJoin + "\n");
        out.append("\tDash Array " + this.dashArray + "\n");
        out.append("\tDash Offset " + this.dashOffset + "\n");
        out.append("\tFill Graphic " + this.fillGraphic + "\n");
        out.append("\tStroke Graphic " + this.strokeGraphic);
        return out.toString();
    }

    @Override
    public Color getColor(SimpleFeature feature) {
        return Color.decode((String)this.getColor().evaluate(feature));
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            StrokeImpl clone = (StrokeImpl)super.clone();
            if (this.dashArray != null) {
                clone.dashArray = new float[this.dashArray.length];
                System.arraycopy(this.dashArray, 0, clone.dashArray, 0, this.dashArray.length);
            }
            if (this.fillGraphic != null && this.fillGraphic instanceof Cloneable) {
                clone.fillGraphic = (GraphicImpl)this.fillGraphic.clone();
            }
            if (this.strokeGraphic != null && this.fillGraphic instanceof Cloneable) {
                clone.strokeGraphic = (GraphicImpl)this.strokeGraphic.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone StrokeImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.dashOffset != null) {
            result = 1000003 * result + this.dashOffset.hashCode();
        }
        if (this.fillGraphic != null) {
            result = 1000003 * result + this.fillGraphic.hashCode();
        }
        if (this.strokeGraphic != null) {
            result = 1000003 * result + this.strokeGraphic.hashCode();
        }
        if (this.lineCap != null) {
            result = 1000003 * result + this.lineCap.hashCode();
        }
        if (this.lineJoin != null) {
            result = 1000003 * result + this.lineJoin.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.width != null) {
            result = 1000003 * result + this.width.hashCode();
        }
        if (this.dashArray != null) {
            result = 1000003 * result + this.hashCodeDashArray(this.dashArray);
        }
        return result;
    }

    private int hashCodeDashArray(float[] a) {
        int PRIME = 1000003;
        if (a == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result = 1000003 * result + Float.floatToIntBits(a[i]);
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        StrokeImpl other = (StrokeImpl)oth;
        if (!Utilities.equals(this.getColor(), other.getColor())) {
            return false;
        }
        if (!Utilities.equals(this.getWidth(), other.getWidth())) {
            return false;
        }
        if (!Utilities.equals(this.getLineCap(), other.getLineCap())) {
            return false;
        }
        if (!Utilities.equals(this.getLineJoin(), other.getLineJoin())) {
            return false;
        }
        if (!Utilities.equals(this.getOpacity(), other.getOpacity())) {
            return false;
        }
        if (!Utilities.equals(this.getGraphicFill(), other.getGraphicFill())) {
            return false;
        }
        if (!Utilities.equals(this.getGraphicStroke(), other.getGraphicStroke())) {
            return false;
        }
        return Arrays.equals(this.getDashArray(), other.getDashArray());
    }

    static StrokeImpl cast(org.opengis.style.Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        if (stroke instanceof StrokeImpl) {
            return (StrokeImpl)stroke;
        }
        StrokeImpl copy = new StrokeImpl();
        copy.setColor(stroke.getColor());
        if (stroke.getDashArray() != null) {
            float[] dashArray = stroke.getDashArray();
            float[] ret = new float[dashArray.length];
            System.arraycopy(dashArray, 0, ret, 0, dashArray.length);
            copy.setDashArray(ret);
        }
        copy.setDashOffset(stroke.getDashOffset());
        copy.setGraphicFill(GraphicImpl.cast(stroke.getGraphicFill()));
        copy.setGraphicStroke(GraphicImpl.cast(stroke.getGraphicStroke()));
        copy.setLineCap(stroke.getLineCap());
        copy.setLineJoin(stroke.getLineJoin());
        copy.setOpacity(stroke.getOpacity());
        copy.setWidth(stroke.getWidth());
        return copy;
    }
}

