/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class AllAuthoritiesFactory
extends ManyAuthoritiesFactory {
    public static AllAuthoritiesFactory DEFAULT = new AllAuthoritiesFactory(null);
    private Collection<String> authorityNames;

    public AllAuthoritiesFactory(Hints hints) {
        super((Collection<? extends AuthorityFactory>)null);
        this.addImplementationHints(hints);
    }

    @Override
    public Set<String> getAuthorityNames() {
        return ReferencingFactoryFinder.getAuthorityNames();
    }

    @Override
    Collection<AuthorityFactory> getFactories() {
        Set<String> authorities = ReferencingFactoryFinder.getAuthorityNames();
        if (authorities != this.authorityNames) {
            this.authorityNames = authorities;
            Hints hints = this.getHints();
            LinkedHashSet<AuthorityFactory> factories = new LinkedHashSet<AuthorityFactory>();
            factories.addAll(ReferencingFactoryFinder.getCRSAuthorityFactories(hints));
            factories.addAll(ReferencingFactoryFinder.getCSAuthorityFactories(hints));
            factories.addAll(ReferencingFactoryFinder.getDatumAuthorityFactories(hints));
            factories.addAll(ReferencingFactoryFinder.getCoordinateOperationAuthorityFactories(hints));
            this.setFactories(factories);
        }
        return super.getFactories();
    }

    @Override
    final <T extends AuthorityFactory> T fromFactoryRegistry(String authority, Class<T> type) throws FactoryRegistryException {
        AuthorityFactory f = CRSAuthorityFactory.class.equals(type) ? ReferencingFactoryFinder.getCRSAuthorityFactory(authority, this.getHints()) : (CSAuthorityFactory.class.equals(type) ? ReferencingFactoryFinder.getCSAuthorityFactory(authority, this.getHints()) : (DatumAuthorityFactory.class.equals(type) ? ReferencingFactoryFinder.getDatumAuthorityFactory(authority, this.getHints()) : (CoordinateOperationAuthorityFactory.class.equals(type) ? ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(authority, this.getHints()) : super.fromFactoryRegistry(authority, type))));
        return (T)((AuthorityFactory)type.cast(f));
    }

    private Hints getHints() {
        if (this.hints.isEmpty()) {
            return ReferencingFactoryFinder.EMPTY_HINTS;
        }
        Hints hints = ReferencingFactoryFinder.EMPTY_HINTS.clone();
        hints.putAll((Map<?, ?>)this.hints);
        return hints;
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new Finder(this, type);
    }

    private static final class Finder
    extends ManyAuthoritiesFactory.Finder {
        protected Finder(ManyAuthoritiesFactory factory, Class<? extends IdentifiedObject> type) {
            super(factory, type);
        }

        private Set<AuthorityFactory> fromFactoryRegistry() {
            ManyAuthoritiesFactory factory = (ManyAuthoritiesFactory)this.getProxy().getAuthorityFactory();
            Class type = this.getProxy().getType();
            LinkedHashSet<AuthorityFactory> factories = new LinkedHashSet<AuthorityFactory>();
            for (String authority : ReferencingFactoryFinder.getAuthorityNames()) {
                factory.fromFactoryRegistry(authority, type, factories);
            }
            Collection<AuthorityFactory> done = this.getFactories();
            if (done != null) {
                factories.removeAll(done);
            }
            return factories;
        }

        @Override
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder finder;
            IdentifiedObject candidate = super.find(object);
            if (candidate != null) {
                return candidate;
            }
            Iterator<AuthorityFactory> it = this.fromFactoryRegistry().iterator();
            while ((finder = this.next(it)) != null && (candidate = finder.find(object)) == null) {
            }
            return candidate;
        }

        @Override
        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder finder;
            String candidate = super.findIdentifier(object);
            if (candidate != null) {
                return candidate;
            }
            Iterator<AuthorityFactory> it = this.fromFactoryRegistry().iterator();
            while ((finder = this.next(it)) != null && (candidate = finder.findIdentifier(object)) == null) {
            }
            return candidate;
        }
    }
}

