/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.Classifier;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class ClassifyFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("classify", FunctionNameImpl.parameter("value", Object.class), FunctionNameImpl.parameter("expression", Object.class), FunctionNameImpl.parameter("classifer", Classifier.class));

    public ClassifyFunction() {
        super(NAME);
    }

    public Classifier getClassifier(Object context) {
        Expression expr = this.getParameters().get(1);
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            return (Classifier)literal.getValue();
        }
        return expr.evaluate(context, Classifier.class);
    }

    public Expression getExpression() {
        return this.getParameters().get(0);
    }

    @Override
    public Object evaluate(Object feature) {
        Classifier classifier = this.getClassifier(feature);
        Expression expression = this.getExpression();
        return new Integer(classifier.classify(expression, feature));
    }
}

