/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.filter.capability.OperatorImpl;
import org.opengis.feature.type.Name;
import org.opengis.filter.capability.FunctionName;

public class FunctionNameImpl
extends OperatorImpl
implements FunctionName {
    Name functionName;
    List<org.opengis.parameter.Parameter<?>> args;
    org.opengis.parameter.Parameter<?> ret;

    public FunctionNameImpl(String name, int argumentCount) {
        this((Name)new NameImpl(name), argumentCount);
    }

    public FunctionNameImpl(Name name, int argumentCount) {
        this(name, FunctionNameImpl.generateReturn(), FunctionNameImpl.generateArguments(argumentCount));
    }

    public FunctionNameImpl(String name, String ... argumentsNames) {
        this((Name)new NameImpl(name), argumentsNames);
    }

    public FunctionNameImpl(Name name, String ... argumentsNames) {
        this(name, argumentsNames.length, Arrays.asList(argumentsNames));
    }

    public FunctionNameImpl(String name, List<String> argumentsNames) {
        this((Name)new NameImpl(name), argumentsNames);
    }

    public FunctionNameImpl(Name name, List<String> argumentsNames) {
        this(name, argumentsNames.size(), argumentsNames);
    }

    public FunctionNameImpl(String name, int argumentCount, List<String> argumentsNames) {
        this((Name)new NameImpl(name), argumentCount, argumentsNames);
    }

    public FunctionNameImpl(Name name, int argumentCount, List<String> argumentsNames) {
        this(name, FunctionNameImpl.generateReturn(), FunctionNameImpl.generateArguments(argumentsNames));
    }

    public FunctionNameImpl(String name, int argumentCount, String ... argumentsNames) {
        this((Name)new NameImpl(name), argumentCount, argumentsNames);
    }

    public FunctionNameImpl(Name name, int argumentCount, String ... argumentsNames) {
        this(name, argumentCount, Arrays.asList(argumentsNames));
    }

    public FunctionNameImpl(FunctionName copy) {
        super(copy);
        this.functionName = copy.getFunctionName();
        this.ret = copy.getReturn();
        this.args = copy.getArguments();
    }

    public FunctionNameImpl(String name, Class returnType, org.opengis.parameter.Parameter<?> ... arguments) {
        this((Name)new NameImpl(name), returnType, arguments);
    }

    public FunctionNameImpl(Name name, Class returnType, org.opengis.parameter.Parameter<?> ... arguments) {
        this(name, FunctionNameImpl.parameter(name.getLocalPart(), returnType), Arrays.asList(arguments));
    }

    public FunctionNameImpl(String name, org.opengis.parameter.Parameter<?> retern, org.opengis.parameter.Parameter<?> ... arguments) {
        this((Name)new NameImpl(name), retern, arguments);
    }

    public FunctionNameImpl(Name name, org.opengis.parameter.Parameter<?> retern, org.opengis.parameter.Parameter<?> ... arguments) {
        this(name, retern, Arrays.asList(arguments));
    }

    public FunctionNameImpl(String name, org.opengis.parameter.Parameter<?> retern, List<org.opengis.parameter.Parameter<?>> arguments) {
        this((Name)new NameImpl(name), retern, arguments);
    }

    public FunctionNameImpl(Name name, org.opengis.parameter.Parameter<?> retern, List<org.opengis.parameter.Parameter<?>> arguments) {
        super(name.getLocalPart());
        this.functionName = name;
        this.ret = retern;
        this.args = arguments;
    }

    @Override
    public Name getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getName() {
        return this.getFunctionName().getLocalPart();
    }

    @Override
    public int getArgumentCount() {
        return this.args.size();
    }

    @Override
    public List<org.opengis.parameter.Parameter<?>> getArguments() {
        return this.args;
    }

    @Override
    public org.opengis.parameter.Parameter<?> getReturn() {
        return this.ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.args != null) {
            result = 31 * result + ((Object)this.args).hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionNameImpl other = (FunctionNameImpl)obj;
        if (this.args == null) {
            return other.args == null;
        }
        return ((Object)this.args).equals(other.args);
    }

    @Override
    public List<String> getArgumentNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (org.opengis.parameter.Parameter<?> arg : this.args) {
            names.add(arg.getName());
        }
        return names;
    }

    private static org.opengis.parameter.Parameter<?> generateReturn() {
        return FunctionNameImpl.parameter("return", Object.class);
    }

    private static List<org.opengis.parameter.Parameter<?>> generateArguments(int count) {
        ArrayList args = new ArrayList();
        if (count < 0) {
            args.add(FunctionNameImpl.parameter("arg", Object.class, Math.abs(count), Integer.MAX_VALUE));
        } else {
            for (int i = 0; i < count; ++i) {
                args.add(FunctionNameImpl.parameter("arg" + i, Object.class, 1, 1));
            }
        }
        return args;
    }

    private static List<org.opengis.parameter.Parameter<?>> generateArguments(List<String> names) {
        ArrayList args = new ArrayList();
        for (String name : names) {
            args.add(FunctionNameImpl.parameter(name, Object.class, 1, 1));
        }
        return args;
    }

    public static org.opengis.parameter.Parameter<?> parameter(String name, Class type) {
        return FunctionNameImpl.parameter(name, type, 1, 1);
    }

    public static org.opengis.parameter.Parameter<?> parameter(String name, Class type, int min, int max) {
        return new Parameter(name, type, min, max);
    }
}

