/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opengis.filter.capability.ComparisonOperators;
import org.opengis.filter.capability.Operator;

public class ComparisonOperatorsImpl
implements ComparisonOperators {
    Set<Operator> operators;

    public ComparisonOperatorsImpl() {
        this(new ArrayList<Operator>());
    }

    public ComparisonOperatorsImpl(ComparisonOperators copy) {
        this.operators = new HashSet<Operator>(copy.getOperators());
    }

    public ComparisonOperatorsImpl(Collection<Operator> operators) {
        this.operators = new HashSet<Operator>(operators);
    }

    public ComparisonOperatorsImpl(Operator[] operators) {
        if (operators == null) {
            operators = new Operator[]{};
        }
        this.operators = new HashSet<Operator>(Arrays.asList(operators));
    }

    @Override
    public Collection<Operator> getOperators() {
        if (this.operators == null) {
            this.operators = new HashSet<Operator>();
        }
        return this.operators;
    }

    public void setOperators(Collection<Operator> operators) {
        this.operators = new HashSet<Operator>(operators);
    }

    @Override
    public Operator getOperator(String name) {
        if (name == null || this.operators == null) {
            return null;
        }
        for (Operator operator : this.operators) {
            if (!name.equals(operator.getName())) continue;
            return operator;
        }
        return null;
    }

    public void addAll(ComparisonOperators copy) {
        if (copy.getOperators() != null) {
            this.getOperators().addAll(copy.getOperators());
        }
    }

    public String toString() {
        if (this.operators == null) {
            return "ComparisonOperators: none";
        }
        return "ComparisonOperators:" + this.operators;
    }
}

