/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.columbusCSV;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.I18n;

public class ColumbusCSVPreferences
implements PreferenceSetting {
    public static final String PREFIX = "columbuscsv.";
    public static final String SHOW_SUMMARY = "columbuscsv.import.showSummary";
    public static final String ZOOM_AFTER_IMPORT = "columbuscsv.import.dontZoomAfterImport";
    public static final String IGNORE_VDOP = "columbuscsv.import.ignoreVDOP";
    public static final String WARN_MISSING_AUDIO = "columbuscsv.warn.missingAudio";
    public static final String WARN_CONVERSION_ERRORS = "columbuscsv.warn.conversionErrors";
    private JCheckBox colCSVShowSummary = new JCheckBox(I18n.tr((String)"Show summary after import", (Object[])new Object[0]));
    private JCheckBox colCSVDontZoomAfterImport = new JCheckBox(I18n.tr((String)"Do not zoom after import", (Object[])new Object[0]));
    private JCheckBox colCSVIgnoreVDOP = new JCheckBox(I18n.tr((String)"Ignore hdop/vdop/pdop entries", (Object[])new Object[0]));
    private JCheckBox colCSVWarnMissingAudio = new JCheckBox(I18n.tr((String)"Warn on missing audio files", (Object[])new Object[0]));
    private JCheckBox colCSVWarnConversionErrors = new JCheckBox(I18n.tr((String)"Warn on conversion errors", (Object[])new Object[0]));

    public boolean ok() {
        Main.pref.put(SHOW_SUMMARY, this.colCSVShowSummary.isSelected());
        Main.pref.put(ZOOM_AFTER_IMPORT, this.colCSVDontZoomAfterImport.isSelected());
        Main.pref.put(IGNORE_VDOP, this.colCSVIgnoreVDOP.isSelected());
        Main.pref.put(WARN_CONVERSION_ERRORS, this.colCSVWarnConversionErrors.isSelected());
        Main.pref.put(WARN_MISSING_AUDIO, this.colCSVWarnMissingAudio.isSelected());
        return false;
    }

    public static boolean showSummary() {
        return Main.pref.getBoolean(SHOW_SUMMARY, true);
    }

    public static boolean zoomAfterImport() {
        return Main.pref.getBoolean(ZOOM_AFTER_IMPORT, true);
    }

    public static boolean ignoreDOP() {
        return Main.pref.getBoolean(IGNORE_VDOP, false);
    }

    public static boolean warnConversion() {
        return Main.pref.getBoolean(WARN_CONVERSION_ERRORS, false);
    }

    public static boolean warnMissingAudio() {
        return Main.pref.getBoolean(WARN_MISSING_AUDIO, false);
    }

    public void addGui(PreferenceTabbedPane gui) {
        ButtonGroup gpsImportGroup = new ButtonGroup();
        gpsImportGroup.add(this.colCSVShowSummary);
        gpsImportGroup.add(this.colCSVDontZoomAfterImport);
        gpsImportGroup.add(this.colCSVIgnoreVDOP);
        ButtonGroup gpsWarningsGroup = new ButtonGroup();
        gpsWarningsGroup.add(this.colCSVWarnMissingAudio);
        gpsWarningsGroup.add(this.colCSVWarnConversionErrors);
        this.colCSVShowSummary.setSelected(Main.pref.getBoolean(SHOW_SUMMARY, true));
        this.colCSVDontZoomAfterImport.setSelected(Main.pref.getBoolean(ZOOM_AFTER_IMPORT, true));
        this.colCSVIgnoreVDOP.setSelected(Main.pref.getBoolean(IGNORE_VDOP, false));
        this.colCSVWarnConversionErrors.setSelected(Main.pref.getBoolean(WARN_CONVERSION_ERRORS, true));
        this.colCSVWarnMissingAudio.setSelected(Main.pref.getBoolean(WARN_MISSING_AUDIO, true));
    }

    public boolean isExpert() {
        return false;
    }
}

