/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui;

import java.util.List;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustActionUploaderException;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustServiceCommand;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandler;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;

public class MapdustActionUploader {
    private static MapdustActionUploader instance;
    private static MapdustServiceHandler handler;

    private MapdustActionUploader() {
        handler = new MapdustServiceHandler();
    }

    public static MapdustActionUploader getInstance() {
        if (instance == null) {
            instance = new MapdustActionUploader();
        }
        return instance;
    }

    public void uploadData(List<MapdustAction> actionList) throws MapdustActionUploaderException {
        if (actionList != null && actionList.size() > 0) {
            try {
                for (MapdustAction action : actionList) {
                    this.dispatchAction(action);
                }
            }
            catch (MapdustServiceHandlerException e) {
                throw new MapdustActionUploaderException("Error durring uploading data to Mapdust service!", e);
            }
        }
    }

    private void dispatchAction(MapdustAction action) throws MapdustServiceHandlerException {
        if (action.getCommand().equals((Object)MapdustServiceCommand.ADD_BUG)) {
            handler.addBug(action.getMapdustBug());
        } else if (action.getCommand().equals((Object)MapdustServiceCommand.COMMENT_BUG)) {
            handler.commentBug(action.getMapdustComment());
        } else {
            handler.changeBugStatus(action.getNewStatus(), action.getMapdustComment());
        }
    }
}

