/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.newlayer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerFromFile;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerFromKML;
import org.openstreetmap.josm.plugins.piclayer.layer.kml.KMLGroundOverlay;
import org.openstreetmap.josm.plugins.piclayer.layer.kml.KMLReader;
import org.openstreetmap.josm.tools.I18n;

public class NewLayerFromFileAction
extends JosmAction {
    String m_lastdirprefname = "piclayer.lastdir";

    public NewLayerFromFileAction() {
        super(I18n.tr((String)"New picture layer from file...", (Object[])new Object[0]), "layericon24", null, null, false);
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser(Main.pref.get(this.m_lastdirprefname));
        fc.setAcceptAllFileFilterUsed(true);
        fc.setFileFilter(new ImageFileFilter());
        fc.setMultiSelectionEnabled(true);
        int result = fc.showOpenDialog(Main.parent);
        if (result == 0) {
            int newLayerPos = Main.map.mapView.getAllLayers().size();
            for (PicLayerAbstract l : Main.map.mapView.getLayersOfType(PicLayerAbstract.class)) {
                int pos = Main.map.mapView.getLayerPos((Layer)l);
                if (pos >= newLayerPos) continue;
                newLayerPos = pos;
            }
            for (File file : fc.getSelectedFiles()) {
                Main.pref.put(this.m_lastdirprefname, file.getParent());
                if ("kml".equalsIgnoreCase(PicLayerFromFile.getFileExtension(file))) {
                    KMLReader kml = new KMLReader(file);
                    kml.process();
                    JOptionPane.showMessageDialog(null, I18n.tr((String)"KML calibration is in beta stage and may produce incorrectly calibrated layers!\nPlease use http://josm.openstreetmap.de/ticket/5451 to upload your KMLs that were calibrated incorrectly.", (Object[])new Object[0]));
                    for (KMLGroundOverlay overlay : kml.getGroundOverlays()) {
                        this.addNewLayerFromKML(file, overlay, newLayerPos);
                    }
                    continue;
                }
                this.addNewLayerFromFile(file, newLayerPos, fc.getSelectedFiles().length == 1);
            }
        }
    }

    private void addNewLayerFromFile(File file, int newLayerPos, boolean isZoomToLayer) {
        try {
            PicLayerFromFile layer = new PicLayerFromFile(file);
            layer.initialize();
            this.placeLayer(layer, newLayerPos, isZoomToLayer);
        }
        catch (IOException e) {
            System.out.println("NewLayerFromFileAction::actionPerformed - " + e.getMessage());
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    private void placeLayer(PicLayerAbstract layer, int newLayerPos, boolean isZoomToLayer) throws IOException {
        Main.main.addLayer((Layer)layer);
        Main.map.mapView.moveLayer((Layer)layer, newLayerPos++);
        if (isZoomToLayer && Main.pref.getInteger("piclayer.zoom-on-load", 1) != 0) {
            BoundingXYVisitor v = new BoundingXYVisitor();
            layer.visitBoundingBox(v);
            Main.map.mapView.recalculateCenterScale(v);
        }
    }

    private void addNewLayerFromKML(File root, KMLGroundOverlay overlay, int newLayerPos) {
        try {
            PicLayerFromKML layer = new PicLayerFromKML(root, overlay);
            layer.initialize();
            this.placeLayer(layer, newLayerPos, true);
        }
        catch (IOException e) {
            System.out.println("NewLayerFromFileAction::actionPerformed - " + e.getMessage());
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    private class ImageFileFilter
    extends FileFilter {
        private String[] supportedExtensions;

        public ImageFileFilter() {
            ArrayList<String> extensions = new ArrayList<String>();
            extensions.add("zip");
            extensions.add("kml");
            for (String ext : ImageIO.getReaderFormatNames()) {
                extensions.add(ext);
            }
            this.supportedExtensions = extensions.toArray(new String[0]);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String fileExtension = PicLayerFromFile.getFileExtension(f);
            for (String e : this.supportedExtensions) {
                if (!e.equalsIgnoreCase(fileExtension)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return I18n.tr((String)"Supported image files, *.zip, *.kml", (Object[])new Object[0]);
        }
    }
}

