/*
 * Decompiled with CFR 0.152.
 */
package smed.tabs;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import smed.io.SmedFile;
import smed.plug.ifc.SmedPluggable;
import smed.plug.ifc.SmedPluginManager;
import smed.plug.manager.SmedPluginManagerImpl;
import smed.plug.util.SmedPluginLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmedTabbedPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static List<SmedPluggable> plugins = null;
    private static JTabbedPane tabbedPane = null;
    private SmedPluginManager manager = null;
    private int activeIndex = -1;
    private static SmedPluggable curPlugin = null;

    public SmedTabbedPane() {
        String pluginDirName = Main.pref.getPluginsDirectory().getAbsolutePath();
        try {
            plugins = SmedPluginLoader.loadPlugins(new File(pluginDirName + "/splug"));
            if (plugins != null) {
                if (tabbedPane == null) {
                    tabbedPane = new JTabbedPane();
                }
                ImageIcon icon = null;
                int i = 0;
                SmedFile splugDir = new SmedFile(pluginDirName + "/splug");
                this.manager = new SmedPluginManagerImpl();
                for (SmedPluggable p : plugins) {
                    p.setPluginManager(this.manager);
                    if (splugDir.isVisible(p.getFileName())) {
                        JComponent panel = p.getComponent();
                        icon = p.getIcon();
                        tabbedPane.addTab(p.getName(), icon, panel, p.getInfo());
                        tabbedPane.setMnemonicAt(i, 49 + i);
                        if (i == 0) {
                            curPlugin = p;
                            this.activeIndex = 0;
                        }
                        p.setIndex(i);
                        ++i;
                        continue;
                    }
                    splugDir.setVisible(p.getFileName(), false);
                }
                this.add(tabbedPane);
                tabbedPane.setPreferredSize(new Dimension(410, 410));
                tabbedPane.setTabLayoutPolicy(1);
                tabbedPane.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent event) {
                        JTabbedPane pane = (JTabbedPane)event.getSource();
                        for (SmedPluggable p : plugins) {
                            if (p.getIndex() != SmedTabbedPane.this.activeIndex) continue;
                            p.lostFocus();
                        }
                        SmedTabbedPane.this.activeIndex = pane.getSelectedIndex();
                        for (SmedPluggable p : plugins) {
                            if (p.getIndex() != SmedTabbedPane.this.activeIndex) continue;
                            p.hasFocus();
                            curPlugin = p;
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<SmedPluggable> getPlugins() {
        return plugins;
    }

    public static JTabbedPane getTabbedPane() {
        return tabbedPane;
    }

    public static SmedPluggable getCurPlugin() {
        return curPlugin;
    }
}

