/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.dialogs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.graphview.plugin.dialogs.AccessParameterDialog;
import org.openstreetmap.josm.plugins.graphview.plugin.layer.GraphViewLayer;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferenceDefaults;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferences;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.PreferenceAccessParameters;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class GraphViewPreferenceEditor
extends DefaultTabPreferenceSetting {
    private File rulesetFolder;
    private Map<String, PreferenceAccessParameters> parameterBookmarks;
    private JPanel preferencePanel;
    private JCheckBox internalRulesetCheckBox;
    private JLabel rulesetFolderLabel;
    private JTextField rulesetFolderTextField;
    private JButton selectRulesetFolderButton;
    private JComboBox bookmarkComboBox;
    private JButton editBookmarkButton;
    private JButton deleteBookmarkButton;
    private JCheckBox separateDirectionsCheckBox;
    private JButton segmentColorButton;
    private JPanel segmentColorField;
    private JButton nodeColorButton;
    private JPanel nodeColorField;
    private JButton arrowheadFillColorButton;
    private JPanel arrowheadFillColorField;
    private JSlider arrowheadPlacementSlider;
    private JPanel arrowPreviewPanel;
    private final ActionListener internalRulesetActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            GraphViewPreferenceEditor.this.updateRulesetPanel();
        }
    };
    private final ActionListener selectRulesetFolderActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            File initialFCDirectory = GraphViewPreferenceEditor.this.rulesetFolder;
            if (GraphViewPreferenceEditor.this.rulesetFolder.getParentFile() != null) {
                initialFCDirectory = GraphViewPreferenceEditor.this.rulesetFolder.getParentFile();
            }
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setCurrentDirectory(initialFCDirectory);
            int returnVal = fc.showOpenDialog(GraphViewPreferenceEditor.this.preferencePanel);
            if (returnVal == 0) {
                GraphViewPreferenceEditor.this.rulesetFolder = fc.getSelectedFile();
                GraphViewPreferenceEditor.this.rulesetFolderTextField.setText(GraphViewPreferenceEditor.this.rulesetFolder.getPath());
            }
        }
    };
    private final ActionListener createVehicleActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PreferenceAccessParameters defaultBookmarkParameters = GraphViewPreferenceDefaults.createDefaultBookmarkAccessParameters();
            AccessParameterDialog apd = new AccessParameterDialog(null, false, I18n.tr((String)"New bookmark", (Object[])new Object[0]), GraphViewPreferenceEditor.this.parameterBookmarks.keySet(), defaultBookmarkParameters, new AccessParameterDialog.BookmarkAction(){

                public void execute(String name, PreferenceAccessParameters parameters) {
                    GraphViewPreferenceEditor.this.parameterBookmarks.put(name, parameters);
                    GraphViewPreferenceEditor.this.updateVehiclePanel(name);
                }
            });
            apd.setVisible(true);
        }
    };
    private final ActionListener editVehicleActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem() != null) {
                final String selectedBookmarkName = (String)GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem();
                PreferenceAccessParameters parameters = (PreferenceAccessParameters)GraphViewPreferenceEditor.this.parameterBookmarks.get(selectedBookmarkName);
                LinkedList<String> otherBookmarkNames = new LinkedList<String>();
                for (String bookmarkName : GraphViewPreferenceEditor.this.parameterBookmarks.keySet()) {
                    if (bookmarkName.equals(selectedBookmarkName)) continue;
                    otherBookmarkNames.add(bookmarkName);
                }
                AccessParameterDialog apd = new AccessParameterDialog(null, true, selectedBookmarkName, otherBookmarkNames, parameters, new AccessParameterDialog.BookmarkAction(){

                    public void execute(String name, PreferenceAccessParameters parameters) {
                        GraphViewPreferenceEditor.this.parameterBookmarks.remove(selectedBookmarkName);
                        GraphViewPreferenceEditor.this.parameterBookmarks.put(name, parameters);
                        GraphViewPreferenceEditor.this.updateVehiclePanel(name);
                    }
                });
                apd.setVisible(true);
            }
        }
    };
    private final ActionListener deleteVehicleActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem() != null) {
                String selectedBookmarkName = (String)GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem();
                int userChoice = JOptionPane.showConfirmDialog(GraphViewPreferenceEditor.this.preferencePanel, I18n.tr((String)"Really delete \"{0}\"?", (Object[])new Object[]{selectedBookmarkName}), I18n.tr((String)"Bookmark deletion", (Object[])new Object[0]), 0, 2);
                if (userChoice == 0) {
                    GraphViewPreferenceEditor.this.parameterBookmarks.remove(selectedBookmarkName);
                    GraphViewPreferenceEditor.this.updateVehiclePanel(null);
                }
            }
        }
    };
    private final ActionListener restoreVehicleDefaultsActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int userChoice = JOptionPane.showConfirmDialog(GraphViewPreferenceEditor.this.preferencePanel, I18n.tr((String)"Really restore default bookmarks?\nAll manually added or edited bookmarks will be lost!", (Object[])new Object[0]), I18n.tr((String)"Bookmark reset", (Object[])new Object[0]), 0, 2);
            if (userChoice == 0) {
                GraphViewPreferenceEditor.this.parameterBookmarks.clear();
                GraphViewPreferenceEditor.this.parameterBookmarks.putAll(GraphViewPreferenceDefaults.createDefaultAccessParameterBookmarks());
                GraphViewPreferenceEditor.this.updateVehiclePanel(null);
            }
        }
    };
    private final ActionListener chooseNodeColorActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Color selectedColor = JColorChooser.showDialog(GraphViewPreferenceEditor.this.preferencePanel, I18n.tr((String)"Choose node color", (Object[])new Object[0]), GraphViewPreferenceEditor.this.nodeColorField.getBackground());
            if (selectedColor != null) {
                GraphViewPreferenceEditor.this.nodeColorField.setBackground(selectedColor);
            }
            GraphViewPreferenceEditor.this.arrowPreviewPanel.repaint();
        }
    };
    private final ActionListener chooseSegmentColorActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Color selectedColor = JColorChooser.showDialog(GraphViewPreferenceEditor.this.preferencePanel, I18n.tr((String)"Choose arrow color", (Object[])new Object[0]), GraphViewPreferenceEditor.this.segmentColorField.getBackground());
            if (selectedColor != null) {
                GraphViewPreferenceEditor.this.segmentColorField.setBackground(selectedColor);
            }
            GraphViewPreferenceEditor.this.arrowPreviewPanel.repaint();
        }
    };
    private final ActionListener chooseArrowheadFillColorActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Color selectedColor = JColorChooser.showDialog(GraphViewPreferenceEditor.this.preferencePanel, I18n.tr((String)"Choose arrowhead fill color", (Object[])new Object[0]), GraphViewPreferenceEditor.this.segmentColorField.getBackground());
            if (selectedColor != null) {
                GraphViewPreferenceEditor.this.arrowheadFillColorField.setBackground(selectedColor);
            }
            GraphViewPreferenceEditor.this.arrowPreviewPanel.repaint();
        }
    };
    private final ChangeListener arrowheadPlacementChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            GraphViewPreferenceEditor.this.arrowPreviewPanel.repaint();
        }
    };

    public GraphViewPreferenceEditor() {
        super("graphview", I18n.tr((String)"Graphview", (Object[])new Object[0]), I18n.tr((String)"Settings for the Graphview plugin that visualizes routing graphs.", (Object[])new Object[0]));
    }

    public void addGui(PreferenceTabbedPane gui) {
        this.readPreferences();
        this.preferencePanel = gui.createPreferenceTab((TabPreferenceSetting)this);
        JPanel mainPanel = this.createMainPanel();
        this.preferencePanel.add((Component)mainPanel, GBC.eol().fill(1));
        this.updateVehiclePanel(GraphViewPreferences.getInstance().getCurrentParameterBookmarkName());
    }

    private void readPreferences() {
        GraphViewPreferences preferences = GraphViewPreferences.getInstance();
        this.rulesetFolder = preferences.getRulesetFolder();
        this.parameterBookmarks = new HashMap<String, PreferenceAccessParameters>(preferences.getParameterBookmarks());
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        mainPanel.setLayout(mainLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        JPanel rulesetPanel = this.createRulesetPanel();
        constraints.gridy = 0;
        mainLayout.setConstraints(rulesetPanel, constraints);
        mainPanel.add(rulesetPanel);
        JPanel vehiclePanel = this.createVehiclePanel();
        constraints.gridy = 1;
        mainLayout.setConstraints(vehiclePanel, constraints);
        mainPanel.add(vehiclePanel);
        JPanel visualizationPanel = this.createVisualizationPanel();
        constraints.gridy = 2;
        mainLayout.setConstraints(visualizationPanel, constraints);
        mainPanel.add(visualizationPanel);
        mainPanel.add(GBC.glue((int)0, (int)0));
        return mainPanel;
    }

    private JPanel createRulesetPanel() {
        JPanel rulesetPanel = new JPanel();
        rulesetPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Ruleset", (Object[])new Object[0])));
        rulesetPanel.setLayout(new BoxLayout(rulesetPanel, 1));
        this.internalRulesetCheckBox = new JCheckBox(I18n.tr((String)"Use built-in rulesets", (Object[])new Object[0]));
        this.internalRulesetCheckBox.setSelected(GraphViewPreferences.getInstance().getUseInternalRulesets());
        this.internalRulesetCheckBox.addActionListener(this.internalRulesetActionListener);
        rulesetPanel.add(this.internalRulesetCheckBox);
        this.rulesetFolderLabel = new JLabel(I18n.tr((String)"External ruleset directory:", (Object[])new Object[0]));
        rulesetPanel.add(this.rulesetFolderLabel);
        this.rulesetFolderTextField = new JTextField();
        this.rulesetFolderTextField.setText(this.rulesetFolder.getPath());
        this.rulesetFolderTextField.setEditable(false);
        rulesetPanel.add(this.rulesetFolderTextField);
        this.selectRulesetFolderButton = new JButton(I18n.tr((String)"Select directory", (Object[])new Object[0]));
        this.selectRulesetFolderButton.addActionListener(this.selectRulesetFolderActionListener);
        rulesetPanel.add(this.selectRulesetFolderButton);
        this.updateRulesetPanel();
        return rulesetPanel;
    }

    private JPanel createVehiclePanel() {
        JPanel vehiclePanel = new JPanel();
        vehiclePanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Vehicle", (Object[])new Object[0])));
        vehiclePanel.setLayout(new BoxLayout(vehiclePanel, 1));
        this.bookmarkComboBox = new JComboBox();
        vehiclePanel.add(this.bookmarkComboBox);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton createButton = new JButton(I18n.tr((String)"Create", (Object[])new Object[0]));
        createButton.addActionListener(this.createVehicleActionListener);
        buttonPanel.add(createButton);
        this.editBookmarkButton = new JButton(I18n.tr((String)"Edit", (Object[])new Object[0]));
        this.editBookmarkButton.addActionListener(this.editVehicleActionListener);
        buttonPanel.add(this.editBookmarkButton);
        this.deleteBookmarkButton = new JButton(I18n.tr((String)"Delete", (Object[])new Object[0]));
        this.deleteBookmarkButton.addActionListener(this.deleteVehicleActionListener);
        buttonPanel.add(this.deleteBookmarkButton);
        JButton restoreDefaultsButton = new JButton(I18n.tr((String)"Restore defaults", (Object[])new Object[0]));
        restoreDefaultsButton.addActionListener(this.restoreVehicleDefaultsActionListener);
        buttonPanel.add(restoreDefaultsButton);
        vehiclePanel.add(buttonPanel);
        return vehiclePanel;
    }

    private JPanel createVisualizationPanel() {
        JPanel visualizationPanel = new JPanel();
        visualizationPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Visualization", (Object[])new Object[0])));
        visualizationPanel.setLayout(new BoxLayout(visualizationPanel, 1));
        this.separateDirectionsCheckBox = new JCheckBox(I18n.tr((String)"Draw directions separately", (Object[])new Object[0]));
        this.separateDirectionsCheckBox.setSelected(GraphViewPreferences.getInstance().getSeparateDirections());
        visualizationPanel.add(this.separateDirectionsCheckBox);
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new GridLayout(3, 2));
        Color nodeColor = GraphViewPreferences.getInstance().getNodeColor();
        this.nodeColorButton = new JButton(I18n.tr((String)"Node color", (Object[])new Object[0]));
        this.nodeColorButton.addActionListener(this.chooseNodeColorActionListener);
        colorPanel.add(this.nodeColorButton);
        this.nodeColorField = new JPanel();
        this.nodeColorField.setBackground(nodeColor);
        colorPanel.add(this.nodeColorField);
        Color segmentColor = GraphViewPreferences.getInstance().getSegmentColor();
        this.segmentColorButton = new JButton(I18n.tr((String)"Arrow color", (Object[])new Object[0]));
        this.segmentColorButton.addActionListener(this.chooseSegmentColorActionListener);
        colorPanel.add(this.segmentColorButton);
        this.segmentColorField = new JPanel();
        this.segmentColorField.setBackground(segmentColor);
        colorPanel.add(this.segmentColorField);
        Color arrowheadFillColor = GraphViewPreferences.getInstance().getArrowheadFillColor();
        this.arrowheadFillColorButton = new JButton(I18n.tr((String)"Arrowhead fill color", (Object[])new Object[0]));
        this.arrowheadFillColorButton.addActionListener(this.chooseArrowheadFillColorActionListener);
        colorPanel.add(this.arrowheadFillColorButton);
        this.arrowheadFillColorField = new JPanel();
        this.arrowheadFillColorField.setBackground(arrowheadFillColor);
        colorPanel.add(this.arrowheadFillColorField);
        visualizationPanel.add(colorPanel);
        this.arrowheadPlacementSlider = new JSlider(0, 100);
        this.arrowheadPlacementSlider.setToolTipText(I18n.tr((String)"Arrowhead placement", (Object[])new Object[0]));
        this.arrowheadPlacementSlider.setMajorTickSpacing(10);
        this.arrowheadPlacementSlider.setPaintTicks(true);
        this.arrowheadPlacementSlider.setName("name");
        this.arrowheadPlacementSlider.setLabelTable(null);
        this.arrowheadPlacementSlider.setValue((int)Math.round(100.0 * GraphViewPreferences.getInstance().getArrowheadPlacement()));
        this.arrowheadPlacementSlider.addChangeListener(this.arrowheadPlacementChangeListener);
        visualizationPanel.add(this.arrowheadPlacementSlider);
        this.arrowPreviewPanel = new ArrowPreviewPanel();
        visualizationPanel.add(this.arrowPreviewPanel);
        return visualizationPanel;
    }

    public boolean ok() {
        GraphViewPreferences preferences = GraphViewPreferences.getInstance();
        preferences.setUseInternalRulesets(this.internalRulesetCheckBox.isSelected());
        preferences.setRulesetFolder(this.rulesetFolder);
        preferences.setParameterBookmarks(this.parameterBookmarks);
        String selectedBookmarkName = (String)this.bookmarkComboBox.getSelectedItem();
        preferences.setCurrentParameterBookmarkName(selectedBookmarkName);
        preferences.setSeparateDirections(this.separateDirectionsCheckBox.isSelected());
        preferences.setNodeColor(this.nodeColorField.getBackground());
        preferences.setSegmentColor(this.segmentColorField.getBackground());
        preferences.setArrowheadFillColor(this.arrowheadFillColorField.getBackground());
        preferences.setArrowheadPlacement((float)this.arrowheadPlacementSlider.getValue() / 100.0f);
        preferences.distributeChanges();
        return false;
    }

    private void updateRulesetPanel() {
        this.rulesetFolderLabel.setEnabled(!this.internalRulesetCheckBox.isSelected());
        this.rulesetFolderTextField.setEnabled(!this.internalRulesetCheckBox.isSelected());
        this.selectRulesetFolderButton.setEnabled(!this.internalRulesetCheckBox.isSelected());
    }

    private void updateVehiclePanel(String selectedBookmarkName) {
        this.bookmarkComboBox.removeAllItems();
        for (String bookmarkName : this.parameterBookmarks.keySet()) {
            this.bookmarkComboBox.addItem(bookmarkName);
        }
        if (selectedBookmarkName == null) {
            if (this.bookmarkComboBox.getItemCount() > 0) {
                this.bookmarkComboBox.setSelectedIndex(0);
            }
        } else {
            this.bookmarkComboBox.setSelectedItem(selectedBookmarkName);
        }
        this.editBookmarkButton.setEnabled(this.parameterBookmarks.size() > 0);
        this.deleteBookmarkButton.setEnabled(this.parameterBookmarks.size() > 0);
    }

    private class ArrowPreviewPanel
    extends JPanel {
        public ArrowPreviewPanel() {
            this.setPreferredSize(new Dimension(100, 50));
            this.setBackground(Color.DARK_GRAY);
        }

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2D = (Graphics2D)g;
            Point p1 = new Point(15, this.getHeight() / 2);
            Point p2 = new Point(this.getWidth() - 15, this.getHeight() / 2);
            g2D.setStroke(new BasicStroke(3.0f, 1, 1));
            g2D.setColor(GraphViewPreferenceEditor.this.segmentColorField.getBackground());
            g2D.draw(new Line2D.Float(p1.x, p1.y, p2.x, p2.y));
            GraphViewLayer.paintNode(g, p1, GraphViewPreferenceEditor.this.nodeColorField.getBackground());
            GraphViewLayer.paintNode(g, p2, GraphViewPreferenceEditor.this.nodeColorField.getBackground());
            GraphViewLayer.paintArrowhead(g2D, p1, p2, (double)GraphViewPreferenceEditor.this.arrowheadPlacementSlider.getValue() / 100.0, GraphViewPreferenceEditor.this.segmentColorField.getBackground(), GraphViewPreferenceEditor.this.arrowheadFillColorField.getBackground());
        }
    }
}

