/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import livegps.LiveGpsAcquirer;
import livegps.LiveGpsDialog;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LiveGpsPlugin
extends Plugin
implements MapView.LayerChangeListener {
    private boolean enabled = false;
    private LiveGpsAcquirer acquirer = null;
    private Thread acquirerThread = null;
    private JMenu lgpsmenu = null;
    private JCheckBoxMenuItem lgpscapture;
    private JCheckBoxMenuItem lgpsautocenter;
    private LiveGpsDialog lgpsdialog;
    List<PropertyChangeListener> listenerQueue = new ArrayList<PropertyChangeListener>();
    private GpxData data = new GpxData();
    private LiveGpsLayer lgpslayer = null;

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer != this.lgpslayer) {
            return;
        }
        this.enableTracking(false);
        this.lgpscapture.setSelected(false);
        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
        this.lgpslayer = null;
    }

    public LiveGpsPlugin(PluginInformation info) {
        super(info);
        MainMenu menu = Main.main.menu;
        String string = I18n.marktr((String)"LiveGPS");
        menu.getClass();
        this.lgpsmenu = menu.addMenu(string, 71, 7, HelpUtil.ht((String)"/Plugin/LiveGPS"));
        CaptureAction captureAction = new CaptureAction();
        this.lgpscapture = new JCheckBoxMenuItem((Action)((Object)captureAction));
        this.lgpsmenu.add(this.lgpscapture);
        this.lgpscapture.setAccelerator(captureAction.getShortcut().getKeyStroke());
        CenterAction centerAction = new CenterAction();
        JMenuItem centerMenu = new JMenuItem((Action)((Object)centerAction));
        this.lgpsmenu.add(centerMenu);
        centerMenu.setAccelerator(centerAction.getShortcut().getKeyStroke());
        AutoCenterAction autoCenterAction = new AutoCenterAction();
        this.lgpsautocenter = new JCheckBoxMenuItem((Action)((Object)autoCenterAction));
        this.lgpsmenu.add(this.lgpsautocenter);
        this.lgpsautocenter.setAccelerator(autoCenterAction.getShortcut().getKeyStroke());
    }

    public void setAutoCenter(boolean autoCenter) {
        this.lgpsautocenter.setSelected(autoCenter);
        if (this.lgpslayer != null) {
            this.lgpslayer.setAutoCenter(autoCenter);
            if (autoCenter) {
                this.lgpslayer.center();
            }
        }
    }

    public boolean isAutoCenter() {
        return this.lgpsautocenter.isSelected();
    }

    public void enableTracking(boolean enable) {
        if (enable && !this.enabled) {
            assert (this.acquirer == null);
            assert (this.acquirerThread == null);
            this.acquirer = new LiveGpsAcquirer();
            this.acquirerThread = new Thread(this.acquirer);
            if (this.lgpslayer == null) {
                this.lgpslayer = new LiveGpsLayer(this.data);
                Main.main.addLayer((Layer)this.lgpslayer);
                MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
                this.lgpslayer.setAutoCenter(this.isAutoCenter());
            }
            this.acquirer.addPropertyChangeListener(this.lgpslayer);
            this.acquirer.addPropertyChangeListener(this.lgpsdialog);
            for (PropertyChangeListener listener : this.listenerQueue) {
                this.acquirer.addPropertyChangeListener(listener);
            }
            this.acquirerThread.start();
            this.enabled = true;
        } else if (!enable && this.enabled) {
            assert (this.lgpslayer != null);
            assert (this.acquirer != null);
            assert (this.acquirerThread != null);
            this.acquirer.shutdown();
            this.acquirer = null;
            this.acquirerThread = null;
            this.enabled = false;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        assert (!this.listenerQueue.contains(listener));
        this.listenerQueue.add(listener);
        if (this.acquirer != null) {
            this.acquirer.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        assert (this.listenerQueue.contains(listener));
        this.listenerQueue.remove(listener);
        if (this.acquirer != null) {
            this.acquirer.removePropertyChangeListener(listener);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.lgpsdialog = new LiveGpsDialog(newFrame);
            newFrame.addToggleDialog((ToggleDialog)this.lgpsdialog);
        }
    }

    public JMenu getLgpsMenu() {
        return this.lgpsmenu;
    }

    public class AutoCenterAction
    extends JosmAction {
        public AutoCenterAction() {
            super(I18n.tr((String)"Auto-Center", (Object[])new Object[0]), "autocentermenu", I18n.tr((String)"Continuously center the LiveGPS layer to current position.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"menu:livegps:autocenter", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Capture GPS Track", (Object[])new Object[0])}), (int)36, (int)5006), true);
        }

        public void actionPerformed(ActionEvent e) {
            if (LiveGpsPlugin.this.lgpslayer != null) {
                LiveGpsPlugin.this.setAutoCenter(LiveGpsPlugin.this.lgpsautocenter.isSelected());
            }
        }
    }

    public class CenterAction
    extends JosmAction {
        public CenterAction() {
            super(I18n.tr((String)"Center Once", (Object[])new Object[0]), "centermenu", I18n.tr((String)"Center the LiveGPS layer to current position.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"edit:centergps", (String)I18n.tr((String)"Edit: {0}", (Object[])new Object[]{I18n.tr((String)"Center Once", (Object[])new Object[0])}), (int)36, (int)5003), true);
        }

        public void actionPerformed(ActionEvent e) {
            if (LiveGpsPlugin.this.lgpslayer != null) {
                LiveGpsPlugin.this.lgpslayer.center();
            }
        }
    }

    public class CaptureAction
    extends JosmAction {
        public CaptureAction() {
            super(I18n.tr((String)"Capture GPS Track", (Object[])new Object[0]), "capturemenu", I18n.tr((String)"Connect to gpsd server and show current position in LiveGPS layer.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"menu:livegps:capture", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Capture GPS Track", (Object[])new Object[0])}), (int)82, (int)5006), true);
        }

        public void actionPerformed(ActionEvent e) {
            LiveGpsPlugin.this.enableTracking(LiveGpsPlugin.this.lgpscapture.isSelected());
        }
    }
}

