/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.connectedness;

import java.util.ArrayList;
import java.util.Vector;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;

public class DiGraphSealer {
    private int newID = 1000000;
    private ChannelDiGraph digraph;

    public DiGraphSealer(ChannelDiGraph digraph) {
        this.digraph = digraph;
    }

    public DiGraphSealer(ChannelDiGraph digraph, int newID) {
        this.digraph = digraph;
        this.newID = newID;
    }

    public void sealingGraph() {
        LeadsTo tempLeadsTo;
        Channel tempChannel;
        int i;
        Vector<Integer> outgoingChannelIDs = new Vector<Integer>();
        Vector<Integer> incomingChannelIDs = new Vector<Integer>();
        for (int i2 = 0; i2 < this.digraph.numberOfChannels(); ++i2) {
            if (!this.digraph.isInBBox(this.digraph.getChannelAtPosition(i2).getFromNode())) {
                incomingChannelIDs.add(i2);
            }
            if (this.digraph.isInBBox(this.digraph.getChannelAtPosition(i2).getToNode())) continue;
            outgoingChannelIDs.add(i2);
        }
        int counter = 0;
        for (i = 0; i < outgoingChannelIDs.size(); ++i) {
            if (this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i)).getLeadsTo().size() != 0) continue;
            tempChannel = new Channel(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i)).getToNode(), this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(0)).getFromNode());
            tempLeadsTo = new LeadsTo(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i)), tempChannel);
            this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i)).addLeadsTo(tempLeadsTo);
            this.digraph.addLeadsTo(tempLeadsTo);
            tempLeadsTo = new LeadsTo(tempChannel, this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(0)));
            tempChannel.addLeadsTo(tempLeadsTo);
            this.digraph.addLeadsTo(tempLeadsTo);
            tempChannel.addWay(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i)).getWay());
            tempChannel.setNewid(this.newID);
            ++this.newID;
            this.digraph.addChannel(tempChannel);
            ++counter;
        }
        for (i = 0; i < incomingChannelIDs.size(); ++i) {
            if (this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i)).getPredChannels().size() != 0) continue;
            tempChannel = new Channel(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(0)).getToNode(), this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i)).getFromNode());
            this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i)).addPredChannel(tempChannel);
            tempLeadsTo = new LeadsTo(tempChannel, this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i)));
            tempChannel.addLeadsTo(tempLeadsTo);
            this.digraph.addLeadsTo(tempLeadsTo);
            tempLeadsTo = new LeadsTo(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(0)), tempChannel);
            this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(0)).addLeadsTo(tempLeadsTo);
            this.digraph.addLeadsTo(tempLeadsTo);
            tempChannel.addWay(this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i)).getWay());
            tempChannel.setNewid(this.newID);
            ++this.newID;
            this.digraph.addChannel(tempChannel);
            ++counter;
        }
        this.deleteDuplicateChannels();
    }

    private void deleteDuplicateChannels() {
        ArrayList pointer = new ArrayList();
        for (int i = 0; i < this.digraph.getChannels().size(); ++i) {
            for (int j = i + 1; j < this.digraph.getChannels().size(); ++j) {
                if (this.digraph.getChannelAtPosition(i).getFromNode() != this.digraph.getChannelAtPosition(j).getFromNode() || this.digraph.getChannelAtPosition(i).getToNode() != this.digraph.getChannelAtPosition(j).getToNode()) continue;
                this.digraph.removeChannel(this.digraph.getChannelAtPosition(j));
            }
        }
    }

    public void setNewID(int newID) {
        this.newID = newID;
    }

    public int getNewID() {
        return this.newID;
    }

    public ChannelDiGraph getDiGraph() {
        return this.digraph;
    }
}

