/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.proj4j;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.plugins.proj4j.Proj4JProjection;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proj4JProjectionChoice
implements ProjectionChoice {
    private String crsCode = "EPSG:4326";
    private String filterText = "";
    private JTable table;
    private JTextField filterTextField;
    private JLabel selectedLabel;
    private CRSTableModel model;
    private TableRowSorter<CRSTableModel> sorter;
    private ActionListener actionListener;

    public Proj4JProjectionChoice() {
        try {
            this.model = new CRSTableModel();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sorter = new TableRowSorter<CRSTableModel>(this.model);
    }

    public String getId() {
        return "proj4jplugin";
    }

    public JPanel getPreferencePanel(ActionListener actionListener) {
        return new Proj4JPanel(actionListener);
    }

    public Collection<String> getPreferences(JPanel p) {
        return Arrays.asList(this.crsCode, this.filterText);
    }

    public Collection<String> getPreferencesFromCode(String code) {
        return Collections.singleton(code);
    }

    public void setPreferences(Collection<String> args) {
        if (args != null) {
            String[] array = args.toArray(new String[0]);
            if (array.length > 0) {
                this.crsCode = array[0];
            }
            if (array.length > 1) {
                this.filterText = array[1];
            }
        }
    }

    public Projection getProjection() {
        return new Proj4JProjection(this.crsCode);
    }

    public String toString() {
        return I18n.tr((String)"Proj4J Plugin", (Object[])new Object[0]);
    }

    public String[] allCodes() {
        return this.model.getAllCodes();
    }

    private void updateSelectedCode() {
        int index = this.table.getSelectedRow();
        if (index >= 0 && (index = this.table.convertRowIndexToModel(index)) >= 0) {
            this.crsCode = this.model.getCRSEntryAt(index).getName();
            this.selectedLabel.setText(I18n.tr((String)"Selected: {0}", (Object[])new Object[]{this.crsCode}));
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this.selectedLabel, 0, "CRS changed"));
            }
        }
    }

    private void newFilter() {
        RowFilter rf = null;
        this.filterText = this.filterTextField.getText();
        try {
            rf = RowFilter.regexFilter("(?i)" + this.filterText, new int[0]);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.sorter.setRowFilter(rf);
    }

    class CRSTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{I18n.tr((String)"Code", (Object[])new Object[0]), I18n.tr((String)"Description", (Object[])new Object[0])};
        private ArrayList<CRSEntry> crsList = new ArrayList();

        public CRSTableModel() throws IOException {
            String s;
            InputStream inStr = this.getClass().getResourceAsStream("/resources/projections.txt");
            BufferedReader fh = new BufferedReader(new InputStreamReader(inStr));
            while ((s = fh.readLine()) != null) {
                String[] f = s.split("\t");
                if (f.length < 3) continue;
                this.crsList.add(new CRSEntry(f[0], f[1], f[2]));
            }
            fh.close();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.crsList.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (row >= this.crsList.size()) {
                return "Empty";
            }
            if (col == 0) {
                return this.crsList.get(row).getName();
            }
            return this.crsList.get(row).getDescription();
        }

        public CRSEntry getCRSEntryAt(int index) {
            return this.crsList.get(index);
        }

        public String[] getAllCodes() {
            int size = this.crsList.size();
            String[] codes = new String[size];
            for (int i = 0; i < size; ++i) {
                codes[i] = this.crsList.get(i).getName();
            }
            return codes;
        }

        public int findCode(String code) {
            int size = this.crsList.size();
            for (int i = 0; i < size; ++i) {
                if (code.compareTo(this.crsList.get(i).getName()) != 0) continue;
                return i;
            }
            return -1;
        }
    }

    class CRSEntry {
        public String authority;
        public String code;
        public String description;

        public CRSEntry(String authority, String code, String description) {
            this.code = code;
            this.authority = authority;
            this.description = description;
        }

        public String getName() {
            return this.authority + ":" + this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            Proj4JProjectionChoice.this.updateSelectedCode();
        }
    }

    protected class Proj4JPanel
    extends JPanel {
        public Proj4JPanel(ActionListener actionListener) {
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            JLabel filterLabel = new JLabel(I18n.tr((String)"Filter", (Object[])new Object[0]), 11);
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 0;
            this.add((Component)filterLabel, c);
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 2;
            Proj4JProjectionChoice.this.filterTextField = new JTextField(Proj4JProjectionChoice.this.filterText, 20);
            Proj4JProjectionChoice.this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    Proj4JProjectionChoice.this.newFilter();
                }

                public void removeUpdate(DocumentEvent e) {
                    Proj4JProjectionChoice.this.newFilter();
                }

                public void changedUpdate(DocumentEvent e) {
                    Proj4JProjectionChoice.this.newFilter();
                }
            });
            this.add((Component)Proj4JProjectionChoice.this.filterTextField, c);
            Proj4JProjectionChoice.this.selectedLabel = new JLabel(I18n.tr((String)"Selected: {0}", (Object[])new Object[]{Proj4JProjectionChoice.this.crsCode}), 11);
            c.gridx = 3;
            c.gridy = 0;
            c.fill = 2;
            this.add(Proj4JProjectionChoice.this.selectedLabel);
            filterLabel.setLabelFor(Proj4JProjectionChoice.this.filterTextField);
            Proj4JProjectionChoice.this.table = new JTable(Proj4JProjectionChoice.this.model);
            Proj4JProjectionChoice.this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
            Proj4JProjectionChoice.this.table.setFillsViewportHeight(true);
            Proj4JProjectionChoice.this.table.setRowSorter(Proj4JProjectionChoice.this.sorter);
            Proj4JProjectionChoice.this.table.setSelectionMode(0);
            JScrollPane scrollPane = new JScrollPane(Proj4JProjectionChoice.this.table);
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 1;
            c.gridwidth = 3;
            this.add((Component)scrollPane, c);
            Proj4JProjectionChoice.this.newFilter();
            int index = Proj4JProjectionChoice.this.model.findCode(Proj4JProjectionChoice.this.crsCode);
            if (index >= 0 && (index = Proj4JProjectionChoice.this.table.convertRowIndexToView(index)) >= 0) {
                Proj4JProjectionChoice.this.table.addRowSelectionInterval(index, index);
                Proj4JProjectionChoice.this.table.scrollRectToVisible(Proj4JProjectionChoice.this.table.getCellRect(index, 0, true));
            }
            Proj4JProjectionChoice.this.table.getSelectionModel().addListSelectionListener(new SelectionListener(Proj4JProjectionChoice.this.table));
            Proj4JProjectionChoice.this.actionListener = actionListener;
        }
    }
}

