/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.housenumbertool;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.housenumbertool.TagDialog;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchAction
extends JosmAction
implements SelectionChangedListener {
    private static final long serialVersionUID = -3508864293222033185L;
    private OsmPrimitive selection = null;
    private String pluginDir;

    public LaunchAction(String pluginDir) {
        super("HouseNumberTaggingTool", "home-icon32", "Launches the HouseNumberTaggingTool dialog", Shortcut.registerShortcut((String)"edit:housenumbertaggingtool", (String)"HouseNumberTaggingTool", (int)75, (int)5003), true);
        this.pluginDir = pluginDir;
        DataSet.addSelectionListener((SelectionChangedListener)this);
        this.setEnabled(false);
    }

    protected void launchEditor() {
        if (!this.isEnabled()) {
            return;
        }
        TagDialog dialog = new TagDialog(this.pluginDir, this.selection);
        dialog.showDialog();
    }

    public void actionPerformed(ActionEvent e) {
        this.launchEditor();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (newSelection != null && newSelection.size() == 1) {
            this.setEnabled(true);
            this.selection = newSelection.iterator().next();
        } else {
            this.setEnabled(false);
            this.selection = null;
        }
    }
}

