/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.ImageryIdGenerator;
import iodb.ImageryOffset;
import java.text.MessageFormat;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

public class ImageryOffsetTools {
    public static final String DIALOG_TITLE = I18n.tr((String)"Imagery Offset Database", (Object[])new Object[0]);

    public static ImageryLayer getTopImageryLayer() {
        if (Main.map == null || Main.map.mapView == null) {
            return null;
        }
        List layers = Main.map.mapView.getLayersOfType(ImageryLayer.class);
        for (ImageryLayer layer : layers) {
            if (!layer.isVisible()) continue;
            return layer;
        }
        return null;
    }

    public static LatLon getMapCenter() {
        Projection proj = Main.getProjection();
        return Main.map == null || Main.map.mapView == null ? new LatLon(0.0, 0.0) : proj.eastNorth2latlon(Main.map.mapView.getCenter());
    }

    public static LatLon getLayerOffset(ImageryLayer layer, LatLon center) {
        Projection proj = Main.getProjection();
        EastNorth offsetCenter = Main.map.mapView.getCenter();
        EastNorth centerOffset = offsetCenter.add(-layer.getDx(), -layer.getDy());
        LatLon offsetLL = proj.eastNorth2latlon(centerOffset);
        return offsetLL;
    }

    public static void applyLayerOffset(ImageryLayer layer, ImageryOffset offset) {
        double[] dxy = ImageryOffsetTools.calculateOffset(offset);
        layer.setOffset(dxy[0], dxy[1]);
    }

    public static double[] calculateOffset(ImageryOffset offset) {
        Projection proj = Main.getProjection();
        EastNorth center = proj.latlon2eastNorth(offset.getPosition());
        EastNorth offsetPos = proj.latlon2eastNorth(offset.getImageryPos());
        return new double[]{center.getX() - offsetPos.getX(), center.getY() - offsetPos.getY()};
    }

    public static String getImageryID(ImageryLayer layer) {
        return layer == null ? null : ImageryIdGenerator.getImageryID(layer.getInfo().getUrl(), layer.getInfo().getImageryType());
    }

    private static double latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI;
    }

    private static double lonToTileX(double lon, int zoom) {
        return Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0;
    }

    public static int getCurrentZoom() {
        if (Main.map == null || Main.map.mapView == null) {
            return 1;
        }
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        double x1 = ImageryOffsetTools.lonToTileX(topLeft.lon(), 1);
        double y1 = ImageryOffsetTools.latToTileY(topLeft.lat(), 1);
        double x2 = ImageryOffsetTools.lonToTileX(botRight.lon(), 1);
        double y2 = ImageryOffsetTools.latToTileY(botRight.lat(), 1);
        int screenPixels = mv.getWidth() * mv.getHeight();
        double tilePixels = Math.abs((y2 - y1) * (x2 - x1) * 256.0 * 256.0);
        if (screenPixels == 0 || tilePixels == 0.0) {
            return 1;
        }
        double factor = (double)screenPixels / tilePixels;
        double result = Math.log(factor) / Math.log(2.0) / 2.0 + 1.0;
        int intResult = (int)Math.floor(result);
        return intResult;
    }

    public static String formatDistance(double d) {
        if (d < 0.0095) {
            return ImageryOffsetTools.formatDistance(d * 1000.0, I18n.tr((String)"mm", (Object[])new Object[0]), true);
        }
        if (d < 0.095) {
            return ImageryOffsetTools.formatDistance(d * 100.0, I18n.tr((String)"cm", (Object[])new Object[0]), true);
        }
        if (d < 0.95) {
            return ImageryOffsetTools.formatDistance(d * 100.0, I18n.tr((String)"cm", (Object[])new Object[0]), false);
        }
        if (d < 9.5) {
            return ImageryOffsetTools.formatDistance(d, I18n.tr((String)"m", (Object[])new Object[0]), true);
        }
        if (d < 950.0) {
            return ImageryOffsetTools.formatDistance(d, I18n.tr((String)"m", (Object[])new Object[0]), false);
        }
        if (d < 9500.0) {
            return ImageryOffsetTools.formatDistance(d / 1000.0, I18n.tr((String)"km", (Object[])new Object[0]), true);
        }
        if (d < 1000000.0) {
            return ImageryOffsetTools.formatDistance(d / 1000.0, I18n.tr((String)"km", (Object[])new Object[0]), false);
        }
        return "\u221e";
    }

    private static String formatDistance(double d, String si, boolean floating) {
        return MessageFormat.format(floating ? "{0,number,0.0} {1}" : "{0,number,0} {1}", d, si);
    }
}

