/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.CalibrationObject;
import iodb.ImageryOffset;
import iodb.ImageryOffsetBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IODBReader {
    private List<ImageryOffsetBase> offsets;
    private InputSource source;

    public IODBReader(InputStream source) throws IOException {
        this.source = new InputSource((Reader)UTFInputStreamReader.create((InputStream)source, (String)"UTF-8"));
        this.offsets = new ArrayList<ImageryOffsetBase>();
    }

    public List<ImageryOffsetBase> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.newSAXParser().parse(this.source, (DefaultHandler)parser);
            return this.offsets;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    private class IOFields {
        public int id;
        public LatLon position;
        public Date date;
        public String author;
        public String description;
        public Date abandonDate;
        public String abandonAuthor;
        public String abandonReason;
        public LatLon imageryPos;
        public String imagery;
        public int minZoom;
        public int maxZoom;
        public boolean flagged;
        public List<LatLon> geometry;

        public IOFields() {
            this.clear();
        }

        public void clear() {
            this.id = -1;
            this.position = null;
            this.date = null;
            this.author = null;
            this.description = null;
            this.abandonDate = null;
            this.abandonAuthor = null;
            this.abandonReason = null;
            this.imageryPos = null;
            this.imagery = null;
            this.minZoom = -1;
            this.maxZoom = -1;
            this.flagged = false;
            this.geometry = new ArrayList<LatLon>();
        }

        public ImageryOffsetBase constructObject() {
            ImageryOffsetBase result;
            if (this.author == null || this.description == null || this.position == null || this.date == null) {
                throw new IllegalArgumentException("Not enought arguments to build an object");
            }
            if (this.geometry.isEmpty()) {
                if (this.imagery == null || this.imageryPos == null) {
                    throw new IllegalArgumentException("Both imagery and imageryPos should be specified for the offset");
                }
                result = new ImageryOffset(this.imagery, this.imageryPos);
                if (this.minZoom >= 0) {
                    ((ImageryOffset)result).setMinZoom(this.minZoom);
                }
                if (this.maxZoom >= 0) {
                    ((ImageryOffset)result).setMaxZoom(this.maxZoom);
                }
            } else {
                result = new CalibrationObject(this.geometry.toArray(new LatLon[0]));
            }
            if (this.id >= 0) {
                result.setId(this.id);
            }
            result.setBasicInfo(this.position, this.author, this.description, this.date);
            result.setDeprecated(this.abandonDate, this.abandonAuthor, this.abandonReason);
            if (this.flagged) {
                result.setFlagged(this.flagged);
            }
            return result;
        }
    }

    private class Parser
    extends DefaultHandler {
        private StringBuffer accumulator = new StringBuffer();
        private IOFields fields;
        private boolean parsingOffset;
        private boolean parsingDeprecate;
        private SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd");

        private Parser() {
        }

        public void startDocument() throws SAXException {
            this.fields = new IOFields();
            IODBReader.this.offsets.clear();
            this.parsingOffset = false;
        }

        private LatLon parseLatLon(Attributes atts) {
            return new LatLon(Double.parseDouble(atts.getValue("lat")), Double.parseDouble(atts.getValue("lon")));
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.parsingOffset) {
                if (qName.equals("offset") || qName.equals("calibration")) {
                    this.parsingOffset = true;
                    this.parsingDeprecate = false;
                    this.fields.clear();
                    this.fields.position = this.parseLatLon(attributes);
                    this.fields.id = Integer.parseInt(attributes.getValue("id"));
                    if (attributes.getValue("flagged") != null && attributes.getValue("flagged").equals("yes")) {
                        this.fields.flagged = true;
                    }
                }
            } else if (qName.equals("node")) {
                this.fields.geometry.add(this.parseLatLon(attributes));
            } else if (qName.equals("imagery-position")) {
                this.fields.imageryPos = this.parseLatLon(attributes);
            } else if (qName.equals("imagery")) {
                String minZoom = attributes.getValue("minzoom");
                String maxZoom = attributes.getValue("maxzoom");
                if (minZoom != null) {
                    this.fields.minZoom = Integer.parseInt(minZoom);
                }
                if (maxZoom != null) {
                    this.fields.maxZoom = Integer.parseInt(maxZoom);
                }
            } else if (qName.equals("deprecated")) {
                this.parsingDeprecate = true;
            }
            this.accumulator.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.parsingOffset) {
                this.accumulator.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.parsingOffset) {
                if (qName.equals("author")) {
                    if (!this.parsingDeprecate) {
                        this.fields.author = this.accumulator.toString();
                    } else {
                        this.fields.abandonAuthor = this.accumulator.toString();
                    }
                } else if (qName.equals("description")) {
                    this.fields.description = this.accumulator.toString();
                } else if (qName.equals("reason") && this.parsingDeprecate) {
                    this.fields.abandonReason = this.accumulator.toString();
                } else if (qName.equals("date")) {
                    try {
                        if (!this.parsingDeprecate) {
                            this.fields.date = this.dateParser.parse(this.accumulator.toString());
                        }
                        this.fields.abandonDate = this.dateParser.parse(this.accumulator.toString());
                    }
                    catch (ParseException ex) {
                        throw new SAXException(ex);
                    }
                } else if (qName.equals("deprecated")) {
                    this.parsingDeprecate = false;
                } else if (qName.equals("imagery")) {
                    this.fields.imagery = this.accumulator.toString();
                } else if (qName.equals("offset") || qName.equals("calibration")) {
                    try {
                        IODBReader.this.offsets.add(this.fields.constructObject());
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println(ex.getMessage());
                    }
                    this.parsingOffset = false;
                }
            }
        }
    }
}

