/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.CalibrationObject;
import iodb.ImageryOffset;
import iodb.ImageryOffsetBase;
import iodb.ImageryOffsetTools;
import iodb.SimpleOffsetQueryTask;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OffsetInfoAction
extends AbstractAction {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd MMMM yyyy");
    ImageryOffsetBase offset;

    public OffsetInfoAction(ImageryOffsetBase offset) {
        super(I18n.tr((String)"Offset Information", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"info"));
        this.offset = offset;
        this.setEnabled(offset != null);
    }

    public void actionPerformed(ActionEvent e) {
        Object info;
        Object object = info = this.offset == null ? null : OffsetInfoAction.getInformationObject(this.offset);
        if (this.offset.isFlagged()) {
            JOptionPane.showMessageDialog(Main.parent, info, ImageryOffsetTools.DIALOG_TITLE, -1);
        } else {
            String reason;
            int result = JOptionPane.showOptionDialog(Main.parent, info, ImageryOffsetTools.DIALOG_TITLE, -1, -1, null, new String[]{"OK", I18n.tr((String)"Report this offset", (Object[])new Object[0])}, null);
            if (result == 1 && (reason = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"You are to notify moderators of this offset. Why?", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, -1)) != null && reason.toString().length() > 0) {
                try {
                    String query = "report?id=" + this.offset.getId() + "&reason=" + URLEncoder.encode(reason.toString(), "UTF8");
                    SimpleOffsetQueryTask reportTask = new SimpleOffsetQueryTask(query, I18n.tr((String)"Reporting the offset...", (Object[])new Object[0]));
                    Main.worker.submit((Runnable)((Object)reportTask));
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
        }
    }

    public static Object getInformationObject(ImageryOffsetBase offset) {
        StringBuilder sb = new StringBuilder();
        if (offset instanceof ImageryOffset) {
            double odist = ((ImageryOffset)offset).getImageryPos().greatCircleDistance(offset.getPosition());
            if (odist < 0.01) {
                odist = 0.0;
            }
            sb.append(I18n.tr((String)"An imagery offset of {0}", (Object[])new Object[]{ImageryOffsetTools.formatDistance(odist)})).append('\n');
            sb.append(I18n.tr((String)"Imagery ID", (Object[])new Object[0])).append(": ").append(((ImageryOffset)offset).getImagery()).append('\n');
        } else {
            sb.append(I18n.tr((String)"A calibration {0}", (Object[])new Object[]{OffsetInfoAction.getGeometryType((CalibrationObject)offset)})).append('\n');
        }
        double dist = ImageryOffsetTools.getMapCenter().greatCircleDistance(offset.getPosition());
        sb.append(dist < 50.0 ? I18n.tr((String)"Determined right here", (Object[])new Object[0]) : I18n.tr((String)"Determined {0} away", (Object[])new Object[]{ImageryOffsetTools.formatDistance(dist)}));
        sb.append("\n\n");
        sb.append(I18n.tr((String)"Created by {0} on {1}", (Object[])new Object[]{offset.getAuthor(), DATE_FORMAT.format(offset.getDate())})).append('\n');
        sb.append(I18n.tr((String)"Description", (Object[])new Object[0])).append(": ").append(offset.getDescription());
        if (offset.isDeprecated()) {
            sb.append("\n\n");
            sb.append(I18n.tr((String)"Deprecated by {0} on {1}", (Object[])new Object[]{offset.getAbandonAuthor(), DATE_FORMAT.format(offset.getAbandonDate())})).append('\n');
            sb.append(I18n.tr((String)"Reason", (Object[])new Object[0])).append(": ").append(offset.getAbandonReason());
        }
        if (offset.isFlagged()) {
            sb.append("\n\n").append(I18n.tr((String)"This entry has been reported.", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public static String getGeometryType(CalibrationObject obj) {
        if (obj.getGeometry() == null) {
            return "nothing";
        }
        int n = obj.getGeometry().length;
        if (n == 1) {
            return I18n.tr((String)"point", (Object[])new Object[0]);
        }
        if (n > 1 && !obj.getGeometry()[0].equals((Object)obj.getGeometry()[n - 1])) {
            return I18n.tr((String)"path ({0} nodes)", (Object[])new Object[]{n});
        }
        if (n > 1 && obj.getGeometry()[0].equals((Object)obj.getGeometry()[n - 1])) {
            return I18n.tr((String)"polygon ({0} nodes)", (Object[])new Object[]{n - 1});
        }
        return "geometry";
    }
}

