/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.CalibrationObject;
import iodb.OffsetInfoAction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CalibrationLayer
extends Layer {
    private Color color = Color.RED;
    private Icon icon;
    private CalibrationObject obj;
    private LatLon center;

    public CalibrationLayer(CalibrationObject obj) {
        super(I18n.tr((String)"Calibration Layer", (Object[])new Object[0]));
        this.obj = obj;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        Stroke oldStroke = g.getStroke();
        g.setColor(this.color);
        g.setStroke(new BasicStroke(1.0f));
        LatLon[] geometry = this.obj.getGeometry();
        if (geometry.length == 1) {
            Point p = mv.getPoint(geometry[0]);
            g.drawLine(p.x, p.y, p.x, p.y);
            g.drawLine(p.x - 10, p.y, p.x - 20, p.y);
            g.drawLine(p.x + 10, p.y, p.x + 20, p.y);
            g.drawLine(p.x, p.y - 10, p.x, p.y - 20);
            g.drawLine(p.x, p.y + 10, p.x, p.y + 20);
        } else if (geometry.length > 1) {
            GeneralPath path = new GeneralPath();
            for (int i = 0; i < geometry.length; ++i) {
                Point p = mv.getPoint(geometry[i]);
                if (i == 0) {
                    path.moveTo(p.x, p.y);
                    continue;
                }
                path.lineTo(p.x, p.y);
            }
            g.draw(path);
        }
        g.setStroke(oldStroke);
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = ImageProvider.get((String)"calibration_layer");
        }
        return this.icon;
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (LatLon ll : this.obj.getGeometry()) {
            v.visit(ll);
        }
    }

    public String getToolTipText() {
        return "A " + (this.obj.isDeprecated() ? "deprecated " : "") + "calibration " + OffsetInfoAction.getGeometryType(this.obj) + " by " + this.obj.getAuthor();
    }

    public Object getInfoComponent() {
        return OffsetInfoAction.getInformationObject(this.obj);
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ZoomToLayerAction(), new SelectColorAction(Color.RED), new SelectColorAction(Color.CYAN), new SelectColorAction(Color.YELLOW), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public void panToCenter() {
        if (this.center == null) {
            LatLon[] geometry = this.obj.getGeometry();
            double lat = 0.0;
            double lon = 0.0;
            for (int i = 0; i < geometry.length; ++i) {
                lon += geometry[i].lon();
                lat += geometry[i].lat();
            }
            this.center = new LatLon(lat / (double)geometry.length, lon / (double)geometry.length);
        }
        Main.map.mapView.zoomTo(this.center);
    }

    class ZoomToLayerAction
    extends AbstractAction {
        public ZoomToLayerAction() {
            super(I18n.tr((String)"Zoom to layer", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs/autoscale/layer"));
        }

        public void actionPerformed(ActionEvent e) {
            AutoScaleAction.autoScale((String)"layer");
        }
    }

    class SingleColorIcon
    implements Icon {
        private Color color;

        public SingleColorIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 24, 24);
        }

        public int getIconWidth() {
            return 24;
        }

        public int getIconHeight() {
            return 24;
        }
    }

    class SelectColorAction
    extends AbstractAction {
        private Color c;

        public SelectColorAction(Color color) {
            super(I18n.tr((String)"Change Color", (Object[])new Object[0]));
            this.putValue("SmallIcon", new SingleColorIcon(color));
            this.c = color;
        }

        public void actionPerformed(ActionEvent e) {
            CalibrationLayer.this.color = this.c;
            Main.map.mapView.repaint();
        }
    }
}

