/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitObjectAction
extends JosmAction {
    public SplitObjectAction() {
        super(I18n.tr((String)"Split Object", (Object[])new Object[0]), "splitobject", I18n.tr((String)"Split an object at the selected nodes.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:splitobject", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Split Object", (Object[])new Object[0])}), (int)88, (int)5004), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SplitObject"));
    }

    public void actionPerformed(ActionEvent e) {
        int n;
        Collection selection = SplitObjectAction.getCurrentDataSet().getSelected();
        List selectedNodes = OsmPrimitive.getFilteredList((Collection)selection, Node.class);
        List selectedWays = OsmPrimitive.getFilteredList((Collection)selection, Way.class);
        if (!this.checkSelection(selection)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The current selection cannot be used for splitting.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        }
        Way selectedWay = null;
        Way splitWay = null;
        if (selectedNodes.size() != 2) {
            selectedNodes.clear();
            for (Way selWay : selectedWays) {
                if (selWay != null && selWay.isUsable() && !selWay.isClosed() && selWay.getKeys().isEmpty()) {
                    selectedNodes.add(selWay.firstNode());
                    selectedNodes.add(selWay.lastNode());
                    splitWay = selWay;
                    continue;
                }
                selectedWay = selWay;
            }
        }
        if (selectedWay == null && !selectedNodes.isEmpty()) {
            HashMap<Way, Integer> wayOccurenceCounter = new HashMap<Way, Integer>();
            for (Node node : selectedNodes) {
                block2: for (Way w : OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class)) {
                    int last;
                    if (!w.isUsable() || (last = w.getNodesCount() - 1) <= 4 || !w.isClosed()) continue;
                    for (Node wn : w.getNodes()) {
                        if (!node.equals((Object)wn)) continue;
                        Integer old = (Integer)wayOccurenceCounter.get(w);
                        wayOccurenceCounter.put(w, old == null ? 1 : old + 1);
                        continue block2;
                    }
                }
            }
            if (wayOccurenceCounter.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn((String)"The selected node is not in the middle of any way.", (String)"The selected nodes are not in the middle of any way.", (long)selectedNodes.size(), (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                return;
            }
            for (Map.Entry entry : wayOccurenceCounter.entrySet()) {
                if (!((Integer)entry.getValue()).equals(selectedNodes.size())) continue;
                if (selectedWay != null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.trn((String)"There is more than one way using the node you selected. Please select the way also.", (String)"There is more than one way using the nodes you selected. Please select the way also.", (long)selectedNodes.size(), (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                    return;
                }
                selectedWay = (Way)entry.getKey();
            }
            if (selectedWay == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected nodes do not share the same way.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                return;
            }
        } else if (selectedWay != null && !selectedNodes.isEmpty()) {
            if (!selectedWay.isClosed()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected way is not closed.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                return;
            }
            HashSet nds = new HashSet(selectedNodes);
            nds.removeAll(selectedWay.getNodes());
            if (!nds.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn((String)"The selected way does not contain the selected node.", (String)"The selected way does not contain all the selected nodes.", (long)selectedNodes.size(), (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                return;
            }
        } else if (selectedWay != null && selectedNodes.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected way is not a split way, please select split points or split way too.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        }
        Node node1 = (Node)selectedNodes.get(0);
        int n2 = -1;
        Node node2 = (Node)selectedNodes.get(1);
        int nodeIndex2 = -1;
        int i = 0;
        for (Node wn : selectedWay.getNodes()) {
            if (n == -1 && wn.equals((Object)node1)) {
                n = i;
            } else if (nodeIndex2 == -1 && wn.equals((Object)node2)) {
                nodeIndex2 = i;
            }
            ++i;
        }
        if (n == nodeIndex2 + 1 || nodeIndex2 == n + true || n == 0 && nodeIndex2 == selectedWay.getNodesCount() - 2 || nodeIndex2 == 0 && n == selectedWay.getNodesCount() - 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected nodes can not be consecutive nodes in the object.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        }
        List wayChunks = SplitWayAction.buildSplitChunks((Way)selectedWay, (List)selectedNodes);
        if (wayChunks != null) {
            if (splitWay == null) {
                for (List wayChunk : wayChunks) {
                    wayChunk.add((Node)wayChunk.get(0));
                }
            } else {
                for (List wayChunk : wayChunks) {
                    List way = splitWay.getNodes();
                    if (((Node)wayChunk.get(0)).equals((Object)splitWay.firstNode())) {
                        way.remove(way.size() - 1);
                        Collections.reverse(way);
                    } else {
                        way.remove(0);
                    }
                    wayChunk.addAll(way);
                }
            }
            SplitWayAction.SplitWayResult result = SplitWayAction.splitWay((OsmDataLayer)SplitObjectAction.getEditLayer(), (Way)selectedWay, (List)wayChunks, Collections.emptyList());
            Main.main.undoRedo.add(result.getCommand());
            if (splitWay != null) {
                Main.main.undoRedo.add((Command)new DeleteCommand((OsmPrimitive)splitWay));
            }
            SplitObjectAction.getCurrentDataSet().setSelected((Collection)result.getNewSelection());
        }
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> selection) {
        int node = 0;
        int ways = 0;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Way) {
                ++ways;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                ++node;
                continue;
            }
            return false;
        }
        return node == 2 || ways == true || ways == 2;
    }

    protected void updateEnabledState() {
        if (SplitObjectAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SplitObjectAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.checkSelection(selection));
    }
}

