/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.AddIntersectionsAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.AlignWayNodesAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.ExtractPointAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.PasteRelationsAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.PasteTagsExtendedAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.SplitObjectAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.SplitOnIntersectionsAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.SymmetryAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.TagBufferAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.TagSourceAction;
import org.openstreetmap.josm.plugins.utilsplugin2.actions.UnGlueRelationAction;
import org.openstreetmap.josm.plugins.utilsplugin2.curves.CurveAction;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.ChooseURLAction;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.OpenPageAction;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.UtilsPluginPreferences;
import org.openstreetmap.josm.plugins.utilsplugin2.latlon.LatLonAction;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.AdjacentNodesAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.AdjacentWaysAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.ConnectedWaysAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.IntersectedWaysAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.IntersectedWaysRecursiveAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.MiddleNodesAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.SelectAllInsideAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.SelectBoundaryAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.SelectHighwayAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.SelectModNodesAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.SelectModWaysAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.SelectWayNodesAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.UndoSelectionAction;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.UnselectNodesAction;
import org.openstreetmap.josm.tools.I18n;

public class UtilsPlugin2
extends Plugin {
    JMenuItem unglueRelation;
    JMenuItem symmetry;
    JMenuItem addIntersections;
    JMenuItem splitObject;
    JMenuItem selectWayNodes;
    JMenuItem adjNodes;
    JMenuItem unsNodes;
    JMenuItem midNodes;
    JMenuItem adjWays;
    JMenuItem adjWaysAll;
    JMenuItem intWays;
    JMenuItem intWaysR;
    JMenuItem allInside;
    JMenuItem undoSelection;
    JMenuItem extractPoint;
    JMenuItem wiki;
    JMenuItem latlon;
    JMenuItem pasteExtended;
    JMenuItem replaceGeometry;
    JMenuItem tagBuffer;
    JMenuItem sourceTag;
    JMenuItem pasteRelations;
    JMenuItem alignWayNodes;
    JMenuItem splitOnIntersections;
    JMenuItem selModifiedNodes;
    JMenuItem selModifiedWays;
    JMenuItem selectHighway;
    JMenuItem selectAreaBoundary;
    JMenuItem selectURL;
    JMenuItem drawArc;

    public UtilsPlugin2(PluginInformation info) {
        super(info);
        JMenu toolsMenu = Main.main.menu.addMenu(I18n.marktr((String)"More tools"), 81, 4, "help");
        this.unglueRelation = MainMenu.add((JMenu)toolsMenu, (JosmAction)new UnGlueRelationAction());
        this.addIntersections = MainMenu.add((JMenu)toolsMenu, (JosmAction)new AddIntersectionsAction());
        this.splitObject = MainMenu.add((JMenu)toolsMenu, (JosmAction)new SplitObjectAction());
        toolsMenu.addSeparator();
        this.replaceGeometry = MainMenu.add((JMenu)toolsMenu, (JosmAction)new ReplaceGeometryAction());
        this.tagBuffer = MainMenu.add((JMenu)toolsMenu, (JosmAction)new TagBufferAction());
        this.sourceTag = MainMenu.add((JMenu)toolsMenu, (JosmAction)new TagSourceAction());
        this.pasteRelations = MainMenu.add((JMenu)toolsMenu, (JosmAction)new PasteRelationsAction());
        this.alignWayNodes = MainMenu.add((JMenu)toolsMenu, (JosmAction)new AlignWayNodesAction());
        this.splitOnIntersections = MainMenu.add((JMenu)toolsMenu, (JosmAction)new SplitOnIntersectionsAction());
        this.extractPoint = MainMenu.add((JMenu)toolsMenu, (JosmAction)new ExtractPointAction());
        this.symmetry = MainMenu.add((JMenu)toolsMenu, (JosmAction)new SymmetryAction());
        this.wiki = MainMenu.add((JMenu)toolsMenu, (JosmAction)new OpenPageAction());
        this.latlon = MainMenu.add((JMenu)toolsMenu, (JosmAction)new LatLonAction());
        this.pasteExtended = MainMenu.add((JMenu)toolsMenu, (JosmAction)new PasteTagsExtendedAction());
        MainMenu mainMenu = Main.main.menu;
        String string = I18n.marktr((String)"Selection");
        Main.main.menu.getClass();
        JMenu selectionMenu = mainMenu.addMenu(string, 78, 7, "help");
        this.selectWayNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectWayNodesAction());
        this.adjNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new AdjacentNodesAction());
        this.unsNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new UnselectNodesAction());
        this.midNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new MiddleNodesAction());
        this.adjWays = MainMenu.add((JMenu)selectionMenu, (JosmAction)new AdjacentWaysAction());
        this.adjWaysAll = MainMenu.add((JMenu)selectionMenu, (JosmAction)new ConnectedWaysAction());
        this.intWays = MainMenu.add((JMenu)selectionMenu, (JosmAction)new IntersectedWaysAction());
        this.intWaysR = MainMenu.add((JMenu)selectionMenu, (JosmAction)new IntersectedWaysRecursiveAction());
        this.allInside = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectAllInsideAction());
        this.selModifiedNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectModNodesAction());
        this.selModifiedWays = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectModWaysAction());
        this.undoSelection = MainMenu.add((JMenu)selectionMenu, (JosmAction)new UndoSelectionAction());
        this.selectHighway = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectHighwayAction());
        this.selectAreaBoundary = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectBoundaryAction());
        this.selectURL = MainMenu.add((JMenu)toolsMenu, (JosmAction)new ChooseURLAction());
        this.drawArc = MainMenu.add((JMenu)toolsMenu, (JosmAction)new CurveAction());
        SearchCompiler.addMatchFactory((SearchCompiler.MatchFactory)new UtilsUnaryMatchFactory());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        boolean enabled = newFrame != null;
        enabled = false;
        this.unglueRelation.setEnabled(enabled);
        this.addIntersections.setEnabled(enabled);
        this.splitObject.setEnabled(enabled);
        this.replaceGeometry.setEnabled(enabled);
        this.tagBuffer.setEnabled(enabled);
        this.sourceTag.setEnabled(enabled);
        this.pasteRelations.setEnabled(enabled);
        this.alignWayNodes.setEnabled(enabled);
        this.splitOnIntersections.setEnabled(enabled);
        this.pasteExtended.setEnabled(enabled);
        this.wiki.setEnabled(enabled);
        this.selectWayNodes.setEnabled(enabled);
        this.adjNodes.setEnabled(enabled);
        this.unsNodes.setEnabled(enabled);
        this.midNodes.setEnabled(enabled);
        this.adjWays.setEnabled(enabled);
        this.adjWaysAll.setEnabled(enabled);
        this.intWays.setEnabled(enabled);
        this.intWaysR.setEnabled(enabled);
        this.selModifiedNodes.setEnabled(enabled);
        this.selModifiedWays.setEnabled(enabled);
        this.undoSelection.setEnabled(enabled);
        this.selectURL.setEnabled(enabled);
        this.allInside.setEnabled(enabled);
        this.drawArc.setEnabled(enabled);
    }

    public PreferenceSetting getPreferenceSetting() {
        return new UtilsPluginPreferences();
    }

    public static class ConnectedMatch
    extends SearchCompiler.UnaryMatch {
        private Collection<Way> connected = null;
        boolean all;

        public ConnectedMatch(SearchCompiler.Match match, boolean all) {
            super(match);
            this.all = all;
        }

        private void init(boolean all) {
            HashSet<Way> matchedWays = new HashSet<Way>();
            HashSet<Node> matchedNodes = new HashSet<Node>();
            Collection allWays = Main.main.getCurrentDataSet().getWays();
            for (Way way : allWays) {
                if (!this.match.match((OsmPrimitive)way)) continue;
                matchedWays.add(way);
            }
            Collection allNodes = Main.main.getCurrentDataSet().getNodes();
            for (Node node : allNodes) {
                if (!this.match.match((OsmPrimitive)node)) continue;
                matchedNodes.add(node);
            }
            HashSet<Way> newWays = new HashSet<Way>();
            if (all) {
                NodeWayUtils.addWaysConnectedToNodes(matchedNodes, newWays);
                NodeWayUtils.addWaysConnectedToWaysRecursively(matchedWays, newWays);
            } else {
                NodeWayUtils.addWaysConnectedToNodes(matchedNodes, newWays);
                NodeWayUtils.addWaysConnectedToWays(matchedWays, newWays);
            }
            this.connected = newWays;
        }

        public boolean match(OsmPrimitive osm) {
            if (this.connected == null) {
                this.init(this.all);
            }
            if (osm instanceof Way) {
                return this.connected.contains((Way)osm);
            }
            return false;
        }
    }

    public static class InsideMatch
    extends SearchCompiler.UnaryMatch {
        private Collection<OsmPrimitive> inside = null;

        public InsideMatch(SearchCompiler.Match match) {
            super(match);
        }

        private void init() {
            HashSet<OsmPrimitive> matchedAreas = new HashSet<OsmPrimitive>();
            Collection ways = Main.main.getCurrentDataSet().getWays();
            for (Way way : ways) {
                if (!this.match.match((OsmPrimitive)way)) continue;
                matchedAreas.add((OsmPrimitive)way);
            }
            Collection rels = Main.main.getCurrentDataSet().getRelations();
            for (Relation rel : rels) {
                if (!this.match.match((OsmPrimitive)rel)) continue;
                matchedAreas.add((OsmPrimitive)rel);
            }
            this.inside = NodeWayUtils.selectAllInside(matchedAreas, Main.main.getCurrentDataSet());
        }

        public boolean match(OsmPrimitive osm) {
            if (this.inside == null) {
                this.init();
            }
            return this.inside.contains(osm);
        }
    }

    public static class IntersectingMatch
    extends SearchCompiler.UnaryMatch {
        private Collection<Way> intersecting = null;
        boolean all;

        public IntersectingMatch(SearchCompiler.Match match, boolean all) {
            super(match);
            this.all = all;
        }

        private void init(boolean all) {
            HashSet<Way> matchedWays = new HashSet<Way>();
            Collection allWays = Main.main.getCurrentDataSet().getWays();
            for (Way way : allWays) {
                if (!this.match.match((OsmPrimitive)way)) continue;
                matchedWays.add(way);
            }
            HashSet<Way> newWays = new HashSet<Way>();
            if (all) {
                NodeWayUtils.addWaysIntersectingWaysRecursively(allWays, matchedWays, newWays);
            } else {
                NodeWayUtils.addWaysIntersectingWays(allWays, matchedWays, newWays);
            }
            this.intersecting = newWays;
        }

        public boolean match(OsmPrimitive osm) {
            if (this.intersecting == null) {
                this.init(this.all);
            }
            if (osm instanceof Way) {
                return this.intersecting.contains((Way)osm);
            }
            return false;
        }
    }

    public static class UtilsUnaryMatchFactory
    implements SearchCompiler.UnaryMatchFactory {
        private static Collection<String> keywords = Arrays.asList("inside", "intersecting", "allintersecting", "adjacent", "connected");

        public SearchCompiler.UnaryMatch get(String keyword, SearchCompiler.Match matchOperand, PushbackTokenizer tokenizer) throws SearchCompiler.ParseError {
            if ("inside".equals(keyword)) {
                return new InsideMatch(matchOperand);
            }
            if ("adjacent".equals(keyword)) {
                return new ConnectedMatch(matchOperand, false);
            }
            if ("connected".equals(keyword)) {
                return new ConnectedMatch(matchOperand, true);
            }
            if ("intersecting".equals(keyword)) {
                return new IntersectingMatch(matchOperand, false);
            }
            if ("allintersecting".equals(keyword)) {
                return new IntersectingMatch(matchOperand, true);
            }
            return null;
        }

        public Collection<String> getKeywords() {
            return keywords;
        }
    }
}

