/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.EOFException;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.mapdb.DataInput2;
import org.mapdb.Utils;

public abstract class Volume {
    public static final int BUF_SIZE = 0x40000000;
    public static final int INITIAL_SIZE = 32768;

    public abstract void ensureAvailable(long var1);

    public abstract void putLong(long var1, long var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putByte(long var1, byte var3);

    public abstract void putData(long var1, byte[] var3, int var4);

    public abstract void putData(long var1, ByteBuffer var3);

    public abstract long getLong(long var1);

    public abstract int getInt(long var1);

    public abstract byte getByte(long var1);

    public abstract DataInput2 getDataInput(long var1, int var3);

    public abstract void close();

    public abstract void sync();

    public abstract boolean isEmpty();

    public abstract void deleteFile();

    public abstract boolean isSliced();

    public final void putUnsignedShort(long offset, int value) {
        this.putByte(offset, (byte)(value >> 8));
        this.putByte(offset + 1L, (byte)value);
    }

    public final int getUnsignedShort(long offset) {
        return (this.getByte(offset) & 0xFF) << 8 | this.getByte(offset + 1L) & 0xFF;
    }

    public int getUnsignedByte(long offset) {
        return this.getByte(offset) & 0xFF;
    }

    public void putUnsignedByte(long offset, int b) {
        this.putByte(offset, (byte)(b & 0xFF));
    }

    public abstract File getFile();

    public static Volume volumeForFile(File f, boolean useRandomAccessFile, boolean readOnly) {
        return useRandomAccessFile ? new RandomAccessFileVol(f, readOnly) : new MappedFileVol(f, readOnly);
    }

    public static Factory fileFactory(boolean readOnly, boolean RAF, File indexFile) {
        return Volume.fileFactory(readOnly, RAF, indexFile, new File(indexFile.getPath() + ".p"), new File(indexFile.getPath() + ".t"));
    }

    public static Factory fileFactory(final boolean readOnly, final boolean RAF, final File indexFile, final File physFile, final File transLogFile) {
        return new Factory(){

            @Override
            public Volume createIndexVolume() {
                return Volume.volumeForFile(indexFile, RAF, readOnly);
            }

            @Override
            public Volume createPhysVolume() {
                return Volume.volumeForFile(physFile, RAF, readOnly);
            }

            @Override
            public Volume createTransLogVolume() {
                return Volume.volumeForFile(transLogFile, RAF, readOnly);
            }
        };
    }

    public static Factory memoryFactory(final boolean useDirectBuffer) {
        return new Factory(){

            @Override
            public Volume createIndexVolume() {
                return new MemoryVol(useDirectBuffer);
            }

            @Override
            public Volume createPhysVolume() {
                return new MemoryVol(useDirectBuffer);
            }

            @Override
            public Volume createTransLogVolume() {
                return new MemoryVol(useDirectBuffer);
            }
        };
    }

    public static class AsyncFileChannelVol
    extends Volume {
        protected AsynchronousFileChannel channel;
        protected final boolean readOnly;
        protected final File file;

        public AsyncFileChannelVol(File file, boolean readOnly) {
            this.readOnly = readOnly;
            this.file = file;
            try {
                this.channel = readOnly ? AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ) : AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void ensureAvailable(long offset) {
        }

        protected void await(Future<Integer> future, int size) {
            try {
                int res = future.get();
                if (res != size) {
                    throw new InternalError("not enough bytes");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void putByte(long offset, byte value) {
            ByteBuffer b = ByteBuffer.allocate(1);
            b.put(0, value);
            this.await(this.channel.write(b, offset), 1);
        }

        @Override
        public void putInt(long offset, int value) {
            ByteBuffer b = ByteBuffer.allocate(4);
            b.putInt(0, value);
            this.await(this.channel.write(b, offset), 4);
        }

        @Override
        public void putLong(long offset, long value) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong(0, value);
            this.await(this.channel.write(b, offset), 8);
        }

        @Override
        public void putData(long offset, byte[] value, int size) {
            ByteBuffer b = ByteBuffer.wrap(value);
            b.limit(size);
            this.await(this.channel.write(b, offset), size);
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            this.await(this.channel.write(buf, offset), buf.limit() - buf.position());
        }

        @Override
        public long getLong(long offset) {
            ByteBuffer b = ByteBuffer.allocate(8);
            this.await(this.channel.read(b, offset), 8);
            b.rewind();
            return b.getLong();
        }

        @Override
        public byte getByte(long offset) {
            ByteBuffer b = ByteBuffer.allocate(1);
            this.await(this.channel.read(b, offset), 1);
            b.rewind();
            return b.get();
        }

        @Override
        public int getInt(long offset) {
            ByteBuffer b = ByteBuffer.allocate(4);
            this.await(this.channel.read(b, offset), 4);
            b.rewind();
            return b.getInt();
        }

        @Override
        public DataInput2 getDataInput(long offset, int size) {
            ByteBuffer b = ByteBuffer.allocate(size);
            this.await(this.channel.read(b, offset), size);
            b.rewind();
            return new DataInput2(b, 0);
        }

        @Override
        public void close() {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void sync() {
            try {
                this.channel.force(true);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.file.length() > 0L;
        }

        @Override
        public void deleteFile() {
            this.file.delete();
        }

        @Override
        public boolean isSliced() {
            return false;
        }

        @Override
        public File getFile() {
            return this.file;
        }
    }

    public static final class RandomAccessFileVol
    extends Volume {
        protected final File file;
        protected final boolean readOnly;
        protected RandomAccessFile raf;
        protected long pos;

        public RandomAccessFileVol(File file, boolean readOnly) {
            this.file = file;
            this.readOnly = readOnly;
            try {
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.raf.seek(0L);
                this.pos = 0L;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized void ensureAvailable(long offset) {
        }

        @Override
        public synchronized void putLong(long offset, long value) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + 8L;
                this.raf.writeLong(value);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized void putInt(long offset, int value) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + 4L;
                this.raf.writeInt(value);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized void putByte(long offset, byte value) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + 1L;
                this.raf.writeByte(0xFF & value);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized void putData(long offset, byte[] value, int size) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + (long)size;
                this.raf.write(value, 0, size);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized void putData(long offset, ByteBuffer buf) {
            try {
                int size = buf.limit() - buf.position();
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + (long)size;
                byte[] b = new byte[size];
                buf.get(b);
                this.putData(offset, b, size);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized long getLong(long offset) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + 8L;
                return this.raf.readLong();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized int getInt(long offset) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + 4L;
                return this.raf.readInt();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized byte getByte(long offset) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + 1L;
                return this.raf.readByte();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized DataInput2 getDataInput(long offset, int size) {
            try {
                if (this.pos != offset) {
                    this.raf.seek(offset);
                }
                this.pos = offset + (long)size;
                byte[] b = new byte[size];
                this.raf.read(b);
                return new DataInput2(b);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized void close() {
            try {
                this.raf.close();
                this.raf = null;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized void sync() {
            try {
                this.raf.getFD().sync();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.file.length() == 0L;
        }

        @Override
        public synchronized void deleteFile() {
            this.file.delete();
        }

        @Override
        public boolean isSliced() {
            return false;
        }

        @Override
        public synchronized File getFile() {
            return this.file;
        }
    }

    public static final class MemoryVol
    extends ByteBufferVol {
        protected final boolean useDirectBuffer;

        public String toString() {
            return super.toString() + ",direct=" + this.useDirectBuffer;
        }

        public MemoryVol(boolean useDirectBuffer) {
            super(false);
            this.useDirectBuffer = useDirectBuffer;
            ByteBuffer b0 = useDirectBuffer ? ByteBuffer.allocateDirect(32768) : ByteBuffer.allocate(32768);
            this.buffers = new ByteBuffer[]{b0};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ByteBuffer makeNewBuffer(long offset) {
            int newBufSize = Utils.nextPowTwo((int)(offset % 0x40000000L));
            ByteBuffer newBuf = this.useDirectBuffer ? ByteBuffer.allocateDirect(newBufSize) : ByteBuffer.allocate(newBufSize);
            int buffersPos = (int)(offset / 0x40000000L);
            ByteBuffer oldBuffer = this.buffers[buffersPos];
            if (oldBuffer != null) {
                ByteBuffer byteBuffer = oldBuffer;
                synchronized (byteBuffer) {
                    oldBuffer.rewind();
                    newBuf.put(oldBuffer);
                }
            }
            return newBuf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.growLock.lock();
            try {
                for (ByteBuffer b : this.buffers) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    this.unmap((MappedByteBuffer)b);
                }
                this.buffers = null;
            }
            finally {
                this.growLock.lock();
            }
        }

        @Override
        public void sync() {
        }

        @Override
        public void deleteFile() {
        }

        @Override
        public File getFile() {
            return null;
        }
    }

    public static final class MappedFileVol
    extends ByteBufferVol {
        protected final File file;
        protected final FileChannel fileChannel;
        protected final FileChannel.MapMode mapMode;
        protected final RandomAccessFile raf;
        static final int BUF_SIZE_INC = 0x100000;

        public MappedFileVol(File file, boolean readOnly) {
            super(readOnly);
            this.file = file;
            this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            try {
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.fileChannel = this.raf.getChannel();
                long fileSize = this.fileChannel.size();
                if (fileSize > 0L) {
                    this.buffers = new ByteBuffer[(int)(1L + fileSize / 0x40000000L)];
                    int i = 0;
                    while ((long)i <= fileSize / 0x40000000L) {
                        long offset = 0x40000000L * (long)i;
                        this.buffers[i] = this.fileChannel.map(this.mapMode, offset, Math.min(0x40000000L, fileSize - offset));
                        if (this.mapMode == FileChannel.MapMode.READ_ONLY) {
                            this.buffers[i] = this.buffers[i].asReadOnlyBuffer();
                        }
                        ++i;
                    }
                } else {
                    this.buffers = new ByteBuffer[1];
                    this.buffers[0] = this.fileChannel.map(this.mapMode, 0L, 32768L);
                    if (this.mapMode == FileChannel.MapMode.READ_ONLY) {
                        this.buffers[0] = this.buffers[0].asReadOnlyBuffer();
                    }
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            this.growLock.lock();
            try {
                this.fileChannel.close();
                this.raf.close();
                if (!this.readOnly) {
                    this.sync();
                }
                for (ByteBuffer b : this.buffers) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    this.unmap((MappedByteBuffer)b);
                }
                this.buffers = null;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public void sync() {
            if (this.readOnly) {
                return;
            }
            for (ByteBuffer b : this.buffers) {
                if (b == null || !(b instanceof MappedByteBuffer)) continue;
                ((MappedByteBuffer)b).force();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.buffers[0] == null || this.buffers[0].capacity() == 0;
        }

        @Override
        public void deleteFile() {
            this.file.delete();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        protected ByteBuffer makeNewBuffer(long offset) {
            try {
                int bufPos = (int)(offset / 0x40000000L);
                if (bufPos < this.buffers.length && this.buffers[bufPos] != null) {
                    this.unmap((MappedByteBuffer)this.buffers[bufPos]);
                    this.buffers[bufPos] = null;
                }
                long newBufSize = offset % 0x40000000L;
                newBufSize += newBufSize % 0x100000L;
                return this.fileChannel.map(this.mapMode, offset - offset % 0x40000000L, newBufSize);
            }
            catch (IOException e) {
                if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                    throw new RuntimeException("File could not be mapped to memory, common problem on 32bit JVM. Use `DBMaker.newRandomAccessFileDB()` as workaround", e);
                }
                throw new IOError(e);
            }
        }
    }

    public static abstract class ByteBufferVol
    extends Volume {
        protected final ReentrantLock growLock = new ReentrantLock();
        protected ByteBuffer[] buffers;
        protected final boolean readOnly;
        private static boolean unmapHackSupported = true;

        protected ByteBufferVol(boolean readOnly) {
            this.readOnly = readOnly;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void ensureAvailable(long offset) {
            int buffersPos = (int)(offset / 0x40000000L);
            if (buffersPos < this.buffers.length && this.buffers[buffersPos] != null && (long)this.buffers[buffersPos].capacity() >= offset % 0x40000000L) {
                return;
            }
            this.growLock.lock();
            try {
                if (buffersPos < this.buffers.length && this.buffers[buffersPos] != null && (long)this.buffers[buffersPos].capacity() >= offset % 0x40000000L) {
                    return;
                }
                if (buffersPos >= this.buffers.length) {
                    this.buffers = Arrays.copyOf(this.buffers, Math.max(buffersPos, this.buffers.length * 2));
                }
                ByteBuffer newBuf = this.makeNewBuffer(offset);
                if (this.readOnly) {
                    newBuf = newBuf.asReadOnlyBuffer();
                }
                this.buffers[buffersPos] = newBuf;
            }
            finally {
                this.growLock.unlock();
            }
        }

        protected abstract ByteBuffer makeNewBuffer(long var1);

        protected final ByteBuffer internalByteBuffer(long offset) {
            int pos = (int)(offset / 0x40000000L);
            if (pos >= this.buffers.length) {
                throw new IOError(new EOFException("offset: " + offset));
            }
            return this.buffers[pos];
        }

        @Override
        public final void putLong(long offset, long value) {
            this.internalByteBuffer(offset).putLong((int)(offset % 0x40000000L), value);
        }

        @Override
        public final void putInt(long offset, int value) {
            this.internalByteBuffer(offset).putInt((int)(offset % 0x40000000L), value);
        }

        @Override
        public final void putByte(long offset, byte value) {
            this.internalByteBuffer(offset).put((int)(offset % 0x40000000L), value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void putData(long offset, byte[] value, int size) {
            ByteBuffer b1 = this.internalByteBuffer(offset);
            int bufPos = (int)(offset % 0x40000000L);
            ByteBuffer byteBuffer = b1;
            synchronized (byteBuffer) {
                b1.position(bufPos);
                b1.put(value, 0, size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void putData(long offset, ByteBuffer buf) {
            ByteBuffer b1 = this.internalByteBuffer(offset);
            int bufPos = (int)(offset % 0x40000000L);
            ByteBuffer byteBuffer = b1;
            synchronized (byteBuffer) {
                b1.position(bufPos);
                b1.put(buf);
            }
        }

        @Override
        public final long getLong(long offset) {
            try {
                return this.internalByteBuffer(offset).getLong((int)(offset % 0x40000000L));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOError(new EOFException());
            }
        }

        @Override
        public final int getInt(long offset) {
            try {
                return this.internalByteBuffer(offset).getInt((int)(offset % 0x40000000L));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOError(new EOFException());
            }
        }

        @Override
        public final byte getByte(long offset) {
            try {
                return this.internalByteBuffer(offset).get((int)(offset % 0x40000000L));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOError(new EOFException());
            }
        }

        @Override
        public final DataInput2 getDataInput(long offset, int size) {
            ByteBuffer b1 = this.internalByteBuffer(offset);
            int bufPos = (int)(offset % 0x40000000L);
            return new DataInput2(b1, bufPos);
        }

        @Override
        public boolean isEmpty() {
            return this.buffers[0] == null || this.buffers[0].capacity() == 0;
        }

        @Override
        public boolean isSliced() {
            return true;
        }

        protected void unmap(MappedByteBuffer b) {
            try {
                Method cleanerMethod;
                if (unmapHackSupported && (cleanerMethod = b.getClass().getMethod("cleaner", new Class[0])) != null) {
                    cleanerMethod.setAccessible(true);
                    Object cleaner = cleanerMethod.invoke((Object)b, new Object[0]);
                    if (cleaner != null) {
                        Method clearMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                        if (cleanerMethod != null) {
                            clearMethod.invoke(cleaner, new Object[0]);
                        }
                    }
                }
            }
            catch (Exception e) {
                unmapHackSupported = false;
                Utils.LOG.log(Level.WARNING, "ByteBufferVol Unmap failed", e);
            }
        }

        static {
            try {
                unmapHackSupported = Class.forName("sun.nio.ch.DirectBuffer") != null;
            }
            catch (Exception e) {
                unmapHackSupported = false;
            }
        }
    }

    public static interface Factory {
        public Volume createIndexVolume();

        public Volume createPhysVolume();

        public Volume createTransLogVolume();
    }
}

