/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;

public final class Utils {
    static final Logger LOG = Logger.getLogger("JDBM");
    public static final Comparator<Comparable> COMPARABLE_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    public static final Comparator<Comparable> COMPARABLE_COMPARATOR_WITH_NULLS = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1 == null && o2 != null ? -1 : (o1 != null && o2 == null ? 1 : o1.compareTo(o2));
        }
    };
    public static final String EMPTY_STRING = "";
    public static final String UTF8 = "UTF8";
    public static Random RANDOM = new Random();
    private static boolean collectionAsMapValueLogged = false;

    public static void packLong(DataOutput out, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value: keys=" + value);
        }
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write((byte)value);
    }

    public static long unpackLong(DataInput in) throws IOException {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = in.readUnsignedByte();
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed long.");
    }

    public static void packInt(DataOutput in, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("negative value: keys=" + value);
        }
        while ((value & 0xFFFFFF80) != 0) {
            in.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        in.write((byte)value);
    }

    public static int unpackInt(DataInput is) throws IOException {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            int b = is.readUnsignedByte();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new Error("Malformed int.");
    }

    public static int longHash(long key) {
        int h = (int)(key ^ key >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static <E> E clone(E value, Serializer<E> serializer) {
        try {
            DataOutput2 out = new DataOutput2();
            serializer.serialize(out, value);
            DataInput2 in = new DataInput2(ByteBuffer.wrap(out.copyBytes()), 0);
            return serializer.deserialize(in, out.pos);
        }
        catch (IOException ee) {
            throw new IOError(ee);
        }
    }

    public static Object[] arrayPut(Object[] array, int pos, Object value) {
        Object[] ret = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret, pos + 1, array.length - pos);
        }
        ret[pos] = value;
        return ret;
    }

    public static long[] arrayLongPut(long[] array, int pos, long value) {
        long[] ret = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret, pos + 1, array.length - pos);
        }
        ret[pos] = value;
        return ret;
    }

    public static int nextPowTwo(int value) {
        int ret;
        for (ret = 2; ret < value; ret <<= 1) {
        }
        return ret;
    }

    public static File tempDbFile() {
        try {
            File index = File.createTempFile("mapdb", "db");
            index.deleteOnExit();
            new File(index.getPath() + ".p").deleteOnExit();
            new File(index.getPath() + ".t").deleteOnExit();
            return index;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isAndroid() {
        return "Dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"));
    }

    public static boolean JVMSupportsLargeMappedFiles() {
        String prop = System.getProperty("os.arch");
        return prop != null && prop.contains("64");
    }

    public static void checkMapValueIsNotCollecion(Object value) {
        if (collectionAsMapValueLogged) {
            return;
        }
        if (value instanceof Collection || value instanceof Map) {
            collectionAsMapValueLogged = true;
            LOG.warning("You should not use collections as Map values. MapDB requires key/values to be immutable! Checkout MultiMap example for 1:N mapping.");
        }
    }

    public static void printer(final AtomicLong value) {
        new Thread("printer"){
            {
                super(x0);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                long startValue = value.get();
                long startTime = System.currentTimeMillis();
                long old = value.get();
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    long current = value.get();
                    long totalSpeed = 1000L * (current - startValue) / (System.currentTimeMillis() - startTime);
                    System.out.print("total: " + current + " - items per last second: " + (current - old) + " - avg items per second: " + totalSpeed + "\r");
                    old = current;
                }
            }
        }.start();
    }
}

