/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.StorageDirect;
import org.mapdb.Volume;

public class StorageJournaled
extends StorageDirect
implements Engine {
    protected static final long WRITE_INDEX_LONG = 0x1000000000000L;
    protected static final long WRITE_INDEX_LONG_ZERO = 0x2000000000000L;
    protected static final long WRITE_PHYS_LONG = 0x3000000000000L;
    protected static final long WRITE_PHYS_ARRAY = 0x4000000000000L;
    protected static final long WRITE_SKIP_BUFFER = 124974889659531264L;
    protected static final long WRITE_SEAL = 0x6F000000000000L;
    protected static final long LOG_SEAL = 4566556446554645L;
    public static final String TRANS_LOG_FILE_EXT = ".t";
    protected Volume transLog;
    protected final Volume.Factory volFac;
    protected long transLogOffset;
    protected long indexSize;
    protected long physSize;
    protected final LongMap<long[]> recordLogRefs = new LongHashMap<long[]>();
    protected final LongMap<Long> recordIndexVals = new LongHashMap<Long>();
    protected final LongMap<long[]> longStackPages = new LongHashMap<long[]>();
    protected final LongMap<ArrayList<Long>> transLinkedPhysRecods = new LongHashMap<ArrayList<Long>>();

    public StorageJournaled(Volume.Factory volFac) {
        this(volFac, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageJournaled(Volume.Factory volFac, boolean appendOnly, boolean deleteFilesOnExit, boolean failOnWrongHeader, boolean readOnly) {
        super(volFac, appendOnly, deleteFilesOnExit, failOnWrongHeader, readOnly);
        this.lock.writeLock().lock();
        try {
            this.volFac = volFac;
            this.transLog = volFac.createTransLogVolume();
            this.reloadIndexFile();
            this.replayLogFile();
            this.transLog = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void reloadIndexFile() {
        this.transLogOffset = 0L;
        this.writeLock_checkLocked();
        this.recordLogRefs.clear();
        this.recordIndexVals.clear();
        this.longStackPages.clear();
        this.transLinkedPhysRecods.clear();
        this.indexSize = this.index.getLong(16L);
        this.physSize = this.index.getLong(8L);
        this.writeLock_checkLocked();
    }

    protected void openLogIfNeeded() {
        if (this.transLog != null) {
            return;
        }
        this.transLog = this.volFac.createTransLogVolume();
        this.transLog.ensureAvailable(16L);
        this.transLog.putLong(0L, 5646556656456456L);
        this.transLog.putLong(8L, 0L);
        this.transLogOffset = 16L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        if (value == null || serializer == null) {
            throw new NullPointerException();
        }
        DataOutput2 out = new DataOutput2();
        serializer.serialize(out, value);
        try {
            this.lock.writeLock().lock();
            long recid = this.longStackTake(3L);
            if (recid == 0L) {
                if (this.indexSize % 8L != 0L) {
                    throw new InternalError();
                }
                recid = this.indexSize / 8L;
                this.indexSize += 8L;
            }
            if (out.pos < 65535) {
                long indexValue = out.pos != 0 ? this.freePhysRecTake(out.pos) : 0L;
                this.writeIndexValToTransLog(recid, indexValue);
                this.writeOutToTransLog(out, recid, indexValue);
                this.checkBufferRounding();
            } else {
                this.putLargeLinkedRecord(out, recid);
            }
            long l = recid - 2555L;
            this.lock.writeLock().unlock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.lock.writeLock().unlock();
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private void putLargeLinkedRecord(DataOutput2 out, long recid) throws IOException {
        this.openLogIfNeeded();
        int chunkSize = 65527;
        int lastArrayPos = out.pos;
        long lastChunkPhysId = 0L;
        ArrayList<Long> journalRefs = new ArrayList<Long>();
        ArrayList<Long> physRecords = new ArrayList<Long>();
        for (int arrayPos = out.pos - out.pos % 65527; arrayPos >= 0; arrayPos -= 65527) {
            int currentChunkSize = lastArrayPos - arrayPos;
            byte[] b = new byte[currentChunkSize + 8];
            ByteBuffer.wrap(b).putLong(0, lastChunkPhysId);
            System.arraycopy(out.buf, arrayPos, b, 8, currentChunkSize);
            lastChunkPhysId = this.freePhysRecTake(currentChunkSize + 8);
            physRecords.add(lastChunkPhysId);
            this.transLog.ensureAvailable(this.transLogOffset + 10L + (long)currentChunkSize + 8L);
            this.transLog.putLong(this.transLogOffset, 0x4000000000000L | lastChunkPhysId & 0xFFFFFFFFFFFFL);
            this.transLogOffset += 8L;
            this.transLog.putUnsignedShort(this.transLogOffset, currentChunkSize + 8);
            this.transLogOffset += 2L;
            Long transLogReference = (long)currentChunkSize << 48 | this.transLogOffset + 8L;
            journalRefs.add(transLogReference);
            this.transLog.putData(this.transLogOffset, b, b.length);
            this.transLogOffset += (long)b.length;
            this.checkBufferRounding();
            lastArrayPos = arrayPos;
        }
        this.transLinkedPhysRecods.put(recid, physRecords);
        this.writeIndexValToTransLog(recid, lastChunkPhysId);
        long[] journalRefs2 = new long[journalRefs.size()];
        for (int i = 0; i < journalRefs2.length; ++i) {
            journalRefs2[i] = (Long)journalRefs.get(i);
        }
        this.recordLogRefs.put(recid, journalRefs2);
    }

    protected void checkBufferRounding() throws IOException {
        if (this.transLogOffset % 0x40000000L > 1073610754L) {
            this.transLog.ensureAvailable(this.transLogOffset + 8L);
            this.transLog.putLong(this.transLogOffset, 124974889659531264L);
            this.transLogOffset += 0x40000000L - this.transLogOffset % 0x40000000L;
        }
    }

    protected void writeIndexValToTransLog(long recid, long indexValue) throws IOException {
        this.openLogIfNeeded();
        this.transLog.ensureAvailable(this.transLogOffset + 16L);
        this.transLog.putLong(this.transLogOffset, 0x1000000000000L | recid * 8L);
        this.transLogOffset += 8L;
        this.transLog.putLong(this.transLogOffset, indexValue);
        this.transLogOffset += 8L;
        this.recordIndexVals.put(recid, indexValue);
    }

    protected void writeOutToTransLog(DataOutput2 out, long recid, long indexValue) throws IOException {
        this.openLogIfNeeded();
        this.transLog.ensureAvailable(this.transLogOffset + 10L + (long)out.pos);
        this.transLog.putLong(this.transLogOffset, 0x4000000000000L | indexValue & 0xFFFFFFFFFFFFL);
        this.transLogOffset += 8L;
        this.transLog.putUnsignedShort(this.transLogOffset, out.pos);
        this.transLogOffset += 2L;
        long transLogReference = (long)out.pos << 48 | this.transLogOffset;
        this.recordLogRefs.put(recid, new long[]{transLogReference});
        this.transLog.putData(this.transLogOffset, out.buf, out.pos);
        this.transLogOffset += (long)out.pos;
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (recid <= 0L) {
            throw new IllegalArgumentException("recid");
        }
        recid += 2555L;
        try {
            this.lock.readLock().lock();
            long[] indexVals = this.recordLogRefs.get(recid);
            if (indexVals != null) {
                if (indexVals.length == 1) {
                    if (indexVals[0] == Long.MIN_VALUE) {
                        A a = null;
                        return a;
                    }
                    A a = this.recordGet2(indexVals[0], this.transLog, serializer);
                    return a;
                }
                int size = 0;
                for (long physId : indexVals) {
                    size = (int)((long)size + (physId >>> 48));
                }
                byte[] b = new byte[size];
                int pos = 0;
                for (long physId : indexVals) {
                    int curChunkSize = (int)(physId >>> 48);
                    long offset = physId & 0xFFFFFFFFFFFFL;
                    DataInput2 in = this.transLog.getDataInput(offset, curChunkSize);
                    in.readFully(b, pos, curChunkSize);
                    pos += curChunkSize;
                }
                if (size != pos) {
                    throw new InternalError();
                }
                DataInput2 in = new DataInput2(b);
                A ret = serializer.deserialize(in, size);
                if (in.pos != size) {
                    throw new InternalError("Data were not fully read");
                }
                A a = ret;
                return a;
            }
            long indexValue = this.index.getLong(recid * 8L);
            A a = this.recordGet2(indexValue, this.phys, serializer);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        if (value == null || serializer == null) {
            throw new NullPointerException();
        }
        if (recid <= 0L) {
            throw new IllegalArgumentException("recid");
        }
        recid += 2555L;
        try {
            DataOutput2 out = new DataOutput2();
            serializer.serialize(out, value);
            try {
                this.lock.writeLock().lock();
                long oldIndexVal = this.getIndexLong(recid);
                long oldSize = oldIndexVal >>> 48;
                if (out.pos < 65535) {
                    if (oldSize != 0L || out.pos != 0) {
                        if (oldSize == (long)out.pos) {
                            this.writeOutToTransLog(out, recid, oldIndexVal);
                        } else if (oldSize != 0L && out.pos == 0) {
                            this.freePhysRecPut(oldIndexVal);
                            this.writeIndexValToTransLog(recid, 0L);
                        } else {
                            long newIndexValue = this.freePhysRecTake(out.pos);
                            this.writeOutToTransLog(out, recid, newIndexValue);
                            this.writeIndexValToTransLog(recid, newIndexValue);
                            this.unlinkPhysRecord(oldIndexVal, recid);
                        }
                    }
                } else {
                    this.unlinkPhysRecord(oldIndexVal, recid);
                    this.putLargeLinkedRecord(out, recid);
                }
                this.checkBufferRounding();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private long getIndexLong(long recid) {
        Long v = this.recordIndexVals.get(recid);
        return v != null ? v.longValue() : this.index.getLong(recid * 8L);
    }

    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (recid <= 0L) {
            throw new IllegalArgumentException("recid");
        }
        recid += 2555L;
        try {
            this.lock.writeLock().lock();
            this.openLogIfNeeded();
            this.transLog.ensureAvailable(this.transLogOffset + 8L);
            this.transLog.putLong(this.transLogOffset, 0x2000000000000L | recid * 8L);
            this.transLogOffset += 8L;
            this.longStackPut(3L, recid);
            this.recordLogRefs.put(recid, new long[]{Long.MIN_VALUE});
            long oldIndexVal = this.getIndexLong(recid);
            this.recordIndexVals.put(recid, 0L);
            this.unlinkPhysRecord(oldIndexVal, recid);
            this.checkBufferRounding();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.transLog != null) {
            this.transLog.sync();
            this.transLog.close();
            if (this.deleteFilesOnExit) {
                this.transLog.deleteFile();
            }
        }
        this.transLog = null;
    }

    @Override
    public void commit() {
        try {
            this.lock.writeLock().lock();
            LongMap.LongMapIterator<long[]> iter = this.longStackPages.longMapIterator();
            while (iter.moveToNext()) {
                this.transLog.ensureAvailable(this.transLogOffset + 8L + 2L + 808L);
                this.transLog.putLong(this.transLogOffset, 0x4000000000000L | iter.key());
                this.transLogOffset += 8L;
                this.transLog.putUnsignedShort(this.transLogOffset, 808);
                this.transLogOffset += 2L;
                for (long l : iter.value()) {
                    this.transLog.putLong(this.transLogOffset, l);
                    this.transLogOffset += 8L;
                }
                this.checkBufferRounding();
            }
            this.writeIndexValToTransLog(1L, this.physSize);
            this.writeIndexValToTransLog(2L, this.indexSize);
            this.transLog.ensureAvailable(this.transLogOffset + 8L);
            this.transLog.putLong(this.transLogOffset, 0x6F000000000000L);
            this.transLogOffset += 8L;
            this.transLog.sync();
            this.transLog.putLong(8L, 4566556446554645L);
            this.transLog.sync();
            this.replayLogFile();
            this.reloadIndexFile();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replayLogFile() {
        this.writeLock_checkLocked();
        this.transLogOffset = 0L;
        if (this.transLog != null) {
            this.transLog.sync();
        }
        if (this.transLog.isEmpty() || this.transLog.getLong(0L) != 5646556656456456L || this.transLog.getLong(8L) != 4566556446554645L) {
            this.transLog.close();
            this.transLog.deleteFile();
            this.transLog = null;
            return;
        }
        this.transLogOffset = 16L;
        long ins = this.transLog.getLong(this.transLogOffset);
        this.transLogOffset += 8L;
        while (ins != 0x6F000000000000L && ins != 0L) {
            long value;
            long offset;
            if ((ins -= (offset = ins & 0xFFFFFFFFFFFFL)) == 0x2000000000000L) {
                this.index.ensureAvailable(offset + 8L);
                this.index.putLong(offset, 0L);
            } else if (ins == 0x1000000000000L) {
                value = this.transLog.getLong(this.transLogOffset);
                this.transLogOffset += 8L;
                this.index.ensureAvailable(offset + 8L);
                this.index.putLong(offset, value);
            } else if (ins == 0x3000000000000L) {
                value = this.transLog.getLong(this.transLogOffset);
                this.transLogOffset += 8L;
                this.phys.ensureAvailable(offset + 8L);
                this.phys.putLong(offset, value);
            } else if (ins == 0x4000000000000L) {
                int size = this.transLog.getUnsignedShort(this.transLogOffset);
                this.transLogOffset += 2L;
                DataInput2 input = this.transLog.getDataInput(this.transLogOffset, size);
                ByteBuffer byteBuffer = input.buf;
                synchronized (byteBuffer) {
                    input.buf.position(input.pos);
                    input.buf.limit(input.pos + size);
                    this.phys.ensureAvailable(offset + (long)size);
                    this.phys.putData(offset, input.buf);
                    input.buf.clear();
                }
                this.transLogOffset += (long)size;
            } else if (ins == 124974889659531264L) {
                this.transLogOffset += 0x40000000L - this.transLogOffset % 0x40000000L;
            } else {
                throw new InternalError("unknown trans log instruction: " + (ins >>> 48));
            }
            ins = this.transLog.getLong(this.transLogOffset);
            this.transLogOffset += 8L;
        }
        this.transLogOffset = 0L;
        this.phys.sync();
        this.index.sync();
        this.transLog.putLong(0L, 0L);
        this.transLog.putLong(8L, 0L);
        this.transLog.close();
        this.transLog.deleteFile();
        this.transLog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.lock.writeLock().lock();
        try {
            if (this.transLog != null) {
                this.transLog.close();
                this.transLog.deleteFile();
                this.transLog = null;
            }
            this.reloadIndexFile();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        this.lock.writeLock().lock();
        try {
            if (this.transLog != null && !this.transLog.isEmpty()) {
                throw new IllegalAccessError("Journal not empty; commit first, than compact");
            }
            super.compact();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private long[] getLongStackPage(long physOffset, boolean read) {
        long[] buf = this.longStackPages.get(physOffset);
        if (buf == null) {
            buf = new long[101];
            if (read) {
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = this.phys.getLong(physOffset + (long)(i * 8));
                }
            }
            this.longStackPages.put(physOffset, buf);
        }
        return buf;
    }

    @Override
    protected long longStackTake(long listRecid) throws IOException {
        long dataOffset = this.getIndexLong(listRecid) & 0xFFFFFFFFFFFFL;
        if (dataOffset == 0L) {
            return 0L;
        }
        this.writeLock_checkLocked();
        long[] buf = this.getLongStackPage(dataOffset, true);
        int numberOfRecordsInPage = (int)(buf[0] >>> 56);
        if (numberOfRecordsInPage <= 0) {
            throw new InternalError();
        }
        if (numberOfRecordsInPage > 100) {
            throw new InternalError();
        }
        long ret = buf[numberOfRecordsInPage];
        long previousListPhysid = buf[0] & 0xFFFFFFFFFFFFL;
        if (numberOfRecordsInPage == 1) {
            long value = previousListPhysid != 0L ? previousListPhysid | 0x328000000000000L : 0L;
            this.writeIndexValToTransLog(listRecid, value);
            this.longStackPages.remove(dataOffset);
            this.freePhysRecPut(dataOffset | 0x328000000000000L);
        } else {
            buf[0] = previousListPhysid | 1L * (long)numberOfRecordsInPage - 1L << 56;
        }
        return ret;
    }

    @Override
    protected void longStackPut(long listRecid, long offset) throws IOException {
        this.writeLock_checkLocked();
        long listPhysid2 = this.getIndexLong(listRecid) & 0xFFFFFFFFFFFFL;
        if (listPhysid2 == 0L) {
            long listPhysid = this.freePhysRecTake(808) & 0xFFFFFFFFFFFFL;
            long[] buf = this.getLongStackPage(listPhysid, false);
            if (listPhysid == 0L) {
                throw new InternalError();
            }
            buf[0] = 0x100000000000000L;
            buf[1] = offset;
            this.writeIndexValToTransLog(listRecid, 0x328000000000000L | listPhysid);
        } else {
            long[] buf = this.getLongStackPage(listPhysid2, true);
            int numberOfRecordsInPage = (int)(buf[0] >>> 56);
            if (numberOfRecordsInPage == 100) {
                long listPhysid = this.freePhysRecTake(808) & 0xFFFFFFFFFFFFL;
                long[] bufNew = this.getLongStackPage(listPhysid, false);
                if (listPhysid == 0L) {
                    throw new InternalError();
                }
                bufNew[0] = listPhysid2 | 0x100000000000000L;
                bufNew[1] = offset;
                this.writeIndexValToTransLog(listRecid, 0x328000000000000L | listPhysid);
            } else {
                buf[1 + numberOfRecordsInPage] = offset;
                buf[0] = buf[0] & 0xFFFFFFFFFFFFL | 1L * (long)numberOfRecordsInPage + 1L << 56;
            }
        }
    }

    @Override
    protected long freePhysRecTake(int requiredSize) throws IOException {
        long freePhysRec;
        this.writeLock_checkLocked();
        if (requiredSize <= 0) {
            throw new InternalError();
        }
        long l = freePhysRec = this.appendOnly ? 0L : this.findFreePhysSlot(requiredSize);
        if (freePhysRec != 0L) {
            return freePhysRec;
        }
        long oldFileSize = this.physSize;
        if (oldFileSize <= 0L) {
            throw new InternalError("illegal file size:" + oldFileSize);
        }
        if (oldFileSize % 0x40000000L + (long)requiredSize <= 0x40000000L) {
            this.physSize += (long)requiredSize;
            return (long)requiredSize << 48 | oldFileSize;
        }
        long freeSizeToCreate = 0x40000000L - oldFileSize % 0x40000000L;
        if (freeSizeToCreate == 0L) {
            throw new InternalError();
        }
        long nextBufferStartOffset = oldFileSize + freeSizeToCreate;
        if (nextBufferStartOffset % 0x40000000L != 0L) {
            throw new InternalError();
        }
        this.physSize += freeSizeToCreate + (long)requiredSize;
        this.freePhysRecPut(freeSizeToCreate << 48 | oldFileSize);
        return (long)requiredSize << 48 | nextBufferStartOffset;
    }

    @Override
    protected void unlinkPhysRecord(long indexVal, long recid) throws IOException {
        if (indexVal == 0L) {
            return;
        }
        ArrayList<Long> linkedInTrans = this.transLinkedPhysRecods.remove(recid);
        if (linkedInTrans != null) {
            for (Long l : linkedInTrans) {
                this.freePhysRecPut(l);
            }
            return;
        }
        if (indexVal >>> 48 < 65535L) {
            this.freePhysRecPut(indexVal);
            return;
        }
        while (indexVal != 0L) {
            this.freePhysRecPut(indexVal);
            long offset = indexVal & 0xFFFFFFFFFFFFL;
            indexVal = this.phys.getLong(offset);
        }
    }
}

