/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.StorageJournaled;
import org.mapdb.Volume;

public class StorageDirect
implements Engine {
    static final long PHYS_OFFSET_MASK = 0xFFFFFFFFFFFFL;
    static final long HEADER = 5646556656456456L;
    static final int RECID_CURRENT_PHYS_FILE_SIZE = 1;
    static final int RECID_CURRENT_INDEX_FILE_SIZE = 2;
    static final int RECID_FREE_INDEX_SLOTS = 3;
    static final int RECID_FREE_PHYS_RECORDS_START = 20;
    static final int NUMBER_OF_PHYS_FREE_SLOT = 2535;
    static final int MAX_RECORD_SIZE = 65535;
    static final byte LONG_STACK_NUM_OF_RECORDS_PER_PAGE = 100;
    static final int LONG_STACK_PAGE_SIZE = 808;
    static final int INDEX_OFFSET_START = 2555;
    public static final String DATA_FILE_EXT = ".p";
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final boolean appendOnly;
    protected final boolean deleteFilesOnExit;
    protected final boolean failOnWrongHeader;
    protected final boolean readOnly;
    protected volatile Volume phys;
    protected volatile Volume index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageDirect(Volume.Factory volFac, boolean appendOnly, boolean deleteFilesOnExit, boolean failOnWrongHeader, boolean readOnly) {
        this.appendOnly = appendOnly;
        this.deleteFilesOnExit = deleteFilesOnExit;
        this.failOnWrongHeader = failOnWrongHeader;
        this.readOnly = readOnly;
        try {
            long header;
            this.lock.writeLock().lock();
            this.phys = volFac.createPhysVolume();
            this.index = volFac.createIndexVolume();
            this.phys.ensureAvailable(8L);
            this.index.ensureAvailable(20440L);
            long l = header = this.index.isEmpty() ? 0L : this.index.getLong(0L);
            if (header != 5646556656456456L) {
                if (failOnWrongHeader) {
                    throw new IOError(new IOException("Wrong file header"));
                }
                this.writeInitValues();
            }
            File indexFile = this.index.getFile();
            if (!(this instanceof StorageJournaled) && indexFile != null && new File(indexFile.getPath() + ".t").exists()) {
                throw new IllegalAccessError("Could not open DB in Direct Mode; WriteAhead log file exists, it may contain some data.");
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public StorageDirect(Volume.Factory volFac) {
        this(volFac, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        if (value == null || serializer == null) {
            throw new NullPointerException();
        }
        DataOutput2 out = new DataOutput2();
        serializer.serialize(out, value);
        try {
            this.lock.writeLock().lock();
            long recid = this.longStackTake(3L);
            if (recid == 0L) {
                long indexSize = this.index.getLong(16L);
                if (indexSize % 8L != 0L) {
                    throw new InternalError();
                }
                recid = indexSize / 8L;
                this.index.ensureAvailable(indexSize + 8L);
                this.index.putLong(16L, indexSize + 8L);
            }
            if (out.pos < 65535) {
                long indexValue = out.pos != 0 ? this.freePhysRecTake(out.pos) : 0L;
                this.phys.putData(indexValue & 0xFFFFFFFFFFFFL, out.buf, out.pos);
                this.index.putLong(recid * 8L, indexValue);
            } else {
                this.putLargeLinkedRecord(out, recid);
            }
            long l = recid - 2555L;
            this.lock.writeLock().unlock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.lock.writeLock().unlock();
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private void putLargeLinkedRecord(DataOutput2 out, long recid) throws IOException {
        int chunkSize = 65527;
        int lastArrayPos = out.pos;
        long lastChunkPhysId = 0L;
        for (int arrayPos = out.pos - out.pos % 65527; arrayPos >= 0; arrayPos -= 65527) {
            int currentChunkSize = lastArrayPos - arrayPos;
            byte[] b = new byte[currentChunkSize + 8];
            ByteBuffer.wrap(b).putLong(0, lastChunkPhysId);
            System.arraycopy(out.buf, arrayPos, b, 8, currentChunkSize);
            lastChunkPhysId = this.freePhysRecTake(currentChunkSize + 8);
            this.phys.putData(lastChunkPhysId & 0xFFFFFFFFFFFFL, b, b.length);
            lastArrayPos = arrayPos;
        }
        this.index.putLong(recid * 8L, lastChunkPhysId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (recid <= 0L) {
            throw new IllegalArgumentException("recid");
        }
        recid += 2555L;
        try {
            try {
                this.lock.readLock().lock();
                long indexValue = this.index.getLong(recid * 8L);
                A a = this.recordGet2(indexValue, this.phys, serializer);
                return a;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        if (value == null || serializer == null) {
            throw new NullPointerException();
        }
        if (recid <= 0L) {
            throw new IllegalArgumentException("recid");
        }
        recid += 2555L;
        try {
            DataOutput2 out = new DataOutput2();
            serializer.serialize(out, value);
            try {
                this.lock.writeLock().lock();
                long oldIndexVal = this.index.getLong(recid * 8L);
                long oldSize = oldIndexVal >>> 48;
                if (out.pos < 65535) {
                    if (oldSize == 0L && out.pos == 0) {
                    } else if (oldSize == (long)out.pos && oldSize != 65535L) {
                        this.phys.putData(oldIndexVal & 0xFFFFFFFFFFFFL, out.buf, out.pos);
                    } else if (oldSize != 0L && out.pos == 0) {
                        this.freePhysRecPut(oldIndexVal);
                        this.index.putLong(recid * 8L, 0L);
                    } else {
                        long newIndexValue = this.freePhysRecTake(out.pos);
                        this.phys.putData(newIndexValue & 0xFFFFFFFFFFFFL, out.buf, out.pos);
                        this.index.putLong(recid * 8L, newIndexValue);
                        this.unlinkPhysRecord(oldIndexVal, recid);
                    }
                } else {
                    this.putLargeLinkedRecord(out, recid);
                    this.unlinkPhysRecord(oldIndexVal, recid);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (recid <= 0L) {
            throw new IllegalArgumentException("recid");
        }
        recid += 2555L;
        try {
            this.lock.writeLock().lock();
            long oldIndexVal = this.index.getLong(recid * 8L);
            this.index.putLong(recid * 8L, 0L);
            this.longStackPut(3L, recid);
            this.unlinkPhysRecord(oldIndexVal, recid);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Can not rollback, transactions disabled.");
    }

    protected long longStackTake(long listRecid) throws IOException {
        long dataOffset = this.index.getLong(listRecid * 8L) & 0xFFFFFFFFFFFFL;
        if (dataOffset == 0L) {
            return 0L;
        }
        this.writeLock_checkLocked();
        int numberOfRecordsInPage = this.phys.getUnsignedByte(dataOffset);
        if (numberOfRecordsInPage <= 0) {
            throw new InternalError();
        }
        if (numberOfRecordsInPage > 100) {
            throw new InternalError();
        }
        long ret = this.phys.getLong(dataOffset + (long)(numberOfRecordsInPage * 8));
        if (numberOfRecordsInPage == 1) {
            long previousListPhysid = this.phys.getLong(dataOffset) & 0xFFFFFFFFFFFFL;
            if (previousListPhysid != 0L) {
                this.index.putLong(listRecid * 8L, previousListPhysid | 0x328000000000000L);
            } else {
                this.index.putLong(listRecid * 8L, 0L);
            }
            this.freePhysRecPut(dataOffset | 0x328000000000000L);
        } else {
            this.phys.putUnsignedByte(dataOffset, (byte)(numberOfRecordsInPage - 1));
        }
        return ret;
    }

    protected void longStackPut(long listRecid, long offset) throws IOException {
        this.writeLock_checkLocked();
        long listPhysid2 = this.index.getLong(listRecid * 8L) & 0xFFFFFFFFFFFFL;
        if (listPhysid2 == 0L) {
            long listPhysid = this.freePhysRecTake(808) & 0xFFFFFFFFFFFFL;
            if (listPhysid == 0L) {
                throw new InternalError();
            }
            this.phys.putLong(listPhysid, 0L);
            this.phys.putUnsignedByte(listPhysid, 1);
            this.phys.putLong(listPhysid + 8L, offset);
            this.index.putLong(listRecid * 8L, 0x328000000000000L | listPhysid);
        } else {
            int numberOfRecordsInPage = this.phys.getUnsignedByte(listPhysid2);
            if (numberOfRecordsInPage == 100) {
                long listPhysid = this.freePhysRecTake(808) & 0xFFFFFFFFFFFFL;
                if (listPhysid == 0L) {
                    throw new InternalError();
                }
                this.phys.putLong(listPhysid, listPhysid2);
                this.phys.putUnsignedByte(listPhysid, 1);
                this.phys.putLong(listPhysid + 8L, offset);
                this.index.putLong(listRecid * 8L, 0x328000000000000L | listPhysid);
            } else {
                this.phys.putLong(listPhysid2 + 8L + (long)(8 * numberOfRecordsInPage), offset);
                this.phys.putUnsignedByte(listPhysid2, (byte)(numberOfRecordsInPage + 1));
            }
        }
    }

    protected long freePhysRecTake(int requiredSize) throws IOException {
        long freePhysRec;
        this.writeLock_checkLocked();
        if (requiredSize <= 0) {
            throw new InternalError();
        }
        long l = freePhysRec = this.appendOnly || Thread.currentThread().getStackTrace().length > 256 ? 0L : this.findFreePhysSlot(requiredSize);
        if (freePhysRec != 0L) {
            return freePhysRec;
        }
        long physFileSize = this.index.getLong(8L);
        if (physFileSize <= 0L) {
            throw new InternalError("illegal file size:" + physFileSize);
        }
        if (physFileSize % 0x40000000L + (long)requiredSize <= 0x40000000L) {
            this.phys.ensureAvailable(physFileSize + (long)requiredSize);
            this.index.putLong(8L, physFileSize + (long)requiredSize);
            return (long)requiredSize << 48 | physFileSize;
        }
        long freeSizeToCreate = 0x40000000L - physFileSize % 0x40000000L;
        if (freeSizeToCreate == 0L) {
            throw new InternalError();
        }
        long nextBufferStartOffset = physFileSize + freeSizeToCreate;
        if (nextBufferStartOffset % 0x40000000L != 0L) {
            throw new InternalError();
        }
        this.phys.ensureAvailable(physFileSize + freeSizeToCreate + (long)requiredSize);
        this.index.putLong(8L, physFileSize + freeSizeToCreate + (long)requiredSize);
        this.freePhysRecPut(freeSizeToCreate << 48 | physFileSize);
        return (long)requiredSize << 48 | nextBufferStartOffset;
    }

    private void writeInitValues() {
        this.writeLock_checkLocked();
        int i = 1;
        while ((long)i <= 2562L) {
            this.index.putLong(i * 8, 0L);
            ++i;
        }
        this.phys.putLong(0L, 5646556656456456L);
        this.index.putLong(0L, 5646556656456456L);
        if (this.index.getLong(0L) != 5646556656456456L) {
            throw new InternalError();
        }
        this.index.putLong(8L, 8L);
        this.index.putLong(16L, 20504L);
    }

    protected void writeLock_checkLocked() {
        if (!this.lock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalAccessError("no write lock");
        }
    }

    final int freePhysRecSize2FreeSlot(int size) {
        if (size > 65535) {
            throw new IllegalArgumentException("too big record");
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size");
        }
        if (size < 1535) {
            return size - 1;
        }
        if (size == 65535) {
            return 2534;
        }
        return 1534 + (size - 1535) / 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.lock.writeLock().lock();
            this.phys.close();
            this.index.close();
            if (this.deleteFilesOnExit) {
                this.phys.deleteFile();
                this.index.deleteFile();
            }
            this.phys = null;
            this.index = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.index == null;
    }

    protected <A> A recordGet2(long indexValue, Volume data, Serializer<A> serializer) throws IOException {
        long dataPos = indexValue & 0xFFFFFFFFFFFFL;
        int dataSize = (int)(indexValue >>> 48);
        if (dataPos == 0L) {
            return serializer.deserialize(new DataInput2(new byte[0]), 0);
        }
        if (dataSize < 65535) {
            DataInput2 in = data.getDataInput(dataPos, dataSize);
            A value = serializer.deserialize(in, dataSize);
            if ((long)in.pos != (long)dataSize + (data.isSliced() ? dataPos % 0x40000000L : 0L)) {
                throw new InternalError("Data were not fully read.");
            }
            return value;
        }
        ArrayList<DataInput2> ins = new ArrayList<DataInput2>();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        int recSize = 0;
        long nextLink = indexValue;
        while (nextLink != 0L) {
            int currentSize = (int)(nextLink >>> 48);
            recSize += currentSize - 8;
            DataInput2 in = data.getDataInput(nextLink & 0xFFFFFFFFFFFFL, currentSize);
            nextLink = in.readLong();
            ins.add(in);
            sizes.add(currentSize - 8);
        }
        byte[] b = new byte[recSize];
        int pos = 0;
        for (int i = 0; i < ins.size(); ++i) {
            DataInput2 in = ins.set(i, null);
            int size = (Integer)sizes.get(i);
            in.readFully(b, pos, size);
            pos += size;
        }
        DataInput2 in = new DataInput2(b);
        A value = serializer.deserialize(in, recSize);
        if (in.pos != recSize) {
            throw new InternalError("Data were not fully read.");
        }
        return value;
    }

    protected void freePhysRecPut(long indexValue) throws IOException {
        if ((indexValue & 0xFFFFFFFFFFFFL) == 0L) {
            throw new InternalError("zero indexValue: ");
        }
        int size = (int)(indexValue >>> 48);
        long listRecid = 20 + this.freePhysRecSize2FreeSlot(size);
        this.longStackPut(listRecid, indexValue);
    }

    protected long findFreePhysSlot(int requiredSize) throws IOException {
        int slot = this.freePhysRecSize2FreeSlot(requiredSize);
        if (requiredSize > 1 && slot == this.freePhysRecSize2FreeSlot(requiredSize - 1)) {
            ++slot;
        }
        while (slot < 2535) {
            long v = this.longStackTake(20 + slot);
            if (v != 0L) {
                int foundRecSize = (int)(v >>> 48);
                if (foundRecSize != requiredSize) {
                    long newIndexValue = (long)(foundRecSize - requiredSize) << 48 | (v & 0xFFFFFFFFFFFFL) + (long)requiredSize;
                    this.freePhysRecPut(newIndexValue);
                }
                return v & 0xFFFFFFFFFFFFL | (long)requiredSize << 48;
            }
            ++slot;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        if (expectedOldValue == null || newValue == null || serializer == null) {
            throw new NullPointerException();
        }
        if (recid <= 0L) {
            throw new IllegalArgumentException("recid");
        }
        try {
            this.lock.writeLock().lock();
            A oldVal = this.get(recid, serializer);
            if (oldVal == null && expectedOldValue == null || oldVal != null && oldVal.equals(expectedOldValue)) {
                this.update(recid, newValue, serializer);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void unlinkPhysRecord(long indexVal, long recid) throws IOException {
        int size = (int)(indexVal >>> 48);
        if (size == 0) {
            return;
        }
        if (size < 65535) {
            this.freePhysRecPut(indexVal);
        } else {
            while (indexVal != 0L) {
                long nextIndexVal = this.phys.getLong(indexVal & 0xFFFFFFFFFFFFL);
                this.freePhysRecPut(indexVal);
                indexVal = nextIndexVal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        if (this.readOnly) {
            throw new IllegalAccessError();
        }
        if (this.index.getFile() == null) {
            throw new UnsupportedOperationException("compact not supported for memory storage yet");
        }
        this.lock.writeLock().lock();
        try {
            File indexFile = this.index.getFile();
            File physFile = this.phys.getFile();
            boolean isRaf = this.index instanceof Volume.RandomAccessFileVol;
            Volume.Factory fab = Volume.fileFactory(false, isRaf, new File(indexFile + ".compact"));
            StorageDirect store2 = new StorageDirect(fab);
            long recid = this.longStackTake(3L);
            while (recid != 0L) {
                store2.longStackPut(recid, 3L);
                recid = this.longStackTake(3L);
            }
            long indexSize = this.index.getLong(16L) / 8L;
            store2.lock.writeLock().lock();
            for (long recid2 = 2555L; recid2 < indexSize; ++recid2) {
                long physOffset = this.index.getLong(recid2 * 8L);
                long physSize = physOffset >>> 48;
                physOffset &= 0xFFFFFFFFFFFFL;
                store2.index.ensureAvailable(recid2 * 8L + 8L);
                if (physSize != 0L) {
                    DataInput2 in = this.phys.getDataInput(physOffset, (int)physSize);
                    long physOffset2 = store2.freePhysRecTake((int)physSize) & 0xFFFFFFFFFFFFL;
                    store2.phys.ensureAvailable((physOffset2 & 0xFFFFFFFFFFFFL) + physSize);
                    ByteBuffer byteBuffer = in.buf;
                    synchronized (byteBuffer) {
                        in.buf.limit((int)((long)in.pos + physSize));
                        in.buf.position(in.pos);
                        store2.phys.putData(physOffset2, in.buf);
                    }
                    store2.index.putLong(recid2 * 8L, physSize << 48 | physOffset2);
                    continue;
                }
                store2.index.putLong(recid2 * 8L, 0L);
            }
            store2.index.putLong(16L, indexSize * 8L);
            File indexFile2 = store2.index.getFile();
            File physFile2 = store2.phys.getFile();
            store2.lock.writeLock().unlock();
            store2.close();
            long time = System.currentTimeMillis();
            File indexFile_ = new File(indexFile.getPath() + "_" + time + "_orig");
            File physFile_ = new File(physFile.getPath() + "_" + time + "_orig");
            this.index.close();
            this.phys.close();
            if (!indexFile.renameTo(indexFile_)) {
                throw new InternalError();
            }
            if (!physFile.renameTo(physFile_)) {
                throw new InternalError();
            }
            if (!indexFile2.renameTo(indexFile)) {
                throw new InternalError();
            }
            if (!physFile2.renameTo(physFile)) {
                throw new InternalError();
            }
            indexFile_.delete();
            physFile_.delete();
            Volume.Factory fac2 = Volume.fileFactory(false, isRaf, indexFile);
            this.index = fac2.createIndexVolume();
            this.phys = fac2.createPhysVolume();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

