/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.Volume;

public class StorageAppend
implements Engine {
    protected final File file;
    protected final boolean useRandomAccessFile;
    protected final boolean readOnly;
    protected static final long FILE_NUMBER_SHIFT = 28L;
    protected static final long FILE_OFFSET_MASK = 0xFFFFFFFL;
    protected static final long FILE_HEADER = 56465465456465L;
    protected final ReentrantReadWriteLock appendLock = new ReentrantReadWriteLock();
    protected static final Long THUMBSTONE = Long.MIN_VALUE;
    protected static final int THUMBSTONE_SIZE = -3;
    protected static final long EOF = -1L;
    protected static final long COMMIT = -2L;
    protected static final long ROLLBACK = -2L;
    protected Volume currentVolume;
    protected long currentVolumeNum;
    protected int currentFileOffset;
    protected long maxRecid = 10L;
    protected LongConcurrentHashMap<Volume> volumes = new LongConcurrentHashMap();
    protected final LongConcurrentHashMap<Long> recidsInTx = new LongConcurrentHashMap();
    protected final Volume recidsTable = new Volume.MemoryVol(true);
    protected static final int MAX_FILE_SIZE = 0xA00000;

    public StorageAppend(File file, boolean useRandomAccessFile, boolean readOnly, boolean transactionsDisabled) {
        this.file = file;
        this.useRandomAccessFile = useRandomAccessFile;
        this.readOnly = readOnly;
        File zeroFile = this.getFileNum(0L);
        if (zeroFile.exists()) {
            this.replayLog();
        } else {
            this.currentVolume = Volume.volumeForFile(zeroFile, useRandomAccessFile, readOnly);
            this.currentVolume.ensureAvailable(8L);
            this.currentVolume.putLong(0L, 56465465456465L);
            this.currentFileOffset = 8;
            this.volumes.put(0L, this.currentVolume);
        }
    }

    protected void replayLog() {
        try {
            long fileNum = 0L;
            while (true) {
                File f;
                if (!(f = this.getFileNum(fileNum)).exists()) {
                    return;
                }
                this.currentVolume = Volume.volumeForFile(f, this.useRandomAccessFile, this.readOnly);
                this.volumes.put(fileNum, this.currentVolume);
                this.currentVolumeNum = fileNum;
                LongHashMap<Long> recidsTable2 = new LongHashMap<Long>();
                if (!this.currentVolume.isEmpty()) {
                    int pos = 0;
                    long header = this.currentVolume.getLong(pos);
                    pos += 8;
                    if (header != 56465465456465L) {
                        throw new InternalError();
                    }
                    while (true) {
                        long recid = this.currentVolume.getLong(pos);
                        pos += 8;
                        this.maxRecid = Math.max(recid, this.maxRecid);
                        if (recid == -1L || recid == 0L) break;
                        if (recid == -2L) {
                            this.commitRecids(recidsTable2);
                            continue;
                        }
                        if (recid == -2L) {
                            recidsTable2.clear();
                            continue;
                        }
                        long filePos = fileNum << 28 | (long)pos;
                        int size = this.currentVolume.getInt(pos);
                        pos += 4;
                        if (size != -3) {
                            pos += size;
                            recidsTable2.put(recid, filePos);
                            continue;
                        }
                        recidsTable2.put(recid, THUMBSTONE);
                    }
                }
                ++fileNum;
            }
        }
        catch (IOError iOError) {
            return;
        }
    }

    protected File getFileNum(long fileNum) {
        return new File(this.file.getPath() + "." + fileNum);
    }

    protected void commitRecids(LongMap<Long> recidsTable2) {
        LongMap.LongMapIterator<Long> iter = recidsTable2.longMapIterator();
        while (iter.moveToNext()) {
            long recidsTableOffset = iter.key() * 8L;
            this.recidsTable.ensureAvailable(recidsTableOffset + 8L);
            this.recidsTable.putLong(recidsTableOffset, iter.value());
        }
        recidsTable2.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        DataOutput2 out = new DataOutput2();
        serializer.serialize(out, value);
        this.appendLock.writeLock().lock();
        try {
            long newRecid = this.maxRecid++;
            this.update2(newRecid, out);
            this.rollOverFile();
            long l = newRecid;
            this.appendLock.writeLock().unlock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.appendLock.writeLock().unlock();
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    protected void update2(long recid, DataOutput2 out) {
        this.currentVolume.ensureAvailable(this.currentFileOffset + 8 + 4 + out.pos);
        this.currentVolume.putLong(this.currentFileOffset, recid);
        this.currentFileOffset += 8;
        long filePos = this.currentVolumeNum << 28 | (long)this.currentFileOffset;
        this.currentVolume.putInt(this.currentFileOffset, out.pos);
        this.currentFileOffset += 4;
        this.currentVolume.putData(this.currentFileOffset, out.buf, out.pos);
        this.currentFileOffset += out.pos;
        this.recidsInTx.put(recid, filePos);
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        this.appendLock.readLock().lock();
        try {
            Long fileNum2 = this.recidsInTx.get(recid);
            if (fileNum2 == null) {
                fileNum2 = this.recidsTable.getLong(recid * 8L);
            }
            if (fileNum2 == THUMBSTONE) {
                A a = null;
                return a;
            }
            if (fileNum2 == 0L) {
                A a = serializer.deserialize(new DataInput2(new byte[0]), 0);
                return a;
            }
            long fileNum = fileNum2;
            long fileOffset = fileNum & 0xFFFFFFFL;
            if (fileOffset > 0xA00000L) {
                throw new InternalError();
            }
            Volume v = this.volumes.get(fileNum >>>= 28);
            int size = v.getInt(fileOffset);
            DataInput2 input = v.getDataInput(fileOffset + 4L, size);
            A a = serializer.deserialize(input, size);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.appendLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        try {
            DataOutput2 out = new DataOutput2();
            serializer.serialize(out, value);
            this.appendLock.writeLock().lock();
            try {
                this.update2(recid, out);
                this.rollOverFile();
            }
            finally {
                this.appendLock.writeLock().unlock();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        this.appendLock.writeLock().lock();
        try {
            A oldVal = this.get(recid, serializer);
            if (oldVal == null && expectedOldValue == null || oldVal != null && oldVal.equals(expectedOldValue)) {
                DataOutput2 out = new DataOutput2();
                try {
                    serializer.serialize(out, newValue);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
                this.update2(recid, out);
                this.rollOverFile();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.appendLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.appendLock.writeLock().lock();
        try {
            this.currentVolume.ensureAvailable(this.currentFileOffset + 8 + 4);
            this.currentVolume.putLong(this.currentFileOffset, recid);
            this.currentFileOffset += 8;
            this.currentVolume.putInt(this.currentFileOffset, -3);
            this.currentFileOffset += 4;
            this.recidsInTx.put(recid, THUMBSTONE);
            this.rollOverFile();
        }
        finally {
            this.appendLock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
        this.currentVolume = null;
        this.volumes = null;
    }

    @Override
    public boolean isClosed() {
        return this.volumes == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.appendLock.writeLock().lock();
        try {
            this.commitRecids(this.recidsInTx);
            this.currentVolume.ensureAvailable(this.currentFileOffset + 8);
            this.currentVolume.putLong(this.currentFileOffset, -2L);
            this.currentFileOffset += 8;
            this.currentVolume.sync();
            this.rollOverFile();
        }
        finally {
            this.appendLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        this.appendLock.writeLock().lock();
        try {
            this.currentVolume.ensureAvailable(this.currentFileOffset + 8);
            this.currentVolume.putLong(this.currentFileOffset, -2L);
            this.currentFileOffset += 8;
            this.currentVolume.sync();
            this.recidsInTx.clear();
            this.rollOverFile();
        }
        finally {
            this.appendLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void compact() {
    }

    protected void rollOverFile() {
        if (this.currentFileOffset < 0x9FFFF8) {
            return;
        }
        this.currentVolume.ensureAvailable(this.currentFileOffset + 8);
        this.currentVolume.putLong(this.currentFileOffset, -1L);
        this.currentVolume.sync();
        ++this.currentVolumeNum;
        this.currentVolume = Volume.volumeForFile(this.getFileNum(this.currentVolumeNum), this.useRandomAccessFile, this.readOnly);
        this.currentVolume.ensureAvailable(0xA00000L);
        this.currentVolume.putLong(0L, 56465465456465L);
        this.currentFileOffset = 8;
        this.currentVolume.sync();
        this.volumes.put(this.currentVolumeNum, this.currentVolume);
    }
}

