/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.CompressLZF;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public class SerializerBase
implements Serializer {
    static final Set knownSerializable = new HashSet<Object>(Arrays.asList(BTreeKeySerializer.STRING, BTreeKeySerializer.ZERO_OR_POSITIVE_LONG, BTreeKeySerializer.ZERO_OR_POSITIVE_INT, Utils.COMPARABLE_COMPARATOR, Utils.COMPARABLE_COMPARATOR_WITH_NULLS, Serializer.STRING_SERIALIZER, Serializer.LONG_SERIALIZER, Serializer.INTEGER_SERIALIZER, Serializer.EMPTY_SERIALIZER, Serializer.BASIC_SERIALIZER, Serializer.CRC32_CHECKSUM));

    public static void assertSerializable(Object o) {
        if (o != null && !(o instanceof Serializable) && !knownSerializable.contains(o)) {
            throw new IllegalArgumentException("Not serializable: " + o.getClass());
        }
    }

    public void serialize(DataOutput out, Object obj) throws IOException {
        this.serialize(out, obj, null);
    }

    public void serialize(DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        Class<?> clazz;
        if (objectStack != null) {
            int indexInObjectStack = objectStack.identityIndexOf(obj);
            if (indexInObjectStack != -1) {
                out.write(166);
                Utils.packInt(out, indexInObjectStack);
                return;
            }
            objectStack.add(obj);
        }
        Class<?> clazz2 = clazz = obj != null ? obj.getClass() : null;
        if (obj == null) {
            out.write(0);
            return;
        }
        if (clazz == Boolean.class) {
            if (((Boolean)obj).booleanValue()) {
                out.write(2);
            } else {
                out.write(3);
            }
            return;
        }
        if (clazz == Integer.class) {
            int val = (Integer)obj;
            this.writeInteger(out, val);
            return;
        }
        if (clazz == Double.class) {
            double v = (Double)obj;
            if (v == -1.0) {
                out.write(47);
            } else if (v == 0.0) {
                out.write(48);
            } else if (v == 1.0) {
                out.write(49);
            } else if (v >= 0.0 && v <= 255.0 && (double)((int)v) == v) {
                out.write(50);
                out.write((int)v);
            } else if (v >= -32768.0 && v <= 32767.0 && (double)((short)v) == v) {
                out.write(51);
                out.writeShort((int)v);
            } else {
                out.write(52);
                out.writeDouble(v);
            }
            return;
        }
        if (clazz == Float.class) {
            float v = ((Float)obj).floatValue();
            if (v == -1.0f) {
                out.write(41);
            } else if (v == 0.0f) {
                out.write(42);
            } else if (v == 1.0f) {
                out.write(43);
            } else if (v >= 0.0f && v <= 255.0f && (float)((int)v) == v) {
                out.write(44);
                out.write((int)v);
            } else if (v >= -32768.0f && v <= 32767.0f && (float)((short)v) == v) {
                out.write(45);
                out.writeShort((int)v);
            } else {
                out.write(46);
                out.writeFloat(v);
            }
            return;
        }
        if (clazz == BigInteger.class) {
            out.write(55);
            byte[] buf = ((BigInteger)obj).toByteArray();
            Utils.packInt(out, buf.length);
            out.write(buf);
            return;
        }
        if (clazz == BigDecimal.class) {
            out.write(54);
            BigDecimal d = (BigDecimal)obj;
            byte[] buf = d.unscaledValue().toByteArray();
            Utils.packInt(out, buf.length);
            out.write(buf);
            Utils.packInt(out, d.scale());
            return;
        }
        if (clazz == Long.class) {
            long val = (Long)obj;
            this.writeLong(out, val);
            return;
        }
        if (clazz == Short.class) {
            short val = (Short)obj;
            if (val == -1) {
                out.write(31);
            } else if (val == 0) {
                out.write(32);
            } else if (val == 1) {
                out.write(33);
            } else if (val > 0 && val < 255) {
                out.write(34);
                out.write(val);
            } else {
                out.write(35);
                out.writeShort(val);
            }
            return;
        }
        if (clazz == Byte.class) {
            byte val = (Byte)obj;
            if (val == -1) {
                out.write(36);
            } else if (val == 0) {
                out.write(37);
            } else if (val == 1) {
                out.write(38);
            } else {
                out.write(39);
                out.writeByte(val);
            }
            return;
        }
        if (clazz == Character.class) {
            out.write(40);
            out.writeChar(((Character)obj).charValue());
            return;
        }
        if (clazz == String.class) {
            String s = (String)obj;
            if (s.length() == 0) {
                out.write(101);
            } else {
                out.write(103);
                SerializerBase.serializeString(out, s);
            }
            return;
        }
        if (obj instanceof Class) {
            out.write(126);
            this.serializeClass(out, (Class)obj);
            return;
        }
        if (obj instanceof int[]) {
            this.writeIntArray(out, (int[])obj);
            return;
        }
        if (obj instanceof long[]) {
            this.writeLongArray(out, (long[])obj);
            return;
        }
        if (obj instanceof short[]) {
            out.write(58);
            short[] a = (short[])obj;
            Utils.packInt(out, a.length);
            for (short s : a) {
                out.writeShort(s);
            }
            return;
        }
        if (obj instanceof boolean[]) {
            out.write(59);
            boolean[] a = (boolean[])obj;
            Utils.packInt(out, a.length);
            for (boolean s : a) {
                out.writeBoolean(s);
            }
            return;
        }
        if (obj instanceof double[]) {
            out.write(53);
            double[] a = (double[])obj;
            Utils.packInt(out, a.length);
            for (double s : a) {
                out.writeDouble(s);
            }
            return;
        }
        if (obj instanceof float[]) {
            out.write(56);
            float[] a = (float[])obj;
            Utils.packInt(out, a.length);
            for (float s : a) {
                out.writeFloat(s);
            }
            return;
        }
        if (obj instanceof char[]) {
            out.write(70);
            char[] a = (char[])obj;
            Utils.packInt(out, a.length);
            for (char s : a) {
                out.writeChar(s);
            }
            return;
        }
        if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            this.serializeByteArray(out, b);
            return;
        }
        if (clazz == Date.class) {
            out.write(127);
            out.writeLong(((Date)obj).getTime());
            return;
        }
        if (clazz == UUID.class) {
            out.write(108);
            out.writeLong(((UUID)obj).getMostSignificantBits());
            out.writeLong(((UUID)obj).getLeastSignificantBits());
            return;
        }
        if (clazz == BTreeKeySerializer.BasicKeySerializer.class) {
            out.write(146);
            if (((BTreeKeySerializer.BasicKeySerializer)obj).defaultSerializer != this) {
                throw new InternalError();
            }
            return;
        }
        if (clazz == CompressLZF.SerializerCompressWrapper.class) {
            out.write(120);
            this.serialize(out, ((CompressLZF.SerializerCompressWrapper)obj).serializer, objectStack);
            return;
        }
        if (obj == BTreeKeySerializer.ZERO_OR_POSITIVE_LONG) {
            out.write(147);
            return;
        }
        if (obj == BTreeKeySerializer.ZERO_OR_POSITIVE_INT) {
            out.write(149);
            return;
        }
        if (obj == Serializer.STRING_SERIALIZER) {
            out.write(129);
            return;
        }
        if (obj == Serializer.LONG_SERIALIZER) {
            out.write(150);
            return;
        }
        if (obj == Serializer.INTEGER_SERIALIZER) {
            out.write(151);
            return;
        }
        if (obj == Serializer.EMPTY_SERIALIZER) {
            out.write(152);
            return;
        }
        if (obj == Serializer.CRC32_CHECKSUM) {
            out.write(153);
            return;
        }
        if (obj == BTreeKeySerializer.STRING) {
            out.write(148);
            return;
        }
        if (obj == Utils.COMPARABLE_COMPARATOR) {
            out.write(130);
            return;
        }
        if (obj == Utils.COMPARABLE_COMPARATOR_WITH_NULLS) {
            out.write(131);
            return;
        }
        if (obj == BASIC_SERIALIZER) {
            out.write(132);
            return;
        }
        if (obj == Fun.HI) {
            out.write(128);
        } else if (obj == this) {
            out.write(133);
            return;
        }
        if (objectStack == null) {
            objectStack = new FastArrayList();
            objectStack.add(obj);
        }
        if (obj instanceof Object[]) {
            Class<?> componentType;
            Object[] b = (Object[])obj;
            boolean packableLongs = b.length <= 255;
            boolean allNull = true;
            if (packableLongs) {
                for (Object o : b) {
                    if (o != null) {
                        allNull = false;
                        if (o.getClass() != Long.class || (Long)o < 0L && (Long)o != Long.MAX_VALUE) {
                            packableLongs = false;
                        }
                    }
                    if (packableLongs || allNull) {
                        continue;
                    }
                    break;
                }
            } else {
                for (Object o : b) {
                    if (o == null) continue;
                    allNull = false;
                    break;
                }
            }
            if (allNull) {
                out.write(76);
                Utils.packInt(out, b.length);
                componentType = obj.getClass().getComponentType();
                this.serializeClass(out, componentType);
            } else if (packableLongs) {
                out.write(74);
                out.write(b.length);
                for (Object o : b) {
                    if (o == null) {
                        Utils.packLong(out, 0L);
                        continue;
                    }
                    Utils.packLong(out, (Long)o + 1L);
                }
            } else {
                out.write(73);
                Utils.packInt(out, b.length);
                componentType = obj.getClass().getComponentType();
                this.serializeClass(out, componentType);
                for (Object o : b) {
                    this.serialize(out, o, objectStack);
                }
            }
        } else if (clazz == ArrayList.class) {
            boolean packableLongs;
            ArrayList l = (ArrayList)obj;
            boolean bl = packableLongs = l.size() < 255;
            if (packableLongs) {
                for (Object o : l) {
                    if (o == null || o.getClass() == Long.class && ((Long)o >= 0L || (Long)o == Long.MAX_VALUE)) continue;
                    packableLongs = false;
                    break;
                }
            }
            if (packableLongs) {
                out.write(75);
                out.write(l.size());
                for (Object o : l) {
                    if (o == null) {
                        Utils.packLong(out, 0L);
                        continue;
                    }
                    Utils.packLong(out, (Long)o + 1L);
                }
            } else {
                this.serializeCollection(105, out, obj, objectStack);
            }
        } else if (clazz == LinkedList.class) {
            this.serializeCollection(119, out, obj, objectStack);
        } else if (clazz == Vector.class) {
            this.serializeCollection(121, out, obj, objectStack);
        } else if (clazz == TreeSet.class) {
            TreeSet l = (TreeSet)obj;
            out.write(113);
            Utils.packInt(out, l.size());
            this.serialize(out, l.comparator(), objectStack);
            for (Object o : l) {
                this.serialize(out, o, objectStack);
            }
        } else if (clazz == HashSet.class) {
            this.serializeCollection(115, out, obj, objectStack);
        } else if (clazz == LinkedHashSet.class) {
            this.serializeCollection(117, out, obj, objectStack);
        } else if (clazz == TreeMap.class) {
            TreeMap l = (TreeMap)obj;
            out.write(107);
            Utils.packInt(out, l.size());
            this.serialize(out, l.comparator(), objectStack);
            for (Object o : l.keySet()) {
                this.serialize(out, o, objectStack);
                this.serialize(out, l.get(o), objectStack);
            }
        } else if (clazz == HashMap.class) {
            this.serializeMap(109, out, obj, objectStack);
        } else if (clazz == IdentityHashMap.class) {
            this.serializeMap(122, out, obj, objectStack);
        } else if (clazz == LinkedHashMap.class) {
            this.serializeMap(111, out, obj, objectStack);
        } else if (clazz == Hashtable.class) {
            this.serializeMap(123, out, obj, objectStack);
        } else if (clazz == Properties.class) {
            this.serializeMap(125, out, obj, objectStack);
        } else if (clazz == Locale.class) {
            out.write(124);
            Locale l = (Locale)obj;
            out.writeUTF(l.getLanguage());
            out.writeUTF(l.getCountry());
            out.writeUTF(l.getVariant());
        } else if (clazz == Fun.Tuple2.class) {
            out.write(134);
            Fun.Tuple2 t = (Fun.Tuple2)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
        } else if (clazz == Fun.Tuple2.class) {
            out.write(135);
            Fun.Tuple3 t = (Fun.Tuple3)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
            this.serialize(out, t.c, objectStack);
        } else if (clazz == Fun.Tuple4.class) {
            out.write(136);
            Fun.Tuple4 t = (Fun.Tuple4)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
            this.serialize(out, t.c, objectStack);
            this.serialize(out, t.d, objectStack);
        } else {
            this.serializeUnknownObject(out, obj, objectStack);
        }
    }

    protected void serializeClass(DataOutput out, Class clazz) throws IOException {
        out.writeUTF(clazz.getName());
    }

    static void serializeString(DataOutput out, String obj) throws IOException {
        int len = obj.length();
        Utils.packInt(out, len);
        for (int i = 0; i < len; ++i) {
            char c = obj.charAt(i);
            Utils.packInt(out, c);
        }
    }

    private void serializeMap(int header, DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        Map l = (Map)obj;
        out.write(header);
        Utils.packInt(out, l.size());
        for (Object o : l.keySet()) {
            this.serialize(out, o, objectStack);
            this.serialize(out, l.get(o), objectStack);
        }
    }

    private void serializeCollection(int header, DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        Collection l = (Collection)obj;
        out.write(header);
        Utils.packInt(out, l.size());
        for (Object o : l) {
            this.serialize(out, o, objectStack);
        }
    }

    private void serializeByteArray(DataOutput out, byte[] b) throws IOException {
        boolean allEqual = b.length > 0;
        for (int i = 1; i < b.length; ++i) {
            if (b[i - 1] == b[i]) continue;
            allEqual = false;
            break;
        }
        if (allEqual) {
            out.write(72);
            Utils.packInt(out, b.length);
            out.write(b[0]);
        } else {
            out.write(71);
            Utils.packInt(out, b.length);
            out.write(b);
        }
    }

    private void writeLongArray(DataOutput da, long[] obj) throws IOException {
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (long i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        if (0L <= min && max <= 255L) {
            da.write(65);
            Utils.packInt(da, obj.length);
            for (long l : obj) {
                da.write((int)l);
            }
        } else if (0L <= min) {
            da.write(69);
            Utils.packInt(da, obj.length);
            for (long l : obj) {
                Utils.packLong(da, l);
            }
        } else if (-32768L <= min && max <= 32767L) {
            da.write(66);
            Utils.packInt(da, obj.length);
            for (long l : obj) {
                da.writeShort((short)l);
            }
        } else if (Integer.MIN_VALUE <= min && max <= Integer.MAX_VALUE) {
            da.write(67);
            Utils.packInt(da, obj.length);
            for (long l : obj) {
                da.writeInt((int)l);
            }
        } else {
            da.write(68);
            Utils.packInt(da, obj.length);
            for (long l : obj) {
                da.writeLong(l);
            }
        }
    }

    private void writeIntArray(DataOutput da, int[] obj) throws IOException {
        boolean fitsInShort;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        boolean fitsInByte = 0 <= min && max <= 255;
        boolean bl = fitsInShort = Short.MIN_VALUE >= min && max <= Short.MAX_VALUE;
        if (obj.length <= 255 && fitsInByte) {
            da.write(60);
            da.write(obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (fitsInByte) {
            da.write(61);
            Utils.packInt(da, obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (0 <= min) {
            da.write(64);
            Utils.packInt(da, obj.length);
            for (int l : obj) {
                Utils.packInt(da, l);
            }
        } else if (fitsInShort) {
            da.write(62);
            Utils.packInt(da, obj.length);
            for (int i : obj) {
                da.writeShort(i);
            }
        } else {
            da.write(63);
            Utils.packInt(da, obj.length);
            for (int i : obj) {
                da.writeInt(i);
            }
        }
    }

    private void writeInteger(DataOutput da, int val) throws IOException {
        if (val == -1) {
            da.write(4);
        } else if (val == 0) {
            da.write(5);
        } else if (val == 1) {
            da.write(6);
        } else if (val == 2) {
            da.write(7);
        } else if (val == 3) {
            da.write(8);
        } else if (val == 4) {
            da.write(9);
        } else if (val == 5) {
            da.write(10);
        } else if (val == 6) {
            da.write(11);
        } else if (val == 7) {
            da.write(12);
        } else if (val == 8) {
            da.write(13);
        } else if (val == Integer.MIN_VALUE) {
            da.write(57);
        } else if (val > 0 && val < 255) {
            da.write(14);
            da.write(val);
        } else if (val < 0) {
            da.write(15);
            Utils.packInt(da, -val);
        } else {
            da.write(16);
            Utils.packInt(da, val);
        }
    }

    private void writeLong(DataOutput da, long val) throws IOException {
        if (val == -1L) {
            da.write(17);
        } else if (val == 0L) {
            da.write(18);
        } else if (val == 1L) {
            da.write(19);
        } else if (val == 2L) {
            da.write(20);
        } else if (val == 3L) {
            da.write(21);
        } else if (val == 4L) {
            da.write(22);
        } else if (val == 5L) {
            da.write(23);
        } else if (val == 6L) {
            da.write(24);
        } else if (val == 7L) {
            da.write(25);
        } else if (val == 8L) {
            da.write(26);
        } else if (val == Long.MIN_VALUE) {
            da.write(30);
        } else if (val > 0L && val < 255L) {
            da.write(29);
            da.write((int)val);
        } else if (val < 0L) {
            da.write(27);
            Utils.packLong(da, -val);
        } else {
            da.write(28);
            Utils.packLong(da, val);
        }
    }

    static String deserializeString(DataInput buf) throws IOException {
        int len = Utils.unpackInt(buf);
        char[] b = new char[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (char)Utils.unpackInt(buf);
        }
        return new String(b);
    }

    public Object deserialize(DataInput is, int capacity) throws IOException {
        if (capacity == 0) {
            return null;
        }
        return this.deserialize(is, null);
    }

    public Object deserialize(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        Object ret = null;
        int head = is.readUnsignedByte();
        switch (head) {
            case 0: {
                break;
            }
            case 2: {
                ret = Boolean.TRUE;
                break;
            }
            case 3: {
                ret = Boolean.FALSE;
                break;
            }
            case 4: {
                ret = -1;
                break;
            }
            case 5: {
                ret = 0;
                break;
            }
            case 6: {
                ret = 1;
                break;
            }
            case 7: {
                ret = 2;
                break;
            }
            case 8: {
                ret = 3;
                break;
            }
            case 9: {
                ret = 4;
                break;
            }
            case 10: {
                ret = 5;
                break;
            }
            case 11: {
                ret = 6;
                break;
            }
            case 12: {
                ret = 7;
                break;
            }
            case 13: {
                ret = 8;
                break;
            }
            case 57: {
                ret = Integer.MIN_VALUE;
                break;
            }
            case 14: {
                ret = is.readUnsignedByte();
                break;
            }
            case 15: {
                ret = -Utils.unpackInt(is);
                break;
            }
            case 16: {
                ret = Utils.unpackInt(is);
                break;
            }
            case 17: {
                ret = -1L;
                break;
            }
            case 18: {
                ret = 0L;
                break;
            }
            case 19: {
                ret = 1L;
                break;
            }
            case 20: {
                ret = 2L;
                break;
            }
            case 21: {
                ret = 3L;
                break;
            }
            case 22: {
                ret = 4L;
                break;
            }
            case 23: {
                ret = 5L;
                break;
            }
            case 24: {
                ret = 6L;
                break;
            }
            case 25: {
                ret = 7L;
                break;
            }
            case 26: {
                ret = 8L;
                break;
            }
            case 29: {
                ret = (long)is.readUnsignedByte();
                break;
            }
            case 27: {
                ret = -Utils.unpackLong(is);
                break;
            }
            case 28: {
                ret = Utils.unpackLong(is);
                break;
            }
            case 30: {
                ret = Long.MIN_VALUE;
                break;
            }
            case 31: {
                ret = (short)-1;
                break;
            }
            case 32: {
                ret = (short)0;
                break;
            }
            case 33: {
                ret = (short)1;
                break;
            }
            case 34: {
                ret = (short)is.readUnsignedByte();
                break;
            }
            case 35: {
                ret = is.readShort();
                break;
            }
            case 36: {
                ret = (byte)-1;
                break;
            }
            case 37: {
                ret = (byte)0;
                break;
            }
            case 38: {
                ret = (byte)1;
                break;
            }
            case 39: {
                ret = is.readByte();
                break;
            }
            case 58: {
                int size = Utils.unpackInt(is);
                ret = new short[size];
                for (int i = 0; i < size; ++i) {
                    ((short[])ret)[i] = is.readShort();
                }
                break;
            }
            case 59: {
                int size = Utils.unpackInt(is);
                ret = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    ((boolean[])ret)[i] = is.readBoolean();
                }
                break;
            }
            case 53: {
                int size = Utils.unpackInt(is);
                ret = new double[size];
                for (int i = 0; i < size; ++i) {
                    ((double[])ret)[i] = is.readDouble();
                }
                break;
            }
            case 56: {
                int size = Utils.unpackInt(is);
                ret = new float[size];
                for (int i = 0; i < size; ++i) {
                    ((float[])ret)[i] = is.readFloat();
                }
                break;
            }
            case 70: {
                int size = Utils.unpackInt(is);
                ret = new char[size];
                for (int i = 0; i < size; ++i) {
                    ((char[])ret)[i] = is.readChar();
                }
                break;
            }
            case 40: {
                ret = Character.valueOf(is.readChar());
                break;
            }
            case 41: {
                ret = Float.valueOf(-1.0f);
                break;
            }
            case 42: {
                ret = Float.valueOf(0.0f);
                break;
            }
            case 43: {
                ret = Float.valueOf(1.0f);
                break;
            }
            case 44: {
                ret = Float.valueOf(is.readUnsignedByte());
                break;
            }
            case 45: {
                ret = Float.valueOf(is.readShort());
                break;
            }
            case 46: {
                ret = Float.valueOf(is.readFloat());
                break;
            }
            case 47: {
                ret = -1.0;
                break;
            }
            case 48: {
                ret = 0.0;
                break;
            }
            case 49: {
                ret = 1.0;
                break;
            }
            case 50: {
                ret = (double)is.readUnsignedByte();
                break;
            }
            case 51: {
                ret = (double)is.readShort();
                break;
            }
            case 52: {
                ret = is.readDouble();
                break;
            }
            case 55: {
                ret = new BigInteger(this.deserializeArrayByte(is));
                break;
            }
            case 54: {
                ret = new BigDecimal(new BigInteger(this.deserializeArrayByte(is)), Utils.unpackInt(is));
                break;
            }
            case 103: {
                ret = SerializerBase.deserializeString(is);
                break;
            }
            case 101: {
                ret = "";
                break;
            }
            case 126: {
                ret = this.deserializeClass(is);
                break;
            }
            case 127: {
                ret = new Date(is.readLong());
                break;
            }
            case 108: {
                ret = new UUID(is.readLong(), is.readLong());
                break;
            }
            case 60: {
                ret = this.deserializeArrayIntB255(is);
                break;
            }
            case 61: {
                ret = this.deserializeArrayIntBInt(is);
                break;
            }
            case 62: {
                ret = this.deserializeArrayIntSInt(is);
                break;
            }
            case 63: {
                ret = this.deserializeArrayIntIInt(is);
                break;
            }
            case 64: {
                ret = this.deserializeArrayIntPack(is);
                break;
            }
            case 65: {
                ret = this.deserializeArrayLongB(is);
                break;
            }
            case 66: {
                ret = this.deserializeArrayLongS(is);
                break;
            }
            case 67: {
                ret = this.deserializeArrayLongI(is);
                break;
            }
            case 68: {
                ret = this.deserializeArrayLongL(is);
                break;
            }
            case 69: {
                ret = this.deserializeArrayLongPack(is);
                break;
            }
            case 75: {
                ret = this.deserializeArrayListPackedLong(is);
                break;
            }
            case 72: {
                byte[] b = new byte[Utils.unpackInt(is)];
                Arrays.fill(b, is.readByte());
                ret = b;
                break;
            }
            case 71: {
                ret = this.deserializeArrayByte(is);
                break;
            }
            case 124: {
                ret = new Locale(is.readUTF(), is.readUTF(), is.readUTF());
                break;
            }
            case 130: {
                ret = Utils.COMPARABLE_COMPARATOR;
                break;
            }
            case 150: {
                ret = LONG_SERIALIZER;
                break;
            }
            case 151: {
                ret = INTEGER_SERIALIZER;
                break;
            }
            case 152: {
                ret = EMPTY_SERIALIZER;
                break;
            }
            case 153: {
                ret = Serializer.CRC32_CHECKSUM;
                break;
            }
            case 147: {
                ret = BTreeKeySerializer.ZERO_OR_POSITIVE_LONG;
                break;
            }
            case 149: {
                ret = BTreeKeySerializer.ZERO_OR_POSITIVE_INT;
                break;
            }
            case 148: {
                ret = BTreeKeySerializer.STRING;
                break;
            }
            case 131: {
                ret = Utils.COMPARABLE_COMPARATOR_WITH_NULLS;
                break;
            }
            case 146: {
                ret = new BTreeKeySerializer.BasicKeySerializer(this);
                break;
            }
            case 132: {
                ret = BASIC_SERIALIZER;
                break;
            }
            case 129: {
                ret = Serializer.STRING_SERIALIZER;
                break;
            }
            case 134: {
                ret = new Fun.Tuple2<Object, Object>(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
                break;
            }
            case 135: {
                ret = new Fun.Tuple3<Object, Object, Object>(this.deserialize(is, objectStack), this.deserialize(is, objectStack), this.deserialize(is, objectStack));
                break;
            }
            case 136: {
                ret = new Fun.Tuple4<Object, Object, Object, Object>(this.deserialize(is, objectStack), this.deserialize(is, objectStack), this.deserialize(is, objectStack), this.deserialize(is, objectStack));
                break;
            }
            case 128: {
                ret = Fun.HI;
                break;
            }
            case 133: {
                ret = this;
                break;
            }
            case 172: {
                throw new InternalError("Wrong header, data were probably serialized with java.lang.ObjectOutputStream, not with JDBM serialization");
            }
            case 74: {
                ret = this.deserializeArrayObjectPackedLong(is);
                break;
            }
            case 76: {
                ret = this.deserializeArrayObjectAllNull(is);
                break;
            }
            case 77: {
                ret = this.deserializeArrayObjectNoRefs(is);
                break;
            }
            case -1: {
                throw new EOFException();
            }
        }
        if (ret != null || head == 0) {
            if (objectStack != null) {
                objectStack.add(ret);
            }
            return ret;
        }
        if (objectStack == null) {
            objectStack = new FastArrayList();
        }
        int oldObjectStackSize = objectStack.size();
        switch (head) {
            case 166: {
                ret = objectStack.get(Utils.unpackInt(is));
                break;
            }
            case 105: {
                ret = this.deserializeArrayList(is, objectStack);
                break;
            }
            case 73: {
                ret = this.deserializeArrayObject(is, objectStack);
                break;
            }
            case 119: {
                ret = this.deserializeLinkedList(is, objectStack);
                break;
            }
            case 113: {
                ret = this.deserializeTreeSet(is, objectStack);
                break;
            }
            case 115: {
                ret = this.deserializeHashSet(is, objectStack);
                break;
            }
            case 117: {
                ret = this.deserializeLinkedHashSet(is, objectStack);
                break;
            }
            case 121: {
                ret = this.deserializeVector(is, objectStack);
                break;
            }
            case 107: {
                ret = this.deserializeTreeMap(is, objectStack);
                break;
            }
            case 109: {
                ret = this.deserializeHashMap(is, objectStack);
                break;
            }
            case 122: {
                ret = this.deserializeIdentityHashMap(is, objectStack);
                break;
            }
            case 111: {
                ret = this.deserializeLinkedHashMap(is, objectStack);
                break;
            }
            case 123: {
                ret = this.deserializeHashtable(is, objectStack);
                break;
            }
            case 125: {
                ret = this.deserializeProperties(is, objectStack);
                break;
            }
            case 120: {
                ret = CompressLZF.serializerCompressWrapper((Serializer)this.deserialize(is, objectStack));
                break;
            }
            default: {
                ret = this.deserializeUnknownHeader(is, head, objectStack);
            }
        }
        if (head != 166 && objectStack.size() == oldObjectStackSize) {
            objectStack.add(ret);
        }
        return ret;
    }

    private byte[] deserializeArrayByte(DataInput is) throws IOException {
        byte[] bb = new byte[Utils.unpackInt(is)];
        is.readFully(bb);
        return bb;
    }

    protected Class deserializeClass(DataInput is) throws IOException {
        try {
            return Class.forName(is.readUTF());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private long[] deserializeArrayLongL(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readLong();
        }
        return ret;
    }

    private long[] deserializeArrayLongI(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private long[] deserializeArrayLongS(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private long[] deserializeArrayLongB(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0L) continue;
            throw new EOFException();
        }
        return ret;
    }

    private int[] deserializeArrayIntIInt(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private int[] deserializeArrayIntSInt(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private int[] deserializeArrayIntBInt(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private int[] deserializeArrayIntPack(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = Utils.unpackInt(is);
        }
        return ret;
    }

    private long[] deserializeArrayLongPack(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = Utils.unpackLong(is);
        }
        return ret;
    }

    private int[] deserializeArrayIntB255(DataInput is) throws IOException {
        int size = is.readUnsignedByte();
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private Object[] deserializeArrayObject(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        Class clazz = this.deserializeClass(is);
        Object[] s = (Object[])Array.newInstance(clazz, size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s[i] = this.deserialize(is, objectStack);
        }
        return s;
    }

    private Object[] deserializeArrayObjectNoRefs(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        Class clazz = this.deserializeClass(is);
        Object[] s = (Object[])Array.newInstance(clazz, size);
        for (int i = 0; i < size; ++i) {
            s[i] = this.deserialize(is, null);
        }
        return s;
    }

    private Object[] deserializeArrayObjectAllNull(DataInput is) throws IOException {
        int size = Utils.unpackInt(is);
        Class clazz = this.deserializeClass(is);
        Object[] s = (Object[])Array.newInstance(clazz, size);
        return s;
    }

    private Object[] deserializeArrayObjectPackedLong(DataInput is) throws IOException {
        int size = is.readUnsignedByte();
        Object[] s = new Object[size];
        for (int i = 0; i < size; ++i) {
            long l = Utils.unpackLong(is);
            s[i] = l == 0L ? null : Long.valueOf(l - 1L);
        }
        return s;
    }

    private ArrayList<Object> deserializeArrayList(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        ArrayList<Object> s = new ArrayList<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private ArrayList<Object> deserializeArrayListPackedLong(DataInput is) throws IOException {
        int size = is.readUnsignedByte();
        if (size < 0) {
            throw new EOFException();
        }
        ArrayList<Object> s = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            long l = Utils.unpackLong(is);
            if (l == 0L) {
                s.add(null);
                continue;
            }
            s.add(l - 1L);
        }
        return s;
    }

    private LinkedList deserializeLinkedList(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        LinkedList<Object> s = new LinkedList<Object>();
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private Vector<Object> deserializeVector(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        Vector<Object> s = new Vector<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private HashSet<Object> deserializeHashSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        HashSet<Object> s = new HashSet<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private LinkedHashSet<Object> deserializeLinkedHashSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        LinkedHashSet<Object> s = new LinkedHashSet<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private TreeSet<Object> deserializeTreeSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        TreeSet<Object> s = new TreeSet<Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeSet(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private TreeMap<Object, Object> deserializeTreeMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        TreeMap<Object, Object> s = new TreeMap<Object, Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeMap(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private HashMap<Object, Object> deserializeHashMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        HashMap<Object, Object> s = new HashMap<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private IdentityHashMap<Object, Object> deserializeIdentityHashMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        IdentityHashMap<Object, Object> s = new IdentityHashMap<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private LinkedHashMap<Object, Object> deserializeLinkedHashMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        LinkedHashMap<Object, Object> s = new LinkedHashMap<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private Hashtable<Object, Object> deserializeHashtable(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        Hashtable<Object, Object> s = new Hashtable<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private Properties deserializeProperties(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = Utils.unpackInt(is);
        Properties s = new Properties();
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    protected void serializeUnknownObject(DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        throw new InternalError("Could not deserialize unknown object: " + obj.getClass().getName());
    }

    protected Object deserializeUnknownHeader(DataInput is, int head, FastArrayList<Object> objectStack) throws IOException {
        throw new InternalError("Unknown serialization header: " + head);
    }

    static final class FastArrayList<K> {
        private int size = 0;
        private K[] elementData = new Object[1];
        boolean forwardRefs = false;

        FastArrayList() {
        }

        K get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.elementData[index];
        }

        void add(K o) {
            if (this.elementData.length == this.size) {
                this.elementData = Arrays.copyOf(this.elementData, this.elementData.length * 2);
            }
            this.elementData[this.size] = o;
            ++this.size;
        }

        int size() {
            return this.size;
        }

        int identityIndexOf(Object obj) {
            for (int i = 0; i < this.size; ++i) {
                if (obj != this.elementData[i]) continue;
                this.forwardRefs = true;
                return i;
            }
            return -1;
        }
    }
}

