/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.zip.CRC32;
import org.mapdb.SerializerBase;

public interface Serializer<A> {
    public static final Serializer<String> STRING_SERIALIZER = new Serializer<String>(){

        @Override
        public void serialize(DataOutput out, String value) throws IOException {
            byte[] bytes = value.getBytes("UTF8");
            out.write(bytes);
        }

        @Override
        public String deserialize(DataInput in, int available) throws IOException {
            byte[] bytes = new byte[available];
            in.readFully(bytes);
            return new String(bytes, "UTF8");
        }
    };
    public static final Serializer<Long> LONG_SERIALIZER = new Serializer<Long>(){

        @Override
        public void serialize(DataOutput out, Long value) throws IOException {
            out.writeLong(value);
        }

        @Override
        public Long deserialize(DataInput in, int available) throws IOException {
            return in.readLong();
        }
    };
    public static final Serializer<Integer> INTEGER_SERIALIZER = new Serializer<Integer>(){

        @Override
        public void serialize(DataOutput out, Integer value) throws IOException {
            out.writeInt(value);
        }

        @Override
        public Integer deserialize(DataInput in, int available) throws IOException {
            return in.readInt();
        }
    };
    public static final Serializer<Boolean> BOOLEAN_SERIALIZER = new Serializer<Boolean>(){

        @Override
        public void serialize(DataOutput out, Boolean value) throws IOException {
            out.writeBoolean(value);
        }

        @Override
        public Boolean deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            return in.readBoolean();
        }
    };
    public static final Serializer<Object> EMPTY_SERIALIZER = new Serializer<Object>(){

        @Override
        public void serialize(DataOutput out, Object value) throws IOException {
            if (value != "") {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Object deserialize(DataInput in, int available) throws IOException {
            if (available != 0) {
                throw new InternalError();
            }
            return "";
        }
    };
    public static final Serializer<Object> BASIC_SERIALIZER = new SerializerBase();
    public static final Serializer<byte[]> CRC32_CHECKSUM = new Serializer<byte[]>(){

        @Override
        public void serialize(DataOutput out, byte[] value) throws IOException {
            if (value == null || value.length == 0) {
                return;
            }
            CRC32 crc = new CRC32();
            crc.update(value);
            out.write(value);
            out.writeInt((int)crc.getValue());
        }

        @Override
        public byte[] deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            byte[] value = new byte[available - 4];
            in.readFully(value);
            CRC32 crc = new CRC32();
            crc.update(value);
            int checksum = in.readInt();
            if (checksum != (int)crc.getValue()) {
                throw new IOException("CRC32 does not match, data broken");
            }
            return value;
        }
    };

    public void serialize(DataOutput var1, A var2) throws IOException;

    public A deserialize(DataInput var1, int var2) throws IOException;
}

