/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.Atomic;
import org.mapdb.Engine;
import org.mapdb.Locks;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public final class Queues {
    private Queues() {
    }

    static <E> long createStack(Engine engine, Serializer<Serializer> serializerSerializer, Serializer<E> serializer, boolean useLocks) {
        long headerRecid = engine.put(0L, Serializer.LONG_SERIALIZER);
        StackRoot root = new StackRoot(headerRecid, useLocks, serializer);
        StackRootSerializer rootSerializer = new StackRootSerializer(serializerSerializer);
        return engine.put(root, rootSerializer);
    }

    static <E> Stack<E> getStack(Engine engine, Serializer<Serializer> serializerSerializer, long rootRecid) {
        StackRoot root = engine.get(rootRecid, new StackRootSerializer(serializerSerializer));
        return new Stack(engine, root.serializer, root.headerRecid, root.useLocks);
    }

    static <E> long createQueue(Engine engine, Serializer<Serializer> serializerSerializer, Serializer<E> serializer) {
        long headerRecid = engine.put(0L, Serializer.LONG_SERIALIZER);
        long nextTail = engine.put(SimpleQueue.Node.EMPTY, new SimpleQueue.NodeSerializer(null));
        long nextTailRecid = engine.put(nextTail, Serializer.LONG_SERIALIZER);
        long sizeRecid = engine.put(0L, Serializer.LONG_SERIALIZER);
        QueueRoot root = new QueueRoot(headerRecid, nextTailRecid, sizeRecid, serializer);
        QueueRootSerializer rootSerializer = new QueueRootSerializer(serializerSerializer);
        return engine.put(root, rootSerializer);
    }

    static <E> Queue<E> getQueue(Engine engine, Serializer<Serializer> serializerSerializer, long rootRecid) {
        QueueRoot root = engine.get(rootRecid, new QueueRootSerializer(serializerSerializer));
        return new Queue(engine, root.serializer, root.headerRecid, root.nextTailRecid, root.sizeRecid);
    }

    static <E> long createCircularQueue(Engine engine, Serializer<Serializer> serializerSerializer, Serializer<E> serializer, long size) {
        if (size < 2L) {
            throw new IllegalArgumentException();
        }
        long prevRecid = 0L;
        long firstRecid = 0L;
        SimpleQueue.NodeSerializer<Serializer> nodeSer = new SimpleQueue.NodeSerializer<Serializer>(serializerSerializer);
        for (long i = 0L; i < size; ++i) {
            SimpleQueue.Node<Object> n = new SimpleQueue.Node<Object>(prevRecid, null);
            prevRecid = engine.put(n, nodeSer);
            if (firstRecid != 0L) continue;
            firstRecid = prevRecid;
        }
        engine.update(firstRecid, new SimpleQueue.Node<Object>(prevRecid, null), nodeSer);
        long headerRecid = engine.put(prevRecid, Serializer.LONG_SERIALIZER);
        long headerInsertRecid = engine.put(prevRecid, Serializer.LONG_SERIALIZER);
        CircularQueueRoot root = new CircularQueueRoot(headerRecid, headerInsertRecid, size, serializer);
        CircularQueueRootSerializer rootSerializer = new CircularQueueRootSerializer(serializerSerializer);
        return engine.put(root, rootSerializer);
    }

    static <E> CircularQueue<E> getCircularQueue(Engine engine, Serializer<Serializer> serializerSerializer, long rootRecid) {
        CircularQueueRoot root = engine.get(rootRecid, new CircularQueueRootSerializer(serializerSerializer));
        return new CircularQueue(engine, root.serializer, root.headerRecid, root.headerInsertRecid, root.sizeRecid);
    }

    protected static final class CircularQueueRootSerializer
    implements Serializer<CircularQueueRoot> {
        final Serializer<Serializer> serialierSerializer;

        public CircularQueueRootSerializer(Serializer<Serializer> serialierSerializer) {
            this.serialierSerializer = serialierSerializer;
        }

        @Override
        public void serialize(DataOutput out, CircularQueueRoot value) throws IOException {
            out.write(156);
            Utils.packLong(out, value.headerRecid);
            Utils.packLong(out, value.headerInsertRecid);
            Utils.packLong(out, value.sizeRecid);
            this.serialierSerializer.serialize(out, value.serializer);
        }

        @Override
        public CircularQueueRoot deserialize(DataInput in, int available) throws IOException {
            if (in.readUnsignedByte() != 156) {
                throw new InternalError();
            }
            return new CircularQueueRoot(Utils.unpackLong(in), Utils.unpackLong(in), Utils.unpackLong(in), this.serialierSerializer.deserialize(in, -1));
        }
    }

    protected static final class CircularQueueRoot {
        final long headerRecid;
        final long headerInsertRecid;
        final Serializer serializer;
        final long sizeRecid;

        public CircularQueueRoot(long headerRecid, long headerInsertRecid, long sizeRecid, Serializer serializer) {
            this.headerRecid = headerRecid;
            this.headerInsertRecid = headerInsertRecid;
            this.serializer = serializer;
            this.sizeRecid = sizeRecid;
        }
    }

    public static class CircularQueue<E>
    extends SimpleQueue<E> {
        protected final Atomic.Long headInsert;
        protected final Lock lock = new ReentrantLock();
        protected final long size;

        public CircularQueue(Engine engine, Serializer serializer, long headRecid, long headInsertRecid, long size) {
            super(engine, serializer, headRecid);
            this.headInsert = new Atomic.Long(engine, headInsertRecid);
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Object o) {
            this.lock.lock();
            try {
                long nRecid = this.headInsert.get();
                SimpleQueue.Node<Object> n = (SimpleQueue.Node<Object>)this.engine.get(nRecid, this.nodeSerializer);
                n = new SimpleQueue.Node<Object>(n.next, o);
                this.engine.update(nRecid, n, this.nodeSerializer);
                this.headInsert.set(n.next);
                this.head.compareAndSet(nRecid, n.next);
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E poll() {
            this.lock.lock();
            try {
                long nRecid = this.head.get();
                SimpleQueue.Node n = (SimpleQueue.Node)this.engine.get(nRecid, this.nodeSerializer);
                this.engine.update(nRecid, new SimpleQueue.Node<Object>(n.next, null), this.nodeSerializer);
                this.head.set(n.next);
                Object e = n.value;
                return e;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E peek() {
            this.lock.lock();
            try {
                long nRecid = this.head.get();
                SimpleQueue.Node n = (SimpleQueue.Node)this.engine.get(nRecid, this.nodeSerializer);
                Object e = n.value;
                return e;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected static final class QueueRootSerializer
    implements Serializer<QueueRoot> {
        final Serializer<Serializer> serialierSerializer;

        public QueueRootSerializer(Serializer<Serializer> serialierSerializer) {
            this.serialierSerializer = serialierSerializer;
        }

        @Override
        public void serialize(DataOutput out, QueueRoot value) throws IOException {
            out.write(155);
            Utils.packLong(out, value.headerRecid);
            Utils.packLong(out, value.nextTailRecid);
            Utils.packLong(out, value.sizeRecid);
            this.serialierSerializer.serialize(out, value.serializer);
        }

        @Override
        public QueueRoot deserialize(DataInput in, int available) throws IOException {
            if (in.readUnsignedByte() != 155) {
                throw new InternalError();
            }
            return new QueueRoot(Utils.unpackLong(in), Utils.unpackLong(in), Utils.unpackLong(in), this.serialierSerializer.deserialize(in, -1));
        }
    }

    protected static final class QueueRoot {
        final long headerRecid;
        final long nextTailRecid;
        final Serializer serializer;
        final long sizeRecid;

        public QueueRoot(long headerRecid, long nextTailRecid, long sizeRecid, Serializer serializer) {
            this.headerRecid = headerRecid;
            this.nextTailRecid = nextTailRecid;
            this.serializer = serializer;
            this.sizeRecid = sizeRecid;
        }
    }

    public static class Queue<E>
    extends SimpleQueue<E> {
        protected final Atomic.Long tail;
        protected final Atomic.Long size;

        public Queue(Engine engine, Serializer<E> serializer, long headerRecid, long nextTailRecid, long sizeRecid) {
            super(engine, serializer, headerRecid);
            this.tail = new Atomic.Long(engine, nextTailRecid);
            this.size = new Atomic.Long(engine, sizeRecid);
        }

        @Override
        public boolean isEmpty() {
            return this.head.get() == 0L;
        }

        @Override
        public boolean add(E item) {
            long nextTail = this.engine.put(SimpleQueue.Node.EMPTY, this.nodeSerializer);
            SimpleQueue.Node<E> n = new SimpleQueue.Node<E>(nextTail, item);
            long tail2 = this.tail.get();
            while (!this.engine.compareAndSwap(tail2, SimpleQueue.Node.EMPTY, n, this.nodeSerializer)) {
                tail2 = this.tail.get();
            }
            this.head.compareAndSet(0L, tail2);
            this.tail.set(nextTail);
            this.size.incrementAndGet();
            return true;
        }

        @Override
        public E poll() {
            SimpleQueue.Node n;
            long head2;
            while (true) {
                if ((head2 = this.head.get()) == 0L) {
                    return null;
                }
                n = (SimpleQueue.Node)this.engine.get(head2, this.nodeSerializer);
                if (n == null) {
                    if (this.size.get() != 0L) continue;
                    return null;
                }
                if (this.engine.compareAndSwap(head2, n, SimpleQueue.Node.EMPTY, this.nodeSerializer)) break;
            }
            if (!this.head.compareAndSet(head2, n.next)) {
                throw new InternalError();
            }
            this.size.decrementAndGet();
            return n.value;
        }

        @Override
        public E peek() {
            long head2 = this.head.get();
            if (head2 == 0L) {
                return null;
            }
            SimpleQueue.Node n = (SimpleQueue.Node)this.engine.get(head2, this.nodeSerializer);
            while (n == null) {
                if (this.size.get() == 0L) {
                    return null;
                }
                n = (SimpleQueue.Node)this.engine.get(head2, this.nodeSerializer);
            }
            return n.value;
        }
    }

    protected static final class StackRootSerializer
    implements Serializer<StackRoot> {
        final Serializer<Serializer> serialierSerializer;

        public StackRootSerializer(Serializer<Serializer> serialierSerializer) {
            this.serialierSerializer = serialierSerializer;
        }

        @Override
        public void serialize(DataOutput out, StackRoot value) throws IOException {
            out.write(154);
            Utils.packLong(out, value.headerRecid);
            out.writeBoolean(value.useLocks);
            this.serialierSerializer.serialize(out, value.serializer);
        }

        @Override
        public StackRoot deserialize(DataInput in, int available) throws IOException {
            if (in.readUnsignedByte() != 154) {
                throw new InternalError();
            }
            return new StackRoot(Utils.unpackLong(in), in.readBoolean(), this.serialierSerializer.deserialize(in, -1));
        }
    }

    protected static final class StackRoot {
        final long headerRecid;
        final boolean useLocks;
        final Serializer serializer;

        public StackRoot(long headerRecid, boolean useLocks, Serializer serializer) {
            this.headerRecid = headerRecid;
            this.useLocks = useLocks;
            this.serializer = serializer;
        }
    }

    public static class Stack<E>
    extends SimpleQueue<E> {
        protected final boolean useLocks;
        protected final Locks.RecidLocks locks;

        public Stack(Engine engine, Serializer<E> serializer, long headerRecid, boolean useLocks) {
            super(engine, serializer, headerRecid);
            this.useLocks = useLocks;
            this.locks = useLocks ? new Locks.LongHashMapRecidLocks() : null;
        }

        @Override
        public E peek() {
            SimpleQueue.Node n;
            long head3;
            long head2;
            do {
                if (0L == (head2 = this.head.get())) {
                    return null;
                }
                n = (SimpleQueue.Node)this.engine.get(head2, this.nodeSerializer);
                head3 = this.head.get();
                if (0L != head2) continue;
                return null;
            } while (head2 != head3);
            return n.value;
        }

        @Override
        public E poll() {
            SimpleQueue.Node n;
            long head2 = 0L;
            do {
                if (this.useLocks && head2 != 0L) {
                    this.locks.unlock(head2);
                }
                if ((head2 = this.head.get()) == 0L) {
                    return null;
                }
                if (!this.useLocks || head2 == 0L) continue;
                this.locks.lock(head2);
            } while ((n = (SimpleQueue.Node)this.engine.get(head2, this.nodeSerializer)) == null || !this.head.compareAndSet(head2, n.next));
            if (this.useLocks && head2 != 0L) {
                this.engine.delete(head2, Serializer.LONG_SERIALIZER);
                this.locks.unlock(head2);
            } else {
                this.engine.update(head2, null, this.nodeSerializer);
            }
            return n.value;
        }

        @Override
        public boolean add(E e) {
            long head2 = this.head.get();
            SimpleQueue.Node<E> n = new SimpleQueue.Node<E>(head2, e);
            long recid = this.engine.put(n, this.nodeSerializer);
            while (!this.head.compareAndSet(head2, recid)) {
                head2 = this.head.get();
                n = new SimpleQueue.Node<E>(head2, e);
                this.engine.update(recid, n, this.nodeSerializer);
            }
            return true;
        }
    }

    public static abstract class SimpleQueue<E>
    implements java.util.Queue<E> {
        protected final Engine engine;
        protected final Serializer<E> serializer;
        protected final Atomic.Long head;
        protected final Serializer<Node<E>> nodeSerializer;

        public SimpleQueue(Engine engine, Serializer<E> serializer, long headRecid) {
            this.engine = engine;
            this.serializer = serializer;
            if (headRecid == 0L) {
                headRecid = engine.put(0L, Serializer.LONG_SERIALIZER);
            }
            this.head = new Atomic.Long(engine, headRecid);
            this.nodeSerializer = new NodeSerializer<E>(serializer);
        }

        public void close() {
            this.engine.close();
        }

        @Override
        public void clear() {
            while (!this.isEmpty()) {
                this.remove();
            }
        }

        @Override
        public E remove() {
            Object ret = this.poll();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public E element() {
            Object ret = this.peek();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public boolean offer(E e) {
            return this.add(e);
        }

        @Override
        public boolean isEmpty() {
            return this.head.get() == 0L;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        protected static final class Node<E> {
            protected static final Node EMPTY = new Node<Object>(0L, null);
            protected final long next;
            protected final E value;

            public Node(long next, E value) {
                this.next = next;
                this.value = value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Node node = (Node)o;
                if (this.next != node.next) {
                    return false;
                }
                return !(this.value != null ? !this.value.equals(node.value) : node.value != null);
            }

            public int hashCode() {
                int result = (int)(this.next ^ this.next >>> 32);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }

        protected static class NodeSerializer<E>
        implements Serializer<Node<E>> {
            private final Serializer<E> serializer;

            public NodeSerializer(Serializer<E> serializer) {
                this.serializer = serializer;
            }

            @Override
            public void serialize(DataOutput out, Node<E> value) throws IOException {
                if (value == Node.EMPTY) {
                    return;
                }
                Utils.packLong(out, value.next);
                this.serializer.serialize(out, value.value);
            }

            @Override
            public Node<E> deserialize(DataInput in, int available) throws IOException {
                if (available == 0) {
                    return Node.EMPTY;
                }
                return new Node<E>(Utils.unpackLong(in), this.serializer.deserialize(in, -1));
            }
        }
    }
}

