/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Bind;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.SnapshotEngine;
import org.mapdb.Utils;

public class HTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Bind.MapWithModificationListener<K, V> {
    protected static final int BUCKET_OVERFLOW = 4;
    protected final boolean hasValues;
    protected final int hashSalt;
    protected final Serializer<K> keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final Serializer defaultSerialzierForSnapshots;
    final Serializer<LinkedNode<K, V>> LN_SERIALIZER = new Serializer<LinkedNode<K, V>>(){

        @Override
        public void serialize(DataOutput out, LinkedNode<K, V> value) throws IOException {
            Utils.packLong(out, value.next);
            HTreeMap.this.keySerializer.serialize(out, value.key);
            if (HTreeMap.this.hasValues) {
                HTreeMap.this.valueSerializer.serialize(out, value.value);
            }
        }

        @Override
        public LinkedNode<K, V> deserialize(DataInput in, int available) throws IOException {
            return new LinkedNode(Utils.unpackLong(in), HTreeMap.this.keySerializer.deserialize(in, -1), (String)(HTreeMap.this.hasValues ? HTreeMap.this.valueSerializer.deserialize(in, -1) : ""));
        }
    };
    static final Serializer<long[][]> DIR_SERIALIZER = new Serializer<long[][]>(){

        @Override
        public void serialize(DataOutput out, long[][] value) throws IOException {
            int i;
            if (value.length != 16) {
                throw new InternalError();
            }
            int nulls = 0;
            for (i = 0; i < 16; ++i) {
                if (value[i] == null) continue;
                nulls |= 1 << i;
            }
            out.writeShort(nulls);
            for (i = 0; i < 16; ++i) {
                if (value[i] == null) continue;
                if (value[i].length != 8) {
                    throw new InternalError();
                }
                for (long l : value[i]) {
                    Utils.packLong(out, l);
                }
            }
        }

        @Override
        public long[][] deserialize(DataInput in, int available) throws IOException {
            long[][] ret = new long[16][];
            int nulls = in.readUnsignedShort();
            for (int i = 0; i < 16; ++i) {
                if ((nulls & 1) != 0) {
                    long[] subarray = new long[8];
                    for (int j = 0; j < 8; ++j) {
                        subarray[j] = Utils.unpackLong(in);
                    }
                    ret[i] = subarray;
                }
                nulls >>>= 1;
            }
            return ret;
        }
    };
    protected final long[] segmentRecids;
    protected final ReentrantReadWriteLock[] segmentLocks = new ReentrantReadWriteLock[16];
    protected final Engine engine;
    public final long rootRecid;
    private final Set<K> _keySet;
    private final Collection<V> _values;
    private Set<Map.Entry<K, V>> _entrySet;
    protected final Object modListenersLock;
    protected Bind.MapListener<K, V>[] modListeners;

    public HTreeMap(Engine engine, boolean hasValues, int hashSalt, Serializer defaultSerializer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        int i;
        for (i = 0; i < 16; ++i) {
            this.segmentLocks[i] = new ReentrantReadWriteLock();
        }
        this._keySet = new AbstractSet<K>(){

            @Override
            public int size() {
                return HTreeMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return HTreeMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return HTreeMap.this.containsKey(o);
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public boolean add(K k) {
                if (HTreeMap.this.hasValues) {
                    throw new UnsupportedOperationException();
                }
                return HTreeMap.this.put(k, "") == null;
            }

            @Override
            public boolean remove(Object o) {
                return HTreeMap.this.remove(o) != null;
            }

            @Override
            public void clear() {
                HTreeMap.this.clear();
            }
        };
        this._values = new AbstractCollection<V>(){

            @Override
            public int size() {
                return HTreeMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return HTreeMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return HTreeMap.this.containsValue(o);
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }
        };
        this._entrySet = new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return HTreeMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return HTreeMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    Object val = HTreeMap.this.get(e.getKey());
                    return val != null && val.equals(e.getValue());
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean add(Map.Entry<K, V> kvEntry) {
                Object key = kvEntry.getKey();
                Object value = kvEntry.getValue();
                if (key == null || value == null) {
                    throw new NullPointerException();
                }
                HTreeMap.this.put(key, value);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    Object key = e.getKey();
                    if (key == null) {
                        return false;
                    }
                    return HTreeMap.this.remove(key, e.getValue());
                }
                return false;
            }

            @Override
            public void clear() {
                HTreeMap.this.clear();
            }
        };
        this.modListenersLock = new Object();
        this.modListeners = new Bind.MapListener[0];
        this.engine = engine;
        this.hasValues = hasValues;
        this.hashSalt = hashSalt;
        SerializerBase.assertSerializable(keySerializer);
        SerializerBase.assertSerializable(valueSerializer);
        if (defaultSerializer == null) {
            defaultSerializer = Serializer.BASIC_SERIALIZER;
        }
        this.defaultSerialzierForSnapshots = defaultSerializer;
        this.keySerializer = keySerializer == null ? defaultSerializer : keySerializer;
        this.valueSerializer = valueSerializer == null ? defaultSerializer : valueSerializer;
        this.segmentRecids = new long[16];
        for (i = 0; i < 16; ++i) {
            this.segmentRecids[i] = engine.put(new long[16][], DIR_SERIALIZER);
        }
        HashRoot r = new HashRoot();
        r.hasValues = hasValues;
        r.hashSalt = hashSalt;
        r.segmentRecids = this.segmentRecids;
        r.keySerializer = this.keySerializer;
        r.valueSerializer = this.valueSerializer;
        this.rootRecid = engine.put(r, new HashRootSerializer(defaultSerializer));
    }

    public HTreeMap(Engine engine, long rootRecid, Serializer defaultSerializer) {
        for (int i = 0; i < 16; ++i) {
            this.segmentLocks[i] = new ReentrantReadWriteLock();
        }
        this._keySet = new /* invalid duplicate definition of identical inner class */;
        this._values = new /* invalid duplicate definition of identical inner class */;
        this._entrySet = new /* invalid duplicate definition of identical inner class */;
        this.modListenersLock = new Object();
        this.modListeners = new Bind.MapListener[0];
        if (rootRecid == 0L) {
            throw new IllegalArgumentException("recid is 0");
        }
        this.engine = engine;
        this.rootRecid = rootRecid;
        if (defaultSerializer == null) {
            defaultSerializer = Serializer.BASIC_SERIALIZER;
        }
        this.defaultSerialzierForSnapshots = defaultSerializer;
        HashRoot r = engine.get(rootRecid, new HashRootSerializer(defaultSerializer));
        this.segmentRecids = r.segmentRecids;
        this.hasValues = r.hasValues;
        this.hashSalt = r.hashSalt;
        this.keySerializer = r.keySerializer;
        this.valueSerializer = r.valueSerializer;
    }

    static final Map<String, Long> preinitNamedDir(Engine engine) {
        HashRootSerializer serializer = new HashRootSerializer(Serializer.BASIC_SERIALIZER);
        HashRoot r = engine.get(1L, serializer);
        if (r != null) {
            return new HTreeMap<String, Long>(engine, 1L, Serializer.BASIC_SERIALIZER);
        }
        if (engine.isReadOnly()) {
            return Collections.unmodifiableMap(new HashMap());
        }
        long[] segmentRecids = new long[16];
        for (int i = 0; i < 16; ++i) {
            segmentRecids[i] = engine.put(new long[16][], DIR_SERIALIZER);
        }
        r = new HashRoot();
        r.hasValues = true;
        r.segmentRecids = segmentRecids;
        r.keySerializer = Serializer.BASIC_SERIALIZER;
        r.valueSerializer = Serializer.BASIC_SERIALIZER;
        engine.update(1L, r, serializer);
        return new HTreeMap<String, Long>(engine, 1L, Serializer.BASIC_SERIALIZER);
    }

    @Override
    public boolean containsKey(Object o) {
        return this.get(o) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long counter = 0L;
        for (int i = 0; i < 16; ++i) {
            try {
                this.segmentLocks[i].readLock().lock();
                long dirRecid = this.segmentRecids[i];
                counter += this.recursiveDirCount(dirRecid);
                continue;
            }
            finally {
                this.segmentLocks[i].readLock().unlock();
            }
        }
        if (counter > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)counter;
    }

    private long recursiveDirCount(long dirRecid) {
        long[][] dir = this.engine.get(dirRecid, DIR_SERIALIZER);
        long counter = 0L;
        for (long[] subdir : dir) {
            if (subdir == null) continue;
            for (long recid : subdir) {
                if (recid == 0L) continue;
                if ((recid & 1L) == 0L) {
                    counter += this.recursiveDirCount(recid >>>= 1);
                    continue;
                }
                recid >>>= 1;
                while (recid != 0L) {
                    LinkedNode<K, V> n = this.engine.get(recid, this.LN_SERIALIZER);
                    if (n != null) {
                        ++counter;
                        recid = n.next;
                        continue;
                    }
                    recid = 0L;
                }
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        int i = 0;
        if (i < 16) {
            try {
                long[][] dir;
                this.segmentLocks[i].readLock().lock();
                long dirRecid = this.segmentRecids[i];
                for (long[] d : dir = this.engine.get(dirRecid, DIR_SERIALIZER)) {
                    if (d == null) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.segmentLocks[i].readLock().unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object o) {
        if (o == null) {
            return null;
        }
        int h = this.hash(o);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].readLock().lock();
            long recid = this.segmentRecids[segment];
            for (int level = 3; level >= 0; --level) {
                long[][] dir = this.engine.get(recid, DIR_SERIALIZER);
                if (dir == null) {
                    V v = null;
                    return v;
                }
                int slot = h >>> level * 7 & 0x7F;
                if (slot >= 128) {
                    throw new InternalError();
                }
                if (dir[slot / 8] == null) {
                    V v = null;
                    return v;
                }
                recid = dir[slot / 8][slot % 8];
                if (recid == 0L) {
                    V v = null;
                    return v;
                }
                if ((recid & 1L) != 0L) {
                    recid >>>= 1;
                    while (true) {
                        LinkedNode<K, V> ln;
                        if ((ln = this.engine.get(recid, this.LN_SERIALIZER)) == null) {
                            V v = null;
                            return v;
                        }
                        if (ln.key.equals(o)) {
                            Object v = ln.value;
                            return v;
                        }
                        if (ln.next == 0L) {
                            V v = null;
                            return v;
                        }
                        recid = ln.next;
                    }
                }
                recid >>>= 1;
            }
            V v = null;
            return v;
        }
        finally {
            this.segmentLocks[segment].readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        Utils.checkMapValueIsNotCollecion(value);
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            long recid;
            int counter;
            int slot;
            Object dir;
            int level;
            long dirRecid;
            block16: {
                this.segmentLocks[segment].writeLock().lock();
                dirRecid = this.segmentRecids[segment];
                level = 3;
                while (true) {
                    dir = this.engine.get(dirRecid, DIR_SERIALIZER);
                    slot = h >>> 7 * level & 0x7F;
                    if (slot > 127) {
                        throw new InternalError();
                    }
                    if (dir == null) {
                        dir = new long[16][];
                    }
                    if (dir[slot / 8] == null) {
                        dir[slot / 8] = new long[8];
                    }
                    counter = 0;
                    recid = dir[slot / 8][slot % 8];
                    if (recid == 0L) break block16;
                    if ((recid & 1L) != 0L) break;
                    dirRecid = recid >>> 1;
                    --level;
                }
                LinkedNode<K, V> ln = this.engine.get(recid >>>= 1, this.LN_SERIALIZER);
                while (ln != null) {
                    if (ln.key.equals(key)) {
                        Object oldVal = ln.value;
                        ln = new LinkedNode(ln.next, ln.key, value);
                        this.engine.update(recid, ln, this.LN_SERIALIZER);
                        this.notify(key, oldVal, value);
                        Object v = oldVal;
                        return v;
                    }
                    recid = ln.next;
                    ln = recid == 0L ? null : this.engine.get(recid, this.LN_SERIALIZER);
                    ++counter;
                }
            }
            if (counter >= 4 && level >= 1) {
                long[][] nextDir = new long[16][];
                int pos = h >>> 7 * (level - 1) & 0x7F;
                nextDir[pos / 8] = new long[8];
                nextDir[pos / 8][pos % 8] = this.engine.put(new LinkedNode<K, V>(0L, key, value), this.LN_SERIALIZER) << 1 | 1L;
                long nodeRecid = dir[slot / 8][slot % 8] >>> 1;
                while (nodeRecid != 0L) {
                    LinkedNode<K, V> n = this.engine.get(nodeRecid, this.LN_SERIALIZER);
                    long nextRecid = n.next;
                    int pos2 = this.hash(n.key) >>> 7 * (level - 1) & 0x7F;
                    if (nextDir[pos2 / 8] == null) {
                        nextDir[pos2 / 8] = new long[8];
                    }
                    n = new LinkedNode(nextDir[pos2 / 8][pos2 % 8] >>> 1, n.key, n.value);
                    nextDir[pos2 / 8][pos2 % 8] = nodeRecid << 1 | 1L;
                    this.engine.update(nodeRecid, n, this.LN_SERIALIZER);
                    nodeRecid = nextRecid;
                }
                long nextDirRecid = this.engine.put(nextDir, DIR_SERIALIZER);
                int parentPos = h >>> 7 * level & 0x7F;
                dir[parentPos / 8][parentPos % 8] = nextDirRecid << 1 | 0L;
                this.engine.update(dirRecid, dir, DIR_SERIALIZER);
                this.notify(key, null, value);
                V v = null;
                return v;
            }
            recid = dir[slot / 8][slot % 8] >>> 1;
            long newRecid = this.engine.put(new LinkedNode<K, V>(recid, key, value), this.LN_SERIALIZER);
            dir[slot / 8][slot % 8] = newRecid << 1 | 1L;
            this.engine.update(dirRecid, dir, DIR_SERIALIZER);
            this.notify(key, null, value);
            V v = null;
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            block15: {
                long recid;
                int slot;
                Object dir;
                this.segmentLocks[segment].writeLock().lock();
                long[] dirRecids = new long[4];
                int level = 3;
                dirRecids[level] = this.segmentRecids[segment];
                while (true) {
                    dir = this.engine.get(dirRecids[level], DIR_SERIALIZER);
                    slot = h >>> 7 * level & 0x7F;
                    if (slot > 127) {
                        throw new InternalError();
                    }
                    if (dir == null) {
                        dir = new long[16][];
                    }
                    if (dir[slot / 8] == null) {
                        dir[slot / 8] = new long[8];
                    }
                    if ((recid = dir[slot / 8][slot % 8]) == 0L) break block15;
                    if ((recid & 1L) != 0L) break;
                    dirRecids[--level] = recid >>> 1;
                }
                LinkedNode<K, V> ln = this.engine.get(recid >>>= 1, this.LN_SERIALIZER);
                LinkedNode<K, V> prevLn = null;
                long prevRecid = 0L;
                while (ln != null) {
                    if (ln.key.equals(key)) {
                        if (prevLn == null) {
                            if (ln.next == 0L) {
                                this.recursiveDirDelete(h, level, dirRecids, (long[][])dir, slot);
                            } else {
                                dir[slot / 8][slot % 8] = ln.next << 1 | 1L;
                                this.engine.update(dirRecids[level], dir, DIR_SERIALIZER);
                            }
                        } else {
                            prevLn = new LinkedNode(ln.next, prevLn.key, prevLn.value);
                            this.engine.update(prevRecid, prevLn, this.LN_SERIALIZER);
                        }
                        this.engine.delete(recid, this.LN_SERIALIZER);
                        this.notify(key, ln.value, null);
                        Object v = ln.value;
                        return v;
                    }
                    prevRecid = recid;
                    prevLn = ln;
                    recid = ln.next;
                    ln = recid == 0L ? null : this.engine.get(recid, this.LN_SERIALIZER);
                }
                V v = null;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    private void recursiveDirDelete(int h, int level, long[] dirRecids, long[][] dir, int slot) {
        dir[slot / 8][slot % 8] = 0L;
        boolean allZero = true;
        for (long l : dir[slot / 8]) {
            if (l == 0L) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            dir[slot / 8] = null;
        }
        allZero = true;
        for (long[] l : dir) {
            if (l == null) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            if (level == 3) {
                this.engine.update(dirRecids[level], new long[16][], DIR_SERIALIZER);
            } else {
                this.engine.delete(dirRecids[level], DIR_SERIALIZER);
                long[][] lArray = this.engine.get(dirRecids[level + 1], DIR_SERIALIZER);
                int parentPos = h >>> 7 * (level + 1) & 0x7F;
                this.recursiveDirDelete(h, level + 1, dirRecids, lArray, parentPos);
            }
        } else {
            this.engine.update(dirRecids[level], dir, DIR_SERIALIZER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (int i = 0; i < 16; ++i) {
            try {
                this.segmentLocks[i].writeLock().lock();
                long dirRecid = this.segmentRecids[i];
                this.recursiveDirClear(dirRecid);
                this.engine.update(dirRecid, new long[16][], DIR_SERIALIZER);
                continue;
            }
            finally {
                this.segmentLocks[i].writeLock().unlock();
            }
        }
    }

    private void recursiveDirClear(long dirRecid) {
        long[][] dir = this.engine.get(dirRecid, DIR_SERIALIZER);
        if (dir == null) {
            return;
        }
        for (long[] subdir : dir) {
            if (subdir == null) continue;
            for (long recid : subdir) {
                if (recid == 0L) continue;
                if ((recid & 1L) == 0L) {
                    this.recursiveDirClear(recid >>>= 1);
                    this.engine.delete(recid, DIR_SERIALIZER);
                    continue;
                }
                recid >>>= 1;
                while (recid != 0L) {
                    LinkedNode<K, V> n = this.engine.get(recid, this.LN_SERIALIZER);
                    this.engine.delete(recid, this.LN_SERIALIZER);
                    this.notify(n.key, n.value, null);
                    recid = n.next;
                }
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return this._keySet;
    }

    @Override
    public Collection<V> values() {
        return this._values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    protected int hash(Object key) {
        int h = key.hashCode() ^ this.hashSalt;
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Utils.checkMapValueIsNotCollecion(value);
        int segment = this.hash(key) >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            if (!this.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = this.get(key);
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int segment = this.hash(key) >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            if (this.containsKey(key) && this.get(key).equals(value)) {
                this.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int segment = this.hash(key) >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            if (this.containsKey(key) && this.get(key).equals(oldValue)) {
                this.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int segment = this.hash(key) >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            if (this.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    public Map<K, V> snapshot() {
        Engine snapshot = SnapshotEngine.createSnapshotFor(this.engine);
        return new HTreeMap<K, V>(snapshot, this.rootRecid, this.defaultSerialzierForSnapshots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            Bind.MapListener<K, V>[] modListeners2 = Arrays.copyOf(this.modListeners, this.modListeners.length + 1);
            modListeners2[modListeners2.length - 1] = listener;
            this.modListeners = modListeners2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            for (int i = 0; i < this.modListeners.length; ++i) {
                if (this.modListeners[i] != listener) continue;
                this.modListeners[i] = null;
            }
        }
    }

    protected void notify(K key, V oldValue, V newValue) {
        Bind.MapListener<K, V>[] modListeners2;
        for (Bind.MapListener<K, V> listener : modListeners2 = this.modListeners) {
            if (listener == null) continue;
            listener.update(key, oldValue, newValue);
        }
    }

    public void close() {
        this.engine.close();
    }

    class Entry2
    implements Map.Entry<K, V> {
        private final K key;

        Entry2(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return HTreeMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return HTreeMap.this.put(this.key, value);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map.Entry && this.key.equals(((Map.Entry)o).getKey());
        }

        @Override
        public int hashCode() {
            Object value = HTreeMap.this.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }

    class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object key = this.currentLinkedList[this.currentLinkedListPos];
            this.moveToNext();
            return new Entry2(key);
        }
    }

    class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object value = this.currentLinkedList[this.currentLinkedListPos + 1];
            this.moveToNext();
            return value;
        }
    }

    class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object key = this.currentLinkedList[this.currentLinkedListPos];
            this.moveToNext();
            return key;
        }
    }

    abstract class HashIterator {
        protected Object[] currentLinkedList = this.findNextLinkedNode(0);
        protected int currentLinkedListPos = 0;
        private K lastReturnedKey = null;
        private int lastSegment = 0;

        HashIterator() {
        }

        public void remove() {
            Object keyToRemove = this.lastReturnedKey;
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            this.lastReturnedKey = null;
            HTreeMap.this.remove(keyToRemove);
        }

        public boolean hasNext() {
            return this.currentLinkedList != null && this.currentLinkedListPos < this.currentLinkedList.length;
        }

        protected void moveToNext() {
            this.lastReturnedKey = this.currentLinkedList[this.currentLinkedListPos];
            this.currentLinkedListPos += 2;
            if (this.currentLinkedListPos == this.currentLinkedList.length) {
                int lastHash = HTreeMap.this.hash(this.lastReturnedKey);
                this.currentLinkedList = this.advance(lastHash);
                this.currentLinkedListPos = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] advance(int lastHash) {
            int segment = lastHash >>> 28;
            try {
                HTreeMap.this.segmentLocks[segment].readLock().lock();
                long dirRecid = HTreeMap.this.segmentRecids[segment];
                int level = 3;
                while (true) {
                    int pos;
                    long[][] dir;
                    if ((dir = HTreeMap.this.engine.get(dirRecid, DIR_SERIALIZER))[(pos = lastHash >>> 7 * level & 0x7F) / 8] == null || dir[pos / 8][pos % 8] == 0L || (dir[pos / 8][pos % 8] & 1L) == 1L) {
                        lastHash = level != 0 ? (lastHash >>> 7 * level) + 1 << 7 * level : ++lastHash;
                        if (lastHash == 0) {
                            Object[] objectArray = null;
                            return objectArray;
                        }
                        break;
                    }
                    dirRecid = dir[pos / 8][pos % 8] >>> 1;
                    --level;
                }
            }
            finally {
                HTreeMap.this.segmentLocks[segment].readLock().unlock();
            }
            return this.findNextLinkedNode(lastHash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] findNextLinkedNode(int hash) {
            for (int segment = Math.max(hash >>> 28, this.lastSegment); segment < 16; ++segment) {
                try {
                    this.lastSegment = Math.max(segment, this.lastSegment);
                    HTreeMap.this.segmentLocks[segment].readLock().lock();
                    long dirRecid = HTreeMap.this.segmentRecids[segment];
                    Object[] ret = this.findNextLinkedNodeRecur(dirRecid, hash, 3);
                    if (ret != null) {
                        Object[] objectArray = ret;
                        return objectArray;
                    }
                    hash = 0;
                    continue;
                }
                finally {
                    HTreeMap.this.segmentLocks[segment].readLock().unlock();
                }
            }
            return null;
        }

        private Object[] findNextLinkedNodeRecur(long dirRecid, int newHash, int level) {
            long[][] dir = HTreeMap.this.engine.get(dirRecid, DIR_SERIALIZER);
            if (dir == null) {
                return null;
            }
            boolean first = true;
            for (int pos = newHash >>> level * 7 & 0x7F; pos < 128; ++pos) {
                long recid;
                if (dir[pos / 8] != null && (recid = dir[pos / 8][pos % 8]) != 0L) {
                    if ((recid & 1L) == 1L) {
                        recid >>= 1;
                        Object[] array = new Object[2];
                        int arrayPos = 0;
                        while (recid != 0L) {
                            LinkedNode ln = HTreeMap.this.engine.get(recid, HTreeMap.this.LN_SERIALIZER);
                            if (ln == null) {
                                recid = 0L;
                                continue;
                            }
                            if (arrayPos == array.length) {
                                array = Arrays.copyOf(array, array.length + 2);
                            }
                            array[arrayPos++] = ln.key;
                            array[arrayPos++] = ln.value;
                            recid = ln.next;
                        }
                        return array;
                    }
                    Object[] ret = this.findNextLinkedNodeRecur(recid >>= 1, first ? newHash : 0, level - 1);
                    if (ret != null) {
                        return ret;
                    }
                }
                first = false;
            }
            return null;
        }
    }

    static class HashRoot {
        long[] segmentRecids;
        boolean hasValues;
        int hashSalt;
        Serializer keySerializer;
        Serializer valueSerializer;

        HashRoot() {
        }
    }

    static class HashRootSerializer
    implements Serializer<HashRoot> {
        private Serializer defaultSerializer;

        public HashRootSerializer(Serializer defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }

        @Override
        public void serialize(DataOutput out, HashRoot value) throws IOException {
            out.writeBoolean(value.hasValues);
            out.writeInt(value.hashSalt);
            for (int i = 0; i < 16; ++i) {
                Utils.packLong(out, value.segmentRecids[i]);
            }
            this.defaultSerializer.serialize(out, value.keySerializer);
            this.defaultSerializer.serialize(out, value.valueSerializer);
        }

        @Override
        public HashRoot deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            HashRoot r = new HashRoot();
            r.hasValues = in.readBoolean();
            r.hashSalt = in.readInt();
            r.segmentRecids = new long[16];
            for (int i = 0; i < 16; ++i) {
                r.segmentRecids[i] = Utils.unpackLong(in);
            }
            r.keySerializer = (Serializer)this.defaultSerializer.deserialize(in, -1);
            r.valueSerializer = (Serializer)this.defaultSerializer.deserialize(in, -1);
            return r;
        }
    }

    protected static class LinkedNode<K, V> {
        final K key;
        final V value;
        final long next;

        LinkedNode(long next, K key, V value) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

