/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.NavigableSet;
import java.util.Set;
import org.mapdb.AsyncWriteEngine;
import org.mapdb.BTreeMap;
import org.mapdb.CacheHardRef;
import org.mapdb.CacheHashTable;
import org.mapdb.CacheLRU;
import org.mapdb.CacheWeakSoftRef;
import org.mapdb.CompressLZF;
import org.mapdb.DB;
import org.mapdb.EncryptionXTEA;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.SnapshotEngine;
import org.mapdb.StorageAppend;
import org.mapdb.StorageDirect;
import org.mapdb.StorageJournaled;
import org.mapdb.TxMaker;
import org.mapdb.Utils;
import org.mapdb.Volume;

public class DBMaker {
    protected static final byte CACHE_DISABLE = 0;
    protected static final byte CACHE_FIXED_HASH_TABLE = 1;
    protected static final byte CACHE_HARD_REF = 2;
    protected static final byte CACHE_WEAK_REF = 3;
    protected static final byte CACHE_SOFT_REF = 4;
    protected static final byte CACHE_LRU = 5;
    protected byte _cache = 1;
    protected int _cacheSize = 32768;
    protected File _file;
    protected boolean _journalEnabled = true;
    protected boolean _asyncWriteEnabled = true;
    protected int _asyncFlushDelay = 100;
    protected boolean _deleteFilesAfterClose = false;
    protected boolean _readOnly = false;
    protected boolean _closeOnJvmShutdown = false;
    protected boolean _compressionEnabled = false;
    protected byte[] _xteaEncryptionKey = null;
    protected boolean _freeSpaceReclaimDisabled = false;
    protected boolean _checksumEnabled = false;
    protected boolean _ifInMemoryUseDirectBuffer = false;
    protected boolean _failOnWrongHeader = false;
    protected boolean _RAF = false;
    protected boolean _powerSavingMode = false;
    protected boolean _appendStorage;

    protected DBMaker() {
    }

    public static DBMaker newMemoryDB() {
        DBMaker m = new DBMaker();
        m._file = null;
        return m;
    }

    public static DBMaker newDirectMemoryDB() {
        DBMaker m = new DBMaker();
        m._file = null;
        m._ifInMemoryUseDirectBuffer = true;
        return m;
    }

    public static DBMaker newAppendFileDB(File file) {
        DBMaker m = new DBMaker();
        m._file = file;
        m._appendStorage = true;
        return m;
    }

    public static <K, V> BTreeMap<K, V> newTempTreeMap() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().journalDisable().make().getTreeMap("temp");
    }

    public static <K, V> HTreeMap<K, V> newTempHashMap() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().journalDisable().make().getHashMap("temp");
    }

    public static <K> NavigableSet<K> newTempTreeSet() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().journalDisable().make().getTreeSet("temp");
    }

    public static <K> Set<K> newTempHashSet() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().journalDisable().make().getHashSet("temp");
    }

    public static DBMaker newTempFileDB() {
        try {
            return DBMaker.newFileDB(File.createTempFile("mapdb-temp", "db"));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static DBMaker newFileDB(File file) {
        DBMaker m = new DBMaker();
        m._file = file;
        return m;
    }

    public DBMaker journalDisable() {
        this._journalEnabled = false;
        return this;
    }

    public DBMaker cacheDisable() {
        this._cache = 0;
        return this;
    }

    public DBMaker cacheHardRefEnable() {
        this._cache = (byte)2;
        return this;
    }

    public DBMaker cacheWeakRefEnable() {
        this._cache = (byte)3;
        return this;
    }

    public DBMaker cacheSoftRefEnable() {
        this._cache = (byte)4;
        return this;
    }

    public DBMaker cacheLRUEnable() {
        this._cache = (byte)5;
        return this;
    }

    public DBMaker randomAccessFileEnable() {
        this._RAF = true;
        return this;
    }

    public DBMaker randomAccessFileEnableIfNeeded() {
        this._RAF = !Utils.JVMSupportsLargeMappedFiles();
        return this;
    }

    public DBMaker cacheSize(int cacheSize) {
        this._cacheSize = cacheSize;
        return this;
    }

    public DBMaker asyncWriteDisable() {
        this._asyncWriteEnabled = false;
        return this;
    }

    public DBMaker asyncFlushDelay(int delay) {
        this._asyncFlushDelay = delay;
        return this;
    }

    public DBMaker deleteFilesAfterClose() {
        this._deleteFilesAfterClose = true;
        return this;
    }

    public DBMaker closeOnJvmShutdown() {
        this._closeOnJvmShutdown = true;
        return this;
    }

    public DBMaker compressionEnable() {
        this._compressionEnabled = true;
        return this;
    }

    public DBMaker encryptionEnable(String password) {
        try {
            return this.encryptionEnable(password.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public DBMaker encryptionEnable(byte[] password) {
        this._xteaEncryptionKey = password;
        return this;
    }

    public DBMaker checksumEnable() {
        this._checksumEnabled = true;
        return this;
    }

    public DBMaker readOnly() {
        this._readOnly = true;
        return this;
    }

    public DBMaker freeSpaceReclaimDisable() {
        this._freeSpaceReclaimDisabled = true;
        return this;
    }

    public DBMaker powerSavingModeEnable() {
        this._powerSavingMode = true;
        return this;
    }

    public DB make() {
        return new DB(this.makeEngine());
    }

    public TxMaker makeTxMaker() {
        return new TxMaker(this.makeEngine());
    }

    public Engine makeEngine() {
        Engine engine;
        if (this._readOnly && this._file == null) {
            throw new UnsupportedOperationException("Can not open in-memory DB in read-only mode.");
        }
        if (this._readOnly && !this._file.exists()) {
            throw new UnsupportedOperationException("Can not open non-existing file in read-only mode.");
        }
        if (!this._appendStorage) {
            Volume.Factory folFac = this._file == null ? Volume.memoryFactory(this._ifInMemoryUseDirectBuffer) : Volume.fileFactory(this._readOnly, this._RAF, this._file);
            engine = this._journalEnabled ? new StorageJournaled(folFac, this._freeSpaceReclaimDisabled, this._deleteFilesAfterClose, this._failOnWrongHeader, this._readOnly) : new StorageDirect(folFac, this._freeSpaceReclaimDisabled, this._deleteFilesAfterClose, this._failOnWrongHeader, this._readOnly);
        } else {
            if (this._file == null) {
                throw new UnsupportedOperationException("Append Storage format is not supported with in-memory dbs");
            }
            engine = new StorageAppend(this._file, this._RAF, this._readOnly, !this._journalEnabled);
        }
        AsyncWriteEngine engineAsync = null;
        if (this._asyncWriteEnabled && !this._readOnly) {
            engineAsync = new AsyncWriteEngine(engine, !this._journalEnabled, this._powerSavingMode, this._asyncFlushDelay);
            engine = engineAsync;
        }
        if (this._checksumEnabled) {
            engine = new EngineWrapper.ByteTransformEngine(engine, Serializer.CRC32_CHECKSUM);
        }
        if (this._xteaEncryptionKey != null) {
            engine = new EngineWrapper.ByteTransformEngine(engine, new EncryptionXTEA(this._xteaEncryptionKey));
        }
        if (this._compressionEnabled) {
            engine = new EngineWrapper.ByteTransformEngine(engine, CompressLZF.SERIALIZER);
        }
        engine = new SnapshotEngine(engine);
        if (this._cache == 0) {
            // empty if block
        }
        if (this._cache == 1) {
            engine = new CacheHashTable(engine, this._cacheSize);
        } else if (this._cache == 2) {
            engine = new CacheHardRef(engine, this._cacheSize);
        } else if (this._cache == 3) {
            engine = new CacheWeakSoftRef(engine, true);
        } else if (this._cache == 4) {
            engine = new CacheWeakSoftRef(engine, false);
        } else if (this._cache == 5) {
            engine = new CacheLRU(engine, this._cacheSize);
        }
        if (this._readOnly) {
            engine = new EngineWrapper.ReadOnlyEngine(engine);
        }
        if (engineAsync != null) {
            engineAsync.setParentEngineReference(engine);
        }
        if (this._closeOnJvmShutdown) {
            final Engine engine2 = engine;
            Runtime.getRuntime().addShutdownHook(new Thread("JDBM shutdown"){

                @Override
                public void run() {
                    if (!engine2.isClosed()) {
                        engine2.close();
                    }
                }
            });
        }
        return engine;
    }
}

