/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.Engine;
import org.mapdb.HTreeMap;
import org.mapdb.Queues;
import org.mapdb.Serializer;
import org.mapdb.SerializerPojo;
import org.mapdb.SnapshotEngine;
import org.mapdb.Utils;

public class DB {
    protected Engine engine;
    protected Map<String, WeakReference<?>> collections = new HashMap();
    protected Map<String, Long> nameDir;
    protected Serializer<?> defaultSerializer;

    public DB(final Engine engine) {
        this.engine = engine;
        CopyOnWriteArrayList<SerializerPojo.ClassInfo> classInfos = engine.get(2L, SerializerPojo.serializer);
        this.defaultSerializer = new SerializerPojo(classInfos){

            @Override
            protected void saveClassInfo() {
                engine.update(2L, this.registered, SerializerPojo.serializer);
            }
        };
        this.nameDir = HTreeMap.preinitNamedDir(engine);
    }

    public synchronized <K, V> HTreeMap<K, V> getHashMap(String name) {
        this.checkNotClosed();
        HTreeMap ret = (HTreeMap)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        Long recid = this.nameDir.get(name);
        if (recid != null) {
            ret = new HTreeMap(this.engine, recid, this.defaultSerializer);
            if (!ret.hasValues) {
                throw new ClassCastException("Collection is Set, not Map");
            }
        } else {
            ret = new HTreeMap(this.engine, true, Utils.RANDOM.nextInt(), this.defaultSerializer, null, null);
            this.nameDir.put(name, ret.rootRecid);
        }
        this.collections.put(name, new WeakReference(ret));
        return ret;
    }

    public synchronized <K, V> HTreeMap<K, V> createHashMap(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.checkNameNotExists(name);
        HTreeMap<K, V> ret = new HTreeMap<K, V>(this.engine, true, Utils.RANDOM.nextInt(), this.defaultSerializer, keySerializer, valueSerializer);
        this.nameDir.put(name, ret.rootRecid);
        this.collections.put(name, new WeakReference<HTreeMap<K, V>>(ret));
        return ret;
    }

    public synchronized <K> Set<K> getHashSet(String name) {
        this.checkNotClosed();
        Set ret = (Set)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        Long recid = this.nameDir.get(name);
        if (recid != null) {
            HTreeMap m = new HTreeMap(this.engine, recid, this.defaultSerializer);
            if (m.hasValues) {
                throw new ClassCastException("Collection is Map, not Set");
            }
            ret = m.keySet();
        } else {
            HTreeMap m = new HTreeMap(this.engine, false, Utils.RANDOM.nextInt(), this.defaultSerializer, null, null);
            ret = m.keySet();
            this.nameDir.put(name, m.rootRecid);
        }
        this.collections.put(name, new WeakReference(ret));
        return ret;
    }

    public synchronized <K> Set<K> createHashSet(String name, Serializer<K> serializer) {
        this.checkNameNotExists(name);
        HTreeMap ret = new HTreeMap(this.engine, false, Utils.RANDOM.nextInt(), this.defaultSerializer, serializer, null);
        this.nameDir.put(name, ret.rootRecid);
        Set<K> ret2 = ret.keySet();
        this.collections.put(name, new WeakReference<Set<K>>(ret2));
        return ret2;
    }

    public synchronized <K, V> BTreeMap<K, V> getTreeMap(String name) {
        this.checkNotClosed();
        BTreeMap ret = (BTreeMap)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        Long recid = this.nameDir.get(name);
        if (recid != null) {
            ret = new BTreeMap(this.engine, recid, this.defaultSerializer);
            if (!ret.hasValues) {
                throw new ClassCastException("Collection is Set, not Map");
            }
        } else {
            ret = new BTreeMap(this.engine, 32, true, false, this.defaultSerializer, null, null, null);
            this.nameDir.put(name, ret.treeRecid);
        }
        this.collections.put(name, new WeakReference(ret));
        return ret;
    }

    public synchronized <K, V> BTreeMap<K, V> createTreeMap(String name, int nodeSize, boolean valuesStoredOutsideNodes, BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> comparator) {
        this.checkNameNotExists(name);
        BTreeMap<K, V> ret = new BTreeMap<K, V>(this.engine, nodeSize, true, valuesStoredOutsideNodes, this.defaultSerializer, keySerializer, valueSerializer, comparator);
        this.nameDir.put(name, ret.treeRecid);
        this.collections.put(name, new WeakReference<BTreeMap<K, V>>(ret));
        return ret;
    }

    public Map<String, Long> getNameDir() {
        return this.nameDir;
    }

    public synchronized <K> NavigableSet<K> getTreeSet(String name) {
        this.checkNotClosed();
        Set ret = (NavigableSet)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        Long recid = this.nameDir.get(name);
        if (recid != null) {
            BTreeMap m = new BTreeMap(this.engine, recid, this.defaultSerializer);
            if (m.hasValues) {
                throw new ClassCastException("Collection is Map, not Set");
            }
            ret = m.keySet();
        } else {
            BTreeMap m = new BTreeMap(this.engine, 32, false, false, this.defaultSerializer, null, null, null);
            this.nameDir.put(name, m.treeRecid);
            ret = m.keySet();
        }
        this.collections.put(name, new WeakReference<NavigableSet>((NavigableSet)ret));
        return ret;
    }

    public synchronized <K> NavigableSet<K> createTreeSet(String name, int nodeSize, BTreeKeySerializer<K> serializer, Comparator<K> comparator) {
        this.checkNameNotExists(name);
        BTreeMap ret = new BTreeMap(this.engine, nodeSize, false, false, this.defaultSerializer, serializer, null, comparator);
        this.nameDir.put(name, ret.treeRecid);
        Set ret2 = ret.keySet();
        this.collections.put(name, new WeakReference<Set>(ret2));
        return ret2;
    }

    public synchronized <E> Queue<E> getQueue(String name) {
        Long recid = this.nameDir.get(name);
        if (recid == null) {
            recid = Queues.createQueue(this.engine, this.getDefaultSerializer(), this.getDefaultSerializer());
            this.nameDir.put(name, recid);
        }
        Queues.Queue ret = Queues.getQueue(this.engine, this.getDefaultSerializer(), recid);
        this.collections.put(name, new WeakReference(ret));
        return ret;
    }

    public synchronized <E> Queue<E> getStack(String name) {
        Long recid = this.nameDir.get(name);
        if (recid == null) {
            recid = Queues.createStack(this.engine, this.getDefaultSerializer(), this.getDefaultSerializer(), true);
            this.nameDir.put(name, recid);
        }
        Queues.Stack ret = Queues.getStack(this.engine, this.getDefaultSerializer(), recid);
        this.collections.put(name, new WeakReference(ret));
        return ret;
    }

    public synchronized <E> Queue<E> getCircularQueue(String name) {
        Long recid = this.nameDir.get(name);
        if (recid == null) {
            recid = Queues.createCircularQueue(this.engine, this.getDefaultSerializer(), this.getDefaultSerializer(), 1000000L);
            this.nameDir.put(name, recid);
        }
        Queues.CircularQueue ret = Queues.getCircularQueue(this.engine, this.getDefaultSerializer(), recid);
        this.collections.put(name, new WeakReference(ret));
        return ret;
    }

    public synchronized <E> Queue<E> createQueue(String name, Serializer<E> serializer) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        Long recid = Queues.createQueue(this.engine, this.getDefaultSerializer(), serializer);
        this.nameDir.put(name, recid);
        return this.getQueue(name);
    }

    public synchronized <E> Queue<E> createStack(String name, Serializer<E> serializer, boolean useLocks) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        Long recid = Queues.createStack(this.engine, this.getDefaultSerializer(), serializer, useLocks);
        this.nameDir.put(name, recid);
        return this.getStack(name);
    }

    public synchronized <E> Queue<E> createCircularQueue(String name, Serializer<E> serializer, long size) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        Long recid = Queues.createCircularQueue(this.engine, this.getDefaultSerializer(), serializer, size);
        this.nameDir.put(name, recid);
        return this.getCircularQueue(name);
    }

    protected void checkNameNotExists(String name) {
        if (this.nameDir.get(name) != null) {
            throw new IllegalArgumentException("Name already used: " + name);
        }
    }

    public synchronized void close() {
        if (this.engine == null) {
            return;
        }
        this.engine.close();
        this.engine = null;
        this.collections = null;
        this.defaultSerializer = null;
    }

    protected Object getFromWeakCollection(String name) {
        WeakReference<?> r = this.collections.get(name);
        if (r == null) {
            return null;
        }
        Object o = r.get();
        if (o == null) {
            this.collections.remove(name);
        }
        return o;
    }

    protected void checkNotClosed() {
        if (this.engine == null) {
            throw new IllegalAccessError("DB was already closed");
        }
    }

    public synchronized boolean isClosed() {
        return this.engine == null;
    }

    public synchronized void commit() {
        this.checkNotClosed();
        this.engine.commit();
    }

    public synchronized void rollback() {
        this.checkNotClosed();
        this.engine.rollback();
    }

    public synchronized void compact() {
        this.engine.compact();
    }

    public synchronized DB snapshot() {
        Engine snapshot = SnapshotEngine.createSnapshotFor(this.engine);
        return new DB(snapshot);
    }

    public Serializer getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public Engine getEngine() {
        return this.engine;
    }
}

