/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Locks;
import org.mapdb.LongConcurrentLRUMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;

public class CacheLRU
extends EngineWrapper {
    protected LongMap<Object> cache;
    protected final Locks.RecidLocks locks = new Locks.SegmentedRecidLocks(16);

    public CacheLRU(Engine engine, int cacheSize) {
        this(engine, new LongConcurrentLRUMap<Object>(cacheSize, (int)((double)cacheSize * 0.8)));
    }

    public CacheLRU(Engine engine, LongMap<Object> cache) {
        super(engine);
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = super.put(value, serializer);
        try {
            this.locks.lock(recid);
            CacheLRU.checkClosed(this.cache).put(recid, value);
        }
        finally {
            this.locks.unlock(recid);
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        Object ret = this.cache.get(recid);
        if (ret != null) {
            return (A)ret;
        }
        try {
            this.locks.lock(recid);
            ret = super.get(recid, serializer);
            if (ret != null) {
                CacheLRU.checkClosed(this.cache).put(recid, ret);
            }
            Object object = ret;
            return (A)object;
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        try {
            this.locks.lock(recid);
            CacheLRU.checkClosed(this.cache).put(recid, value);
            super.update(recid, value, serializer);
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        try {
            this.locks.lock(recid);
            CacheLRU.checkClosed(this.cache).remove(recid);
            super.delete(recid, serializer);
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        try {
            this.locks.lock(recid);
            Engine engine = this.getWrappedEngine();
            LongMap<Object> cache2 = CacheLRU.checkClosed(this.cache);
            Object oldValue = this.cache.get(recid);
            if (oldValue == expectedOldValue || oldValue.equals(expectedOldValue)) {
                cache2.put(recid, newValue);
                engine.update(recid, newValue, serializer);
                boolean bl = true;
                return bl;
            }
            boolean ret = engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                cache2.put(recid, newValue);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    @Override
    public void close() {
        LongMap<Object> cache2 = this.cache;
        if (cache2 instanceof LongConcurrentLRUMap) {
            ((LongConcurrentLRUMap)cache2).destroy();
        }
        this.cache = null;
        super.close();
    }

    @Override
    public void rollback() {
        CacheLRU.checkClosed(this.cache).clear();
        super.rollback();
    }
}

