/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.WeakReference;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Fun;
import org.mapdb.Locks;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;

public class AsyncWriteEngine
extends EngineWrapper
implements Engine {
    protected static final AtomicLong threadCounter = new AtomicLong();
    protected final long threadNum = threadCounter.incrementAndGet();
    protected final BlockingQueue<Long> newRecids = new ArrayBlockingQueue<Long>(128);
    protected volatile boolean closeInProgress = false;
    protected final CountDownLatch shutdownCondition = new CountDownLatch(2);
    protected final int asyncFlushDelay;
    protected static final Object DELETED = new Object();
    protected final Locks.RecidLocks writeLocks = new Locks.LongHashMapRecidLocks();
    protected final ReentrantReadWriteLock commitLock;
    protected Throwable writerFailedException = null;
    protected final LongConcurrentHashMap<Fun.Tuple2<Object, Serializer>> items = new LongConcurrentHashMap();
    protected final Thread newRecidsThread = new Thread("MapDB prealloc #" + this.threadNum){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!AsyncWriteEngine.this.closeInProgress) {
                    if (AsyncWriteEngine.this.parentEngineWeakRef != null) {
                        if (AsyncWriteEngine.this.parentEngineWeakRef.get() == null) return;
                    }
                    if (AsyncWriteEngine.this.writerFailedException != null) {
                        return;
                    }
                    Long newRecid = AsyncWriteEngine.this.getWrappedEngine().put("", Serializer.EMPTY_SERIALIZER);
                    AsyncWriteEngine.this.newRecids.put(newRecid);
                }
                return;
            }
            catch (Throwable e) {
                AsyncWriteEngine.this.writerFailedException = e;
                return;
            }
            finally {
                AsyncWriteEngine.this.shutdownCondition.countDown();
            }
        }
    };
    protected final Thread writerThread = new Thread("MapDB writer #" + this.threadNum){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if ((iter = AsyncWriteEngine.this.items.longMapIterator()).moveToNext()) ** GOTO lbl9
                    if (AsyncWriteEngine.this.closeInProgress || AsyncWriteEngine.this.parentEngineWeakRef != null && AsyncWriteEngine.this.parentEngineWeakRef.get() == null || AsyncWriteEngine.this.writerFailedException != null) {
                        return;
                    }
                    Thread.sleep(AsyncWriteEngine.this.asyncFlushDelay);
                    continue;
lbl9:
                    // 1 sources

                    do {
                        recid = iter.key();
                        AsyncWriteEngine.this.writeLocks.lock(recid);
                        try {
                            value = iter.value();
                            if (value.a == AsyncWriteEngine.DELETED) {
                                AsyncWriteEngine.access$001(AsyncWriteEngine.this, recid, (Serializer)value.b);
                            } else {
                                AsyncWriteEngine.access$101(AsyncWriteEngine.this, recid, value.a, (Serializer)value.b);
                            }
                            AsyncWriteEngine.this.items.remove(recid, value);
                        }
                        finally {
                            AsyncWriteEngine.this.writeLocks.unlock(recid);
                        }
                    } while (iter.moveToNext());
                    continue;
                    break;
                }
                catch (Throwable e) {
                    AsyncWriteEngine.this.writerFailedException = e;
                }
            }
            finally {
                AsyncWriteEngine.this.shutdownCondition.countDown();
            }
        }
    };
    protected WeakReference<Engine> parentEngineWeakRef = null;

    protected AsyncWriteEngine(Engine engine, boolean _transactionsDisabled, boolean _powerSavingMode, int _asyncFlushDelay) {
        super(engine);
        this.newRecidsThread.setDaemon(true);
        this.writerThread.setDaemon(true);
        this.commitLock = _transactionsDisabled ? null : new ReentrantReadWriteLock();
        this.newRecidsThread.start();
        this.writerThread.start();
        this.asyncFlushDelay = _asyncFlushDelay;
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        this.checkState();
        if (this.commitLock != null) {
            this.commitLock.readLock().lock();
        }
        try {
            Long recid = this.newRecids.take();
            this.update(recid, value, serializer);
            long l = recid;
            return l;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.commitLock != null) {
                this.commitLock.readLock().unlock();
            }
        }
    }

    protected void checkState() {
        if (this.closeInProgress) {
            throw new IllegalAccessError("db has been closed");
        }
        if (this.writerFailedException != null) {
            throw new RuntimeException("Writer thread failed", this.writerFailedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        this.checkState();
        if (this.commitLock != null) {
            this.commitLock.readLock().lock();
        }
        try {
            block12: {
                Fun.Tuple2<Object, Serializer> item;
                block13: {
                    A a;
                    this.writeLocks.lock(recid);
                    try {
                        item = this.items.get(recid);
                        if (item == null) break block12;
                        if (item.a != DELETED) break block13;
                        a = null;
                        this.writeLocks.unlock(recid);
                    }
                    catch (Throwable throwable) {
                        this.writeLocks.unlock(recid);
                        throw throwable;
                    }
                    return a;
                }
                Object a = item.a;
                this.writeLocks.unlock(recid);
                return a;
            }
            A a = super.get(recid, serializer);
            this.writeLocks.unlock(recid);
            return a;
        }
        finally {
            if (this.commitLock != null) {
                this.commitLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.checkState();
        if (this.commitLock != null) {
            this.commitLock.readLock().lock();
        }
        try {
            this.writeLocks.lock(recid);
            try {
                this.items.put(recid, new Fun.Tuple2<A, Serializer<A>>(value, serializer));
            }
            finally {
                this.writeLocks.unlock(recid);
            }
        }
        finally {
            if (this.commitLock != null) {
                this.commitLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        this.checkState();
        this.writeLocks.lock(recid);
        try {
            Object oldValue;
            Fun.Tuple2<Object, Serializer> existing = this.items.get(recid);
            Object a = oldValue = existing != null ? existing.a : super.get(recid, serializer);
            if (oldValue == expectedOldValue || oldValue != null && oldValue.equals(expectedOldValue)) {
                this.items.put(recid, new Fun.Tuple2<A, Serializer<A>>(newValue, serializer));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLocks.unlock(recid);
        }
    }

    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.update(recid, DELETED, serializer);
    }

    @Override
    public void close() {
        try {
            if (this.closeInProgress) {
                return;
            }
            this.closeInProgress = true;
            Long recid = (Long)this.newRecids.poll();
            while (recid != null) {
                super.delete(recid, Serializer.EMPTY_SERIALIZER);
                recid = (Long)this.newRecids.poll();
            }
            this.shutdownCondition.await();
            super.close();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setParentEngineReference(Engine parentEngineReference) {
        this.parentEngineWeakRef = new WeakReference<Engine>(parentEngineReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.checkState();
        if (this.commitLock == null) {
            super.commit();
            return;
        }
        this.commitLock.writeLock().lock();
        try {
            while (!this.items.isEmpty()) {
                this.checkState();
                LockSupport.parkNanos(100L);
            }
            super.commit();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.checkState();
        if (this.commitLock == null) {
            throw new UnsupportedOperationException("transactions disabled");
        }
        this.commitLock.writeLock().lock();
        try {
            while (!this.items.isEmpty()) {
                LockSupport.parkNanos(100L);
            }
            super.commit();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    static /* synthetic */ void access$001(AsyncWriteEngine x0, long x1, Serializer x2) {
        super.delete(x1, x2);
    }

    static /* synthetic */ void access$101(AsyncWriteEngine x0, long x1, Object x2, Serializer x3) {
        super.update(x1, x2, x3);
    }
}

