/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import reverter.ChangesetReverter;

public class ChangesetIdQuery
extends ExtendedDialog {
    private final NumberFormat format = NumberFormat.getIntegerInstance();
    private final JFormattedTextField tcid = new JFormattedTextField(this.format);
    private final ButtonGroup bgRevertType = new ButtonGroup();
    private final JRadioButton rbFull = new JRadioButton(I18n.tr((String)"Revert changeset fully", (Object[])new Object[0]));
    private final JRadioButton rbSelection = new JRadioButton(I18n.tr((String)"Revert selection only", (Object[])new Object[0]));
    private final JRadioButton rbSelectionUndelete = new JRadioButton(I18n.tr((String)"Revert selection and restore deleted objects", (Object[])new Object[0]));
    private final JCheckBox cbNewLayer = new JCheckBox(I18n.tr((String)"Download as new layer", (Object[])new Object[0]));
    private final Color defaultForegroundColor = this.tcid.getForeground();

    public int getChangesetId() {
        try {
            return this.format.parse(this.tcid.getText()).intValue();
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public boolean isNewLayerRequired() {
        return this.cbNewLayer.isSelected();
    }

    public ChangesetReverter.RevertType getRevertType() {
        if (this.rbFull.isSelected()) {
            return ChangesetReverter.RevertType.FULL;
        }
        if (this.rbSelection.isSelected()) {
            return ChangesetReverter.RevertType.SELECTION;
        }
        if (this.rbSelectionUndelete.isSelected()) {
            return ChangesetReverter.RevertType.SELECTION_WITH_UNDELETE;
        }
        return null;
    }

    public ChangesetIdQuery() {
        super(Main.parent, I18n.tr((String)"Revert changeset", (Object[])new Object[0]), new String[]{I18n.tr((String)"Revert", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.contentInsets = new Insets(10, 10, 10, 5);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(new JLabel(I18n.tr((String)"Changeset id:", (Object[])new Object[0])));
        panel.add((Component)this.tcid, GBC.eol().fill(2));
        this.bgRevertType.add(this.rbFull);
        this.bgRevertType.add(this.rbSelection);
        this.bgRevertType.add(this.rbSelectionUndelete);
        this.rbFull.setSelected(true);
        panel.add((Component)this.rbFull, GBC.eol().insets(0, 10, 0, 0).fill(2));
        panel.add((Component)this.rbSelection, GBC.eol().fill(2));
        panel.add((Component)this.rbSelectionUndelete, GBC.eol().fill(2));
        this.cbNewLayer.setToolTipText(I18n.tr((String)"<html>Select to download data into a new data layer.<br>Unselect to download into the currently active data layer.</html>", (Object[])new Object[0]));
        panel.add((Component)this.cbNewLayer, GBC.eol().fill(2));
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds == null) {
            this.cbNewLayer.setSelected(true);
            this.cbNewLayer.setEnabled(false);
        }
        if (ds == null || ds.getAllSelected().isEmpty()) {
            this.rbSelection.setEnabled(false);
            this.rbSelectionUndelete.setEnabled(false);
        }
        this.tcid.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.idChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.idChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.idChanged();
            }

            private void idChanged() {
                if (ChangesetIdQuery.this.tcid.hasFocus()) {
                    boolean idOK = ChangesetIdQuery.this.getChangesetId() > 0;
                    ChangesetIdQuery.this.tcid.setForeground(idOK ? ChangesetIdQuery.this.defaultForegroundColor : Color.RED);
                    ((JButton)ChangesetIdQuery.this.buttons.get(0)).setEnabled(idOK);
                }
            }
        });
        this.setContent(panel);
        this.setupDialog();
        ((JButton)this.buttons.get(0)).setEnabled(false);
        this.tcid.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e != null && e.getKeyCode() == 10 && ((JButton)ChangesetIdQuery.this.buttons.get(0)).isEnabled()) {
                    ((JButton)ChangesetIdQuery.this.buttons.get(0)).doClick();
                }
            }
        });
    }
}

