/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class DownloadParentsAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;

    public DownloadParentsAction(ChosenRelation rel) {
        super(I18n.tr((String)"Download referrers", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"downloadreferrers"));
        this.putValue("ShortDescription", I18n.tr((String)"Download referrers for the chosen relation and its members.", (Object[])new Object[0]));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(rel.get() != null && Main.map.mapView.getEditLayer() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation relation = this.rel.get();
        if (relation == null) {
            return;
        }
        ArrayList<Relation> objects = new ArrayList<Relation>();
        objects.add(relation);
        objects.addAll(relation.getMemberPrimitives());
        Main.worker.submit((Runnable)new DownloadReferrersTask(Main.map.mapView.getEditLayer(), objects));
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null && Main.map.mapView.getEditLayer() != null);
    }

    protected void downloadMembers(Relation rel) {
        if (!rel.isNew()) {
            Main.worker.submit((Runnable)new DownloadRelationTask(Collections.singletonList(rel), Main.map.mapView.getEditLayer()));
        }
    }

    protected void downloadIncomplete(Relation rel) {
        if (rel.isNew()) {
            return;
        }
        HashSet ret = new HashSet();
        ret.addAll(rel.getIncompleteMembers());
        if (ret.isEmpty()) {
            return;
        }
        Main.worker.submit((Runnable)new DownloadRelationMemberTask(Collections.singletonList(rel), ret, Main.map.mapView.getEditLayer()));
    }
}

