/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class WikipediaCopyTemplate {
    private static final List<CoordCopyTemplate> TEMPLATES = Arrays.asList(new CoordCopyTemplate(I18n.tr((String)"Copy {0} template", (Object[])new Object[]{"{{Coordinate}}"}), "wikipedia-coordinate", "{{Coordinate|NS={lat}|EW={lon}|type=landmark|region=}}"), new CoordCopyTemplate(I18n.tr((String)"Copy {0} template", (Object[])new Object[]{"{{Coord}}"}), "wikipedia-coord", "{{Coord|{lat}|{lon}}}"), new CoordCopyTemplate(I18n.tr((String)"Copy {0} template", (Object[])new Object[]{"{{Location dec}}"}), "wikipedia-location-dec", "{{Location dec|{lat}|{lon}}}"), new CoordCopyTemplate(I18n.tr((String)"Copy {0} template", (Object[])new Object[]{"{{Object location dec}}"}), "wikipedia-object-location-dec", "{{Object location dec|{lat}|{lon}}}"));

    public WikipediaCopyTemplate() {
        JosmAction previous = Main.main.menu.copyCoordinates;
        for (CoordCopyTemplate t : TEMPLATES) {
            MainMenu.addAfter((JMenu)Main.main.menu.editMenu, (JosmAction)t, (boolean)false, (JosmAction)previous);
            previous = t;
        }
    }

    private static class CoordCopyTemplate
    extends JosmAction {
        protected final String pattern;

        public CoordCopyTemplate(String name, String toolbarId, String pattern) {
            super(name, "dialogs/wikipedia", null, null, false, toolbarId, true);
            this.pattern = pattern;
        }

        public void actionPerformed(ActionEvent e) {
            Node node = this.getSelectedNode();
            if (node == null) {
                return;
            }
            Utils.copyToClipboard((String)this.pattern.replace("{lat}", Double.toString(node.getCoor().lat())).replace("{lon}", Double.toString(node.getCoor().lon())));
        }

        protected void updateEnabledState() {
            this.setEnabled(this.getSelectedNode() != null);
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
            this.updateEnabledState();
        }

        protected Node getSelectedNode() {
            if (CoordCopyTemplate.getCurrentDataSet() == null || CoordCopyTemplate.getCurrentDataSet().getSelected() == null) {
                return null;
            }
            SubclassFilteredCollection nodes = Utils.filteredCollection((Collection)CoordCopyTemplate.getCurrentDataSet().getSelected(), Node.class);
            return nodes.isEmpty() ? null : (Node)nodes.iterator().next();
        }
    }
}

