/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.osgeo.proj4j.io.CSVRecordParser;
import org.osgeo.proj4j.io.MetaCRSTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaCRSTestFileReader {
    public static final int COL_COUNT = 19;
    private File file;
    private CSVRecordParser lineParser = new CSVRecordParser();

    public MetaCRSTestFileReader(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaCRSTestCase> readTests() throws IOException {
        LineNumberReader lineReader = new LineNumberReader(new FileReader(this.file));
        List<MetaCRSTestCase> tests = null;
        try {
            tests = this.parseFile(lineReader);
        }
        finally {
            lineReader.close();
        }
        return tests;
    }

    private List<MetaCRSTestCase> parseFile(LineNumberReader lineReader) throws IOException {
        String line;
        ArrayList<MetaCRSTestCase> tests = new ArrayList<MetaCRSTestCase>();
        boolean isHeaderRead = false;
        while ((line = lineReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (!isHeaderRead) {
                isHeaderRead = true;
                continue;
            }
            tests.add(this.parseTest(line));
        }
        return tests;
    }

    private MetaCRSTestCase parseTest(String line) {
        String[] cols = this.lineParser.parse(line);
        if (cols.length != 19) {
            throw new IllegalStateException("Expected 19 columns in file, but found " + cols.length);
        }
        String testName = cols[0];
        String testMethod = cols[1];
        String srcCrsAuth = cols[2];
        String srcCrs = cols[3];
        String tgtCrsAuth = cols[4];
        String tgtCrs = cols[5];
        double srcOrd1 = MetaCRSTestFileReader.parseNumber(cols[6]);
        double srcOrd2 = MetaCRSTestFileReader.parseNumber(cols[7]);
        double srcOrd3 = MetaCRSTestFileReader.parseNumber(cols[8]);
        double tgtOrd1 = MetaCRSTestFileReader.parseNumber(cols[9]);
        double tgtOrd2 = MetaCRSTestFileReader.parseNumber(cols[10]);
        double tgtOrd3 = MetaCRSTestFileReader.parseNumber(cols[11]);
        double tolOrd1 = MetaCRSTestFileReader.parseNumber(cols[12]);
        double tolOrd2 = MetaCRSTestFileReader.parseNumber(cols[13]);
        double tolOrd3 = MetaCRSTestFileReader.parseNumber(cols[14]);
        String using = cols[15];
        String dataSource = cols[16];
        String dataCmnts = cols[17];
        String maintenanceCmnts = cols[18];
        return new MetaCRSTestCase(testName, testMethod, srcCrsAuth, srcCrs, tgtCrsAuth, tgtCrs, srcOrd1, srcOrd2, srcOrd3, tgtOrd1, tgtOrd2, tgtOrd3, tolOrd1, tolOrd2, tolOrd3, using, dataSource, dataCmnts, maintenanceCmnts);
    }

    private static double parseNumber(String numStr) {
        if (numStr == null || numStr.length() == 0) {
            return Double.NaN;
        }
        return Double.parseDouble(numStr);
    }
}

