/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.opengis.metadata.citation.Citation;

abstract class GeoToolsUnitFormat
extends UnitFormat {
    GeoToolsUnitFormat() {
    }

    public static UnitFormat getInstance(Citation citation) {
        if (CRS.equalsIgnoreMetadata(Citations.ESRI, citation)) {
            return new ESRIFormat();
        }
        return new EPSGFormat();
    }

    static class ESRIFormat
    extends UnitFormat.DefaultFormat {
        private static final long serialVersionUID = 5769662824845469523L;

        public ESRIFormat() {
            this.label(NonSI.DEGREE_ANGLE, "Degree");
            this.label(SI.METER, "Meter");
            this.label(SI.METER.times(0.3047997101815088), "Foot_Gold_Coast");
            this.label(NonSI.FOOT, "Foot");
            this.label(NonSI.FOOT_SURVEY_US, "Foot_US");
        }
    }

    static class EPSGFormat
    extends BaseGT2Format {
        private static final long serialVersionUID = -1207705344688824557L;

        public EPSGFormat() {
            this.label(NonSI.DEGREE_ANGLE, "degree");
        }
    }

    static abstract class BaseGT2Format
    extends UnitFormat.DefaultFormat {
        public BaseGT2Format() {
            Unit<Angle> forceInit = Units.SEXAGESIMAL_DMS;
            UnitFormat.DefaultFormat base = (UnitFormat.DefaultFormat)UnitFormat.getInstance();
            Set<Unit<?>> nonSiUnits = NonSI.getInstance().getUnits();
            for (Unit<?> unit : nonSiUnits) {
                String name = base.nameFor(unit);
                if (name == null) continue;
                this.label(unit, name);
            }
            Set<Unit<?>> siUnits = NonSI.getInstance().getUnits();
            for (Unit<?> unit : siUnits) {
                String name = base.nameFor(unit);
                if (name == null) continue;
                this.label(unit, name);
            }
            for (Field field : Units.class.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Unit.class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    Unit unit = (Unit)field.get(null);
                    String name = base.nameFor(unit);
                    if (name == null) continue;
                    this.label(unit, name);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }
}

