/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.type.FeatureType;

public class FeatureReaderIterator<F extends Feature>
implements Iterator<F> {
    FeatureReader<? extends FeatureType, F> reader;

    public FeatureReaderIterator(FeatureReader<? extends FeatureType, F> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (Exception e) {
            this.close();
            return false;
        }
    }

    @Override
    public F next() {
        if (this.reader == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        try {
            return this.reader.next();
        }
        catch (IOException io) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not obtain the next feature:" + io);
            problem.initCause(io);
            throw problem;
        }
        catch (IllegalAttributeException create) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not create the next feature:" + create);
            problem.initCause(create);
            throw problem;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Modification of contents is not supported");
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = null;
        }
    }
}

