/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.measure.unit.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.operation.transform.LogarithmicTransform1D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.NumberRange;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

public class GridCoverageBuilder {
    private GeneralEnvelope envelope;
    private NumberRange<? extends Number> range;
    private static final NumberRange<Integer> DEFAULT_RANGE = NumberRange.create((int)0, (boolean)true, (int)256, (boolean)false);
    protected final List<Variable> variables;
    private int width;
    private int height;
    private BufferedImage image;
    private GridCoverage2D coverage;
    private final GridCoverageFactory factory;

    public GridCoverageBuilder() {
        this(CoverageFactoryFinder.getGridCoverageFactory(null));
    }

    public GridCoverageBuilder(GridCoverageFactory factory) {
        this.factory = factory;
        this.variables = new ArrayList<Variable>();
        this.width = 256;
        this.height = 256;
    }

    private static GeneralEnvelope wrap(Envelope envelope) {
        return envelope == null || envelope instanceof GeneralEnvelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.envelope != null ? this.envelope.getCoordinateReferenceSystem() : DefaultGeographicCRS.WGS84;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws IllegalArgumentException {
        if (this.envelope == null) {
            if (crs != null) {
                this.envelope = GridCoverageBuilder.wrap(CRS.getEnvelope((CoordinateReferenceSystem)crs));
                if (this.envelope == null) {
                    this.envelope = new GeneralEnvelope(crs);
                    this.envelope.setToNull();
                }
            }
        } else {
            try {
                this.envelope = GridCoverageBuilder.wrap(CRS.transform((Envelope)this.envelope, (CoordinateReferenceSystem)crs));
            }
            catch (TransformException exception) {
                throw new IllegalArgumentException(Errors.format((int)62), exception);
            }
        }
        this.coverage = null;
    }

    public void setCoordinateReferenceSystem(String code) throws IllegalArgumentException {
        CoordinateReferenceSystem crs;
        try {
            crs = CRS.decode((String)code, (boolean)true);
        }
        catch (FactoryException exception) {
            throw new IllegalArgumentException(Errors.format((int)62), exception);
        }
        this.setCoordinateReferenceSystem(crs);
    }

    public Envelope getEnvelope() {
        if (this.envelope != null) {
            return this.envelope.clone();
        }
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        Envelope candidate = CRS.getEnvelope((CoordinateReferenceSystem)crs);
        if (candidate == null) {
            GeneralEnvelope copy = new GeneralEnvelope(crs);
            copy.setToNull();
            candidate = copy;
        }
        return candidate;
    }

    public void setEnvelope(Envelope envelope) throws IllegalArgumentException {
        if (this.envelope != null) {
            try {
                envelope = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)this.envelope.getCoordinateReferenceSystem());
            }
            catch (TransformException exception) {
                throw new IllegalArgumentException(Errors.format((int)62), exception);
            }
        }
        this.envelope = new GeneralEnvelope(envelope);
        this.coverage = null;
    }

    public void setEnvelope(double ... ordinates) throws IllegalArgumentException {
        GeneralEnvelope envelope = this.envelope;
        if (envelope == null) {
            envelope = new GeneralEnvelope(ordinates.length / 2);
        }
        envelope.setEnvelope(ordinates);
        this.envelope = envelope;
    }

    public NumberRange<? extends Number> getSampleRange() {
        return this.range != null ? this.range : DEFAULT_RANGE;
    }

    public void setSampleRange(NumberRange<? extends Number> range) {
        this.range = range;
        this.coverage = null;
    }

    public void setSampleRange(int lower, int upper) {
        this.setSampleRange((NumberRange<? extends Number>)NumberRange.create((int)lower, (boolean)true, (int)upper, (boolean)false));
    }

    public Dimension getImageSize() {
        return new Dimension(this.width, this.height);
    }

    public void setImageSize(Dimension size) {
        this.width = size.width;
        this.height = size.height;
        this.image = null;
        this.coverage = null;
    }

    public void setImageSize(int width, int height) {
        this.setImageSize(new Dimension(width, height));
    }

    public Variable newVariable(CharSequence name, Unit<?> units) {
        Variable variable = new Variable(name, units);
        this.variables.add(variable);
        return variable;
    }

    public BufferedImage getBufferedImage() {
        if (this.image == null) {
            int numBands = this.variables.size();
            if (numBands == 0) {
                this.image = new BufferedImage(this.width, this.height, 10);
            } else {
                GridSampleDimension sd = this.variables.get(0).getSampleDimension();
                ColorModel cm = numBands == 1 ? sd.getColorModel() : sd.getColorModel(0, numBands);
                WritableRaster raster = cm.createCompatibleWritableRaster(this.width, this.height);
                this.image = new BufferedImage(cm, raster, false, null);
            }
        }
        return this.image;
    }

    public void setBufferedImage(BufferedImage image) {
        this.setImageSize(image.getWidth(), image.getHeight());
        this.image = image;
        this.coverage = null;
    }

    public void setBufferedImage(File file) throws IOException {
        this.setBufferedImage(ImageIO.read(file));
    }

    public void setBufferedImage(Random random) {
        this.image = null;
        BufferedImage image = this.getBufferedImage();
        WritableRaster raster = image.getRaster();
        ColorModel model = image.getColorModel();
        int size = model instanceof IndexColorModel ? ((IndexColorModel)model).getMapSize() : 65536;
        int i = raster.getWidth();
        while (--i >= 0) {
            int j = raster.getHeight();
            while (--j >= 0) {
                raster.setSample(i, j, 0, random.nextInt(size));
            }
        }
    }

    public GridCoverage2D getGridCoverage2D() {
        if (this.coverage == null) {
            GridSampleDimension[] bands;
            BufferedImage image = this.getBufferedImage();
            Envelope envelope = this.getEnvelope();
            if (this.variables.isEmpty()) {
                bands = null;
            } else {
                bands = new GridSampleDimension[this.variables.size()];
                for (int i = 0; i < bands.length; ++i) {
                    bands[i] = this.variables.get(i).getSampleDimension();
                }
            }
            this.coverage = this.factory.create(null, (RenderedImage)image, envelope, bands, null, null);
        }
        return this.coverage;
    }

    public class Variable {
        private final CharSequence name;
        private final Unit<?> units;
        private final Map<Integer, CharSequence> nodata;
        private MathTransform1D transform;
        private GridSampleDimension sampleDimension;

        protected Variable(CharSequence name, Unit<?> units) {
            this.name = name;
            this.units = units;
            this.nodata = new TreeMap<Integer, CharSequence>();
        }

        public MathTransform1D getTransform() {
            return this.transform;
        }

        public void setTransform(MathTransform1D transform) {
            this.transform = transform;
            this.sampleDimension = null;
        }

        public void setLinearTransform(double scale, double offset) {
            this.setTransform((MathTransform1D)LinearTransform1D.create((double)scale, (double)offset));
        }

        public void setLogarithmicTransform(double base, double offset) {
            this.setTransform(LogarithmicTransform1D.create((double)base, (double)offset));
        }

        public void addNodataValue(CharSequence name, int value) throws IllegalArgumentException {
            Integer key = value;
            CharSequence old = this.nodata.put(key, name);
            if (old != null) {
                this.nodata.put(key, old);
                throw new IllegalArgumentException(Errors.format((int)58, (Object)"value", (Object)key));
            }
            this.sampleDimension = null;
        }

        public GridSampleDimension getSampleDimension() {
            if (this.sampleDimension == null) {
                NumberRange range = GridCoverageBuilder.this.getSampleRange();
                int lower = (int)Math.floor(range.getMinimum(true));
                int upper = (int)Math.ceil(range.getMaximum(false));
                Category[] categories = new Category[this.nodata.size() + 1];
                int i = 0;
                for (Map.Entry<Integer, CharSequence> entry : this.nodata.entrySet()) {
                    int sample = entry.getKey();
                    if (sample >= lower && sample < upper) {
                        if (sample - lower <= upper - sample) {
                            lower = sample + 1;
                        } else {
                            upper = sample;
                        }
                    }
                    categories[i++] = new Category(entry.getValue(), null, sample);
                }
                range = NumberRange.create((int)lower, (boolean)true, (int)upper, (boolean)false);
                categories[i] = new Category(this.name, null, range, (MathTransform1D)(this.transform != null ? this.transform : LinearTransform1D.IDENTITY));
                this.sampleDimension = new GridSampleDimension(this.name, categories, this.units);
            }
            return this.sampleDimension;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append('[');
            if (this.name != null) {
                buffer.append('\"').append(this.name).append('\"');
                if (this.units != null) {
                    buffer.append(' ');
                }
            }
            if (this.units != null) {
                buffer.append('(').append(this.units).append(')');
            }
            return buffer.append(']').toString();
        }
    }
}

